/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase;

import com.franz.ag.AllegroGraphException;
import com.franz.ag.NamespaceRegistry;
import com.franz.ag.UPI;
import com.franz.agbase.AllegroGraphConnection;
import com.franz.agbase.BlankNode;
import com.franz.agbase.EncodedLiteral;
import com.franz.agbase.GeoExtension;
import com.franz.agbase.LiteralNode;
import com.franz.agbase.ResourceNode;
import com.franz.agbase.SNAExtension;
import com.franz.agbase.Triple;
import com.franz.agbase.TriplesIterator;
import com.franz.agbase.URINode;
import com.franz.agbase.ValueNode;
import com.franz.agbase.ValueObject;
import com.franz.agbase.impl.AGFactory;
import com.franz.agbase.impl.LiteralNodeImpl;
import com.franz.agbase.impl.TripleImpl;
import com.franz.agbase.impl.UPIImpl;
import com.franz.agbase.impl.URINodeImpl;
import com.franz.agbase.transport.AGConnector;
import com.franz.agbase.util.AGBase;
import com.franz.agbase.util.AGInternals;

public class AllegroGraph
extends AGInternals {
    private static final String version = "3.1BaseSept30";
    private static String[] versionLabels = new String[]{"AllegroGraph Version ", "      protocol level "};
    private static String xsiPrefix = "http://www.w3.org/2001/XMLSchema#";
    private URINode[] xsiCache = new URINode[]{null, null, null, null, null, null, null};
    private static final int XS_BOOLEAN = 0;
    private static final int XS_BYTE = 1;
    private static final int XS_SHORT = 2;
    private static final int XS_INT = 3;
    private static final int XS_LONG = 4;
    private static final int XS_FLOAT = 5;
    private static final int XS_DOUBLE = 6;
    private SNAExtension sna = null;
    private GeoExtension geo = null;

    public static String version() {
        return version;
    }

    public static String[] versions() {
        return new String[]{version, "7"};
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = AllegroGraph.versions();
        for (int i = 0; i < stringArray2.length; ++i) {
            System.out.println(versionLabels[i] + stringArray2[i]);
        }
    }

    public void setLookAhead(int n) {
        if (n <= -1) {
            throw new IllegalArgumentException("setLookAhead cannot be negative " + n);
        }
        this.defaultLookAhead = n;
    }

    public int getLookAhead() {
        return this.defaultLookAhead;
    }

    AllegroGraph(AllegroGraphConnection allegroGraphConnection, String string, String string2, String string3) throws AllegroGraphException {
        this.ags = allegroGraphConnection;
        this.storeName = string2;
        this.storeDirectory = string3;
        if ("".equals(string)) {
            return;
        }
        this.connect(string);
    }

    public synchronized void setAttribute(StoreAttribute storeAttribute, Object object) {
        if (this.tsx > -1) {
            throw new IllegalStateException("Allready connected");
        }
        if (this.tsx < -1) {
            throw new IllegalStateException("Closed triple store");
        }
        this.accOpts.setAttribute(storeAttribute.value(), object);
    }

    public synchronized void setAttribute(String string, Object object) {
        if (this.tsx > -1) {
            throw new IllegalStateException("Allready connected");
        }
        if (this.tsx < -1) {
            throw new IllegalStateException("Closed triple store");
        }
        this.accOpts.setAttribute(string, object);
    }

    public void syncTripleStore() throws AllegroGraphException {
        this.verifyEnabled().syncTripleStore(this);
    }

    public synchronized boolean closeTripleStore() throws AllegroGraphException {
        return this.closeTripleStore(true);
    }

    public synchronized boolean closeTripleStore(boolean bl) throws AllegroGraphException {
        if (this.tsx < 1) {
            return false;
        }
        boolean bl2 = this.verifyEnabled().closeTripleStore(this, bl);
        this.tsx = -2;
        this.ags.dropTS(this);
        return bl2;
    }

    public long loadNTriples(String string) throws AllegroGraphException {
        return this.verifyEnabled().loadNTriples(this, string, null, null, null, null, null);
    }

    public long loadNTriples(String string, Object object) throws AllegroGraphException {
        return this.verifyEnabled().loadNTriples(this, string, this.ntripleContext(object), null, null, null, null);
    }

    public long loadNTriples(String[] stringArray) throws AllegroGraphException {
        return this.verifyEnabled().loadNTriples(this, stringArray, null, null, null, null, null);
    }

    public long loadNTriples(String[] stringArray, Object object) throws AllegroGraphException {
        return this.verifyEnabled().loadNTriples(this, stringArray, this.ntripleContext(object), null, null, null, null);
    }

    public long loadNTriples(Object object, Object object2, Boolean bl, String string, Object[] objectArray) throws AllegroGraphException {
        return this.verifyEnabled().loadNTriples(this, object, this.ntripleContext(object2), null, objectArray, bl, string);
    }

    public long parseNTriples(String string) throws AllegroGraphException {
        return this.verifyEnabled().loadNTriples(this, null, null, string, null, null, null);
    }

    public long parseNTriples(String string, Object object) throws AllegroGraphException {
        return this.verifyEnabled().loadNTriples(this, null, this.ntripleContext(object), string, null, null, null);
    }

    public long parseNTriples(String string, Object object, Boolean bl, Object[] objectArray) throws AllegroGraphException {
        return this.verifyEnabled().loadNTriples(this, null, this.ntripleContext(object), string, objectArray, bl, null);
    }

    public long loadRDF(String string) throws AllegroGraphException {
        return this.verifyEnabled().loadRDF(this, string, null, null, false);
    }

    public long loadRDF(String string, Object object) throws AllegroGraphException {
        return this.verifyEnabled().loadRDF(this, string, this.ntripleContext(object), null, false);
    }

    public long loadRDF(String string, Object object, String string2) throws AllegroGraphException {
        return this.verifyEnabled().loadRDF(this, string, this.ntripleContext(object), string2, false);
    }

    public long loadRDF(String[] stringArray) throws AllegroGraphException {
        return this.verifyEnabled().loadRDF(this, stringArray, null, null, false);
    }

    public long numberOfTriples() throws AllegroGraphException {
        return this.verifyEnabled().numberOfTriples(this);
    }

    public void indexNewTriples() throws AllegroGraphException {
        try {
            this.verifyEnabled().indexTriples(this, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.throwIndexError(illegalArgumentException);
            throw illegalArgumentException;
        }
    }

    public void indexNewTriples(boolean bl) throws AllegroGraphException {
        try {
            this.verifyEnabled().indexTriples(this, bl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.throwIndexError(illegalArgumentException);
            throw illegalArgumentException;
        }
    }

    void throwIndexError(Throwable throwable) throws AllegroGraphException {
        String string = throwable.toString();
        if (-1 == string.indexOf("too-many-index-chunks-error ")) {
            return;
        }
        String string2 = " will create ";
        int n = string.indexOf(string2);
        if (n == -1) {
            return;
        }
        int n2 = string.indexOf(" ", n + string2.length());
        if (n2 == -1) {
            return;
        }
        throw new AllegroGraphException("too-many-index-chunks-error: " + string.substring(n, n2) + " files");
    }

    public void indexAllTriples() throws AllegroGraphException {
        try {
            this.verifyEnabled().indexAll(this, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.throwIndexError(illegalArgumentException);
            throw illegalArgumentException;
        }
    }

    public void indexAllTriples(boolean bl) throws AllegroGraphException {
        try {
            this.verifyEnabled().indexAll(this, bl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.throwIndexError(illegalArgumentException);
            throw illegalArgumentException;
        }
    }

    private String stringElt(String[] stringArray, int n) {
        if (stringArray == null) {
            return null;
        }
        if (n < stringArray.length) {
            return stringArray[n];
        }
        return stringArray[stringArray.length - 1];
    }

    public ValueObject newValue(UPI uPI) {
        ValueObject valueObject = null;
        if (!UPIImpl.canReference(uPI)) {
            throw new IllegalStateException("AllegroGraph Id cannot be registered:" + uPI);
        }
        try {
            Object[] objectArray = this.verifyEnabled().getParts(this, uPI);
            valueObject = this.newValue(uPI, (Integer)objectArray[0], (String)objectArray[1], (String)objectArray[2]);
        }
        catch (AllegroGraphException allegroGraphException) {
            this.failCreate("ValueObject", allegroGraphException);
        }
        if (valueObject == null) {
            this.failCreate("ValueObject", null);
        }
        return valueObject;
    }

    void failCreate(String string, Throwable throwable) {
        throw new IllegalStateException("Cannot create " + string + " -- " + throwable);
    }

    public String[] getParts(UPI uPI) throws AllegroGraphException {
        Object[] objectArray = this.verifyEnabled().getParts(this, uPI);
        return new String[]{this.typeToString((Integer)objectArray[0]), (String)objectArray[1], (String)objectArray[2]};
    }

    public UPIImpl[] getTripleParts(long l) throws AllegroGraphException {
        UPIImpl[] uPIImplArray = this.verifyEnabled().getTripleParts(this, l);
        if (uPIImplArray == null) {
            throw new AllegroGraphException("Id is not a triple: " + l);
        }
        return uPIImplArray;
    }

    public void getParts(UPI[] uPIArray, String[] stringArray, String[] stringArray2, String[] stringArray3) throws AllegroGraphException {
        int[] nArray = new int[uPIArray.length];
        this.verifyEnabled().getParts(this, uPIArray, nArray, stringArray2, stringArray3);
        for (int i = 0; i < uPIArray.length; ++i) {
            stringArray[i] = this.typeToString(nArray[i]);
        }
    }

    public int getSelectLimit() {
        return this.selectLimit;
    }

    public void setSelectLimit(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("setSelectLimit argument must be non-negative.");
        }
        this.selectLimit = n;
    }

    public BlankNode createBNode() {
        return this.createBNode(null);
    }

    public BlankNode createBNode(String string) {
        BlankNode blankNode = null;
        AllegroGraphException allegroGraphException = null;
        if (string == null) {
            string = "";
        }
        try {
            blankNode = AGFactory.makeBlankNode(this, this.verifyEnabled().newBlankNode(this, string), string);
        }
        catch (AllegroGraphException allegroGraphException2) {
            allegroGraphException = allegroGraphException2;
        }
        if (blankNode == null) {
            this.failCreate("BlankNode", allegroGraphException);
        }
        return blankNode;
    }

    public BlankNode[] createBNodes(int n) throws AllegroGraphException {
        UPIImpl[] uPIImplArray = this.verifyEnabled().newBlankNodes(this, n);
        BlankNode[] blankNodeArray = new BlankNode[n];
        for (int i = 0; i < n; ++i) {
            blankNodeArray[i] = AGFactory.makeBlankNode(this, uPIImplArray[i], null);
        }
        return blankNodeArray;
    }

    public EncodedLiteral createEncodedLiteral(long l, String string) {
        return AGFactory.makeEncodedLiteral(this, l, string);
    }

    public EncodedLiteral createEncodedLiteral(double d, String string) {
        return AGFactory.makeEncodedLiteral(this, d, string);
    }

    public EncodedLiteral createEncodedLiteral(String string, String string2) {
        return AGFactory.makeEncodedLiteral(this, string, string2);
    }

    public LiteralNode createLiteral(String string) {
        return AGFactory.makeLiteral(this, null, string, null, null, LiteralNodeImpl.LANG_NONE, null);
    }

    public LiteralNode addLiteral(String string) {
        LiteralNode literalNode = null;
        AllegroGraphException allegroGraphException = null;
        UPI uPI = null;
        try {
            UPIImpl uPIImpl = this.verifyEnabled().newLiteral((AGBase)this, string, uPI, null);
            literalNode = AGFactory.makeLiteral(this, uPIImpl, string, null, null, LiteralNodeImpl.LANG_NONE, null);
        }
        catch (AllegroGraphException allegroGraphException2) {
            allegroGraphException = allegroGraphException2;
        }
        if (literalNode == null) {
            this.failCreate("Literal", allegroGraphException);
        }
        return literalNode;
    }

    public LiteralNode createLiteral(String string, String string2) {
        return AGFactory.makeLiteral(this, null, string, null, null, LiteralNodeImpl.LANG_KNOWN, string2);
    }

    public LiteralNode addLiteral(String string, String string2) {
        LiteralNode literalNode = null;
        AllegroGraphException allegroGraphException = null;
        String string3 = null;
        try {
            UPIImpl uPIImpl = this.verifyEnabled().newLiteral((AGBase)this, string, string3, string2);
            literalNode = AGFactory.makeLiteral(this, uPIImpl, string, null, null, LiteralNodeImpl.LANG_KNOWN, string2);
        }
        catch (AllegroGraphException allegroGraphException2) {
            allegroGraphException = allegroGraphException2;
        }
        if (literalNode == null) {
            this.failCreate("languageLiteral", allegroGraphException);
        }
        return literalNode;
    }

    public LiteralNode createTypedLiteral(String string, String string2) {
        return AGFactory.makeLiteral(this, null, string, null, string2, LiteralNodeImpl.LANG_NONE, null);
    }

    public LiteralNode addTypedLiteral(String string, String string2) {
        LiteralNode literalNode = null;
        AllegroGraphException allegroGraphException = null;
        try {
            UPIImpl uPIImpl = this.verifyEnabled().newLiteral((AGBase)this, string, string2, null);
            literalNode = AGFactory.makeLiteral(this, uPIImpl, string, null, string2, LiteralNodeImpl.LANG_NONE, null);
        }
        catch (AllegroGraphException allegroGraphException2) {
            allegroGraphException = allegroGraphException2;
        }
        if (literalNode == null) {
            this.failCreate("typedLiteral", allegroGraphException);
        }
        return literalNode;
    }

    public LiteralNode createTypedLiteral(String string, UPIImpl uPIImpl) {
        return AGFactory.makeLiteral(this, null, string, uPIImpl, null, LiteralNodeImpl.LANG_NONE, null);
    }

    public LiteralNode addTypedLiteral(String string, UPI uPI) {
        LiteralNode literalNode = null;
        AllegroGraphException allegroGraphException = null;
        try {
            UPIImpl uPIImpl = this.verifyEnabled().newLiteral((AGBase)this, string, uPI, null);
            literalNode = AGFactory.makeLiteral(this, uPIImpl, string, uPI, null, LiteralNodeImpl.LANG_NONE, null);
        }
        catch (AllegroGraphException allegroGraphException2) {
            allegroGraphException = allegroGraphException2;
        }
        if (literalNode == null) {
            this.failCreate("typedLiteral", allegroGraphException);
        }
        return literalNode;
    }

    public LiteralNode addTypedLiteral(String string, URINode uRINode) {
        UPI uPI;
        if (uRINode instanceof URINodeImpl && (uPI = ((URINodeImpl)uRINode).queryAGId()) != null) {
            return this.addTypedLiteral(string, uPI);
        }
        return this.addTypedLiteral(string, ((Object)uRINode).toString());
    }

    public LiteralNode createLiteral(String string, URINode uRINode) {
        URINodeImpl uRINodeImpl;
        UPI uPI;
        if (uRINode instanceof URINodeImpl && UPIImpl.canReference(uPI = (uRINodeImpl = (URINodeImpl)uRINode).queryAGId())) {
            return AGFactory.makeLiteral(this, null, string, uPI, uRINodeImpl.queryURI(), LiteralNodeImpl.LANG_NONE, null);
        }
        return AGFactory.makeLiteral(this, null, string, null, ((Object)uRINode).toString(), LiteralNodeImpl.LANG_NONE, null);
    }

    public LiteralNode addLiteral(String string, URINode uRINode) throws AllegroGraphException {
        if (uRINode instanceof URINodeImpl) {
            URINodeImpl uRINodeImpl = (URINodeImpl)uRINode;
            UPI uPI = uRINodeImpl.queryAGId();
            uPI = uRINodeImpl.getAGId();
            if (UPIImpl.canReference(uPI)) {
                LiteralNode literalNode = this.addTypedLiteral(string, uPI);
                ((LiteralNodeImpl)literalNode).type = ((Object)uRINode).toString();
                return literalNode;
            }
        }
        return this.addTypedLiteral(string, ((Object)uRINode).toString());
    }

    public LiteralNode[] addLiterals(String[] stringArray, String[] stringArray2, String[] stringArray3) throws AllegroGraphException {
        UPIImpl[] uPIImplArray = this.verifyEnabled().newLiteral((AGBase)this, stringArray, stringArray2, stringArray3);
        LiteralNode[] literalNodeArray = new LiteralNode[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = this.stringElt(stringArray2, i);
            String string2 = this.stringElt(stringArray3, i);
            literalNodeArray[i] = AGFactory.makeLiteral(this, uPIImplArray[i], stringArray[i], null, string, LiteralNodeImpl.LANG_KNOWN, string2);
        }
        return literalNodeArray;
    }

    public URINode createURI(String string) {
        return AGFactory.makeNode(this, null, string);
    }

    public URINode addURI(String string) throws AllegroGraphException {
        return AGFactory.makeNode(this, this.verifyEnabled().newResource(this, string), string);
    }

    public UPI[] addURIIds(String[] stringArray) throws AllegroGraphException {
        return this.verifyEnabled().newResources(this, stringArray);
    }

    public URINode[] addURIs(String[] stringArray) throws AllegroGraphException {
        URINode[] uRINodeArray = new URINode[stringArray.length];
        UPIImpl[] uPIImplArray = this.verifyEnabled().newResources(this, stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            uRINodeArray[i] = AGFactory.makeNode(this, uPIImplArray[i], stringArray[i]);
        }
        return uRINodeArray;
    }

    public URINode createURI(String string, String string2) {
        return this.createURI(string + string2);
    }

    public TriplesIterator getStatements(Object object, Object object2, Object object3) throws AllegroGraphException {
        return this.verifyEnabled().getTriples(this, AllegroGraph.validRefOrWild(object), AllegroGraph.validRefOrWild(object2), AllegroGraph.validRefOrWild(object3), UPIImpl.nullUPI(), this.defaultLookAhead);
    }

    public TriplesIterator getStatements(boolean bl, Object object, Object object2, Object object3) throws AllegroGraphException {
        return this.verifyEnabled().getInfTriples(this, AllegroGraph.validRefOrWild(object), AllegroGraph.validRefOrWild(object2), AllegroGraph.validRefOrWild(object3), UPIImpl.nullUPI(), this.defaultLookAhead, bl);
    }

    public TriplesIterator getStatements(Object object, Object object2, Object object3, Object object4) throws AllegroGraphException {
        return this.verifyEnabled().getTriples(this, AllegroGraph.validRefOrWild(object), AllegroGraph.validRefOrWild(object2), AllegroGraph.validRefOrWild(object3), AllegroGraph.anyContextRef(object4, 3), this.defaultLookAhead);
    }

    public TriplesIterator getStatements(boolean bl, Object object, Object object2, Object object3, Object object4) throws AllegroGraphException {
        return this.verifyEnabled().getInfTriples(this, AllegroGraph.validRefOrWild(object), AllegroGraph.validRefOrWild(object2), AllegroGraph.validRefOrWild(object3), AllegroGraph.anyContextRef(object4, 3), this.defaultLookAhead, bl);
    }

    public TriplesIterator getStatements(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) throws AllegroGraphException {
        return this.verifyEnabled().getTriples(this, AllegroGraph.validRangeRef(object), AllegroGraph.validRangeRef(object2), AllegroGraph.validRangeRef(object3), AllegroGraph.anyContextRef(object5, 5), null, null, AllegroGraph.validRangeRef(object4), AllegroGraph.anyContextRef(object6, 6), this.defaultLookAhead);
    }

    public TriplesIterator getStatements(boolean bl, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) throws AllegroGraphException {
        return this.verifyEnabled().getInfTriples(this, AllegroGraph.validRangeRef(object), AllegroGraph.validRangeRef(object2), AllegroGraph.validRangeRef(object3), AllegroGraph.anyContextRef(object5, 5), null, null, AllegroGraph.validRangeRef(object4), AllegroGraph.anyContextRef(object6, 6), this.defaultLookAhead, bl);
    }

    public TriplesIterator getStatements(boolean bl, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) throws AllegroGraphException {
        return this.verifyEnabled().getInfTriples(this, AllegroGraph.validRangeRef(object), AllegroGraph.validRangeRef(object3), AllegroGraph.validRangeRef(object5), AllegroGraph.anyContextRef(object7, 5), AllegroGraph.validRangeRef(object2), AllegroGraph.validRangeRef(object4), AllegroGraph.validRangeRef(object6), AllegroGraph.anyContextRef(object8, 6), this.defaultLookAhead, bl);
    }

    public boolean hasStatement(Object object, Object object2, Object object3) throws AllegroGraphException {
        return this.hasStatement(object, object2, object3, (Object)URINodeImpl.nullContext);
    }

    public boolean hasStatement(boolean bl, Object object, Object object2, Object object3) throws AllegroGraphException {
        return this.hasStatement(bl, object, object2, object3, URINodeImpl.nullContext);
    }

    public boolean hasStatement(Object object, Object object2, Object object3, Object object4) throws AllegroGraphException {
        return this.verifyEnabled().hasTriple(this, AllegroGraph.validRefOrWild(object), AllegroGraph.validRefOrWild(object2), AllegroGraph.validRefOrWild(object3), AllegroGraph.anyContextRef(object4, 3));
    }

    public boolean hasStatement(boolean bl, Object object, Object object2, Object object3, Object object4) throws AllegroGraphException {
        return this.verifyEnabled().hasInfTriple(this, AllegroGraph.validRefOrWild(object), AllegroGraph.validRefOrWild(object2), AllegroGraph.validRefOrWild(object3), AllegroGraph.anyContextRef(object4, 3), bl);
    }

    public void addStatement(Object object, Object object2, Object object3) throws AllegroGraphException {
        this.addStatement(object, object2, object3, null);
    }

    public void addStatement(Object object, Object object2, Object object3, Object object4) throws AllegroGraphException {
        this.verifyEnabled().addTriple(this, this.validRef(object), this.validRef(object2), this.validRef(object3), AllegroGraph.anyContextRef(object4, 1));
    }

    public void addStatements(Object object, Object object2, Object object3) throws AllegroGraphException {
        this.addStatements(object, object2, object3, null);
    }

    public void addStatements(Object object, Object object2, Object object3, Object object4) throws AllegroGraphException {
        try {
            this.verifyEnabled().addTriples(this, this.validRefs(object), this.validRefs(object2), this.validRefs(object3), this.anyContextRefs(object4, 1));
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new AllegroGraphException(allegroGraphException);
        }
    }

    public void clear() throws AllegroGraphException {
        try {
            this.verifyEnabled().delete(this, UPIImpl.wildUPI(), UPIImpl.wildUPI(), UPIImpl.wildUPI(), UPIImpl.wildUPI(), true);
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new AllegroGraphException(allegroGraphException);
        }
    }

    private synchronized URINode getDataType(int n) {
        if (this.xsiCache[n] == null) {
            String string = "";
            switch (n) {
                case 0: {
                    string = "boolean";
                    break;
                }
                case 1: {
                    string = "byte";
                    break;
                }
                case 2: {
                    string = "short";
                    break;
                }
                case 3: {
                    string = "int";
                    break;
                }
                case 4: {
                    string = "long";
                    break;
                }
                case 5: {
                    string = "float";
                    break;
                }
                case 6: {
                    string = "double";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("bad Schema type index");
                }
            }
            this.xsiCache[n] = this.createURI(xsiPrefix, string);
        }
        return this.xsiCache[n];
    }

    public LiteralNode createLiteral(boolean bl) {
        return this.createLiteral(Boolean.toString(bl), this.getDataType(0));
    }

    public LiteralNode addLiteral(boolean bl) throws AllegroGraphException {
        return this.addLiteral(Boolean.toString(bl), this.getDataType(0));
    }

    public LiteralNode createLiteral(long l) {
        return this.createLiteral(Long.toString(l), this.getDataType(4));
    }

    public LiteralNode addLiteral(long l) throws AllegroGraphException {
        return this.addLiteral(Long.toString(l), this.getDataType(4));
    }

    public LiteralNode createLiteral(int n) {
        return this.createLiteral(Integer.toString(n), this.getDataType(3));
    }

    public LiteralNode addLiteral(int n) throws AllegroGraphException {
        return this.addLiteral(Integer.toString(n), this.getDataType(3));
    }

    public LiteralNode createLiteral(short s) {
        return this.createLiteral(Short.toString(s), this.getDataType(2));
    }

    public LiteralNode addLiteral(short s) throws AllegroGraphException {
        return this.addLiteral(Short.toString(s), this.getDataType(2));
    }

    public LiteralNode createLiteral(byte by) {
        return this.createLiteral(Byte.toString(by), this.getDataType(1));
    }

    public LiteralNode addLiteral(byte by) throws AllegroGraphException {
        return this.addLiteral(Byte.toString(by), this.getDataType(1));
    }

    public LiteralNode createLiteral(double d) {
        return this.createLiteral(Double.toString(d), this.getDataType(6));
    }

    public LiteralNode addLiteral(double d) throws AllegroGraphException {
        return this.addLiteral(Double.toString(d), this.getDataType(6));
    }

    public LiteralNode createLiteral(float f) {
        return this.createLiteral(Float.toString(f), this.getDataType(5));
    }

    public LiteralNode addLiteral(float f) throws AllegroGraphException {
        return this.addLiteral(Float.toString(f), this.getDataType(5));
    }

    public Triple createStatement(ResourceNode resourceNode, URINode uRINode, ValueNode valueNode, ResourceNode resourceNode2) {
        UPI uPI = this.queryAGId(resourceNode);
        UPI uPI2 = this.queryAGId(uRINode);
        UPI uPI3 = this.queryAGId(valueNode);
        UPI uPI4 = UPIImpl.nullUPI();
        if (resourceNode2 instanceof URINodeImpl) {
            uPI4 = this.queryAGId(resourceNode2);
        }
        TripleImpl tripleImpl = (TripleImpl)AGFactory.makeTriple(this, uPI, uPI2, uPI3, uPI4);
        tripleImpl.subjInstance = resourceNode;
        tripleImpl.predInstance = uRINode;
        tripleImpl.objInstance = valueNode;
        return tripleImpl;
    }

    public TriplesIterator selectStatements(String string) throws AllegroGraphException {
        return this.verifyEnabled().selectTriples(this, string, null, null, this.selectLimit, false, false);
    }

    public TriplesIterator selectStatements(String string, Object object) throws AllegroGraphException {
        return this.verifyEnabled().selectTriples(this, string, this.validRefs(object), null, this.selectLimit, false, false);
    }

    public Triple newTriple(Object object, Object object2, Object object3) throws AllegroGraphException {
        return this.newTriple(object, object2, object3, null);
    }

    public long newTripleId(Object object, Object object2, Object object3) throws AllegroGraphException {
        return this.newTripleId(object, object2, object3, null);
    }

    public Triple newTriple(Object object, Object object2, Object object3, Object object4) throws AllegroGraphException {
        Object[] objectArray = this.verifyEnabled().addTriple(this, this.validRef(object), this.validRef(object2), this.validRef(object3), AllegroGraph.anyContextRef(object4, 1));
        Triple triple = AGFactory.makeTriple(this, (Long)objectArray[0], (UPIImpl)objectArray[1], (UPIImpl)objectArray[2], (UPIImpl)objectArray[3], (UPIImpl)objectArray[4]);
        return triple;
    }

    public long newTripleId(Object object, Object object2, Object object3, Object object4) throws AllegroGraphException {
        Object[] objectArray = this.verifyEnabled().addTriple(this, this.validRef(object), this.validRef(object2), this.validRef(object3), AllegroGraph.anyContextRef(object4, 1));
        return (Long)objectArray[0];
    }

    public Triple[] newTriples(Object object, Object object2, Object object3) throws AllegroGraphException {
        return this.newTriples(object, object2, object3, null);
    }

    public Triple[] newTriples(Object object, Object object2, Object object3, Object object4) throws AllegroGraphException {
        Object[] objectArray = this.verifyEnabled().addTriples(this, this.validRefs(object), this.validRefs(object2), this.validRefs(object3), this.anyContextRefs(object4, 1));
        long[] lArray = (long[])objectArray[0];
        UPI[] uPIArray = (UPI[])objectArray[1];
        UPI[] uPIArray2 = (UPI[])objectArray[2];
        UPI[] uPIArray3 = (UPI[])objectArray[3];
        Triple[] tripleArray = new Triple[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            Triple triple;
            tripleArray[i] = triple = AGFactory.makeTriple(this, lArray[i], uPIArray[i], uPIArray2[i], uPIArray3[i]);
        }
        return tripleArray;
    }

    public long[] newTripleIds(Object object, Object object2, Object object3) throws AllegroGraphException {
        return this.newTripleIds(object, object2, object3, null);
    }

    public long[] newTripleIds(Object object, Object object2, Object object3, Object object4) throws AllegroGraphException {
        Object[] objectArray = this.verifyEnabled().addTriples(this, this.validRefs(object), this.validRefs(object2), this.validRefs(object3), this.anyContextRefs(object4, 1));
        return (long[])objectArray[0];
    }

    public void removeStatements(Object object, Object object2, Object object3) throws AllegroGraphException {
        this.removeStatements(object, object2, object3, UPIImpl.nullUPI());
    }

    public void removeStatements(Object object, Object object2, Object object3, Object object4) throws AllegroGraphException {
        this.verifyEnabled().delete(this, AllegroGraph.validRefOrWild(object), AllegroGraph.validRefOrWild(object2), AllegroGraph.validRefOrWild(object3), AllegroGraph.anyContextRef(object4, 3), true);
    }

    public TriplesIterator selectStatements(String string, Object object, String string2) throws AllegroGraphException {
        return this.verifyEnabled().selectTriples(this, string, this.validRefs(object), string2, this.selectLimit, false, false);
    }

    public TriplesIterator selectStatements(boolean bl, boolean bl2, String string, Object object, String string2) throws AllegroGraphException {
        return this.verifyEnabled().selectTriples(this, string, this.validRefs(object), string2, this.selectLimit, bl, bl2);
    }

    public UPI[] createBNodeIds(int n) throws AllegroGraphException {
        return this.verifyEnabled().newBlankNodes(this, n);
    }

    public void removeStatement(Object object, Object object2, Object object3) throws AllegroGraphException {
        this.removeStatement(object, object2, object3, UPIImpl.nullUPI());
    }

    public void removeStatement(Object object, Object object2, Object object3, Object object4) throws AllegroGraphException {
        this.verifyEnabled().delete(this, this.validRef(object), this.validRef(object2), this.validRef(object3), AllegroGraph.anyContextRef(object4, 1), false);
    }

    public UPI[] addLiteralIds(String[] stringArray, String[] stringArray2, String[] stringArray3) throws AllegroGraphException {
        return this.verifyEnabled().newLiteral((AGBase)this, stringArray, stringArray2, stringArray3);
    }

    public ValueObject[][] selectValues(String string, Object[] objectArray, String string2) throws AllegroGraphException {
        Object[] objectArray2 = this.verifyEnabled().selectValues(this, string, objectArray, string2, false, false);
        return (ValueObject[][])this.selectValuesArray(false, objectArray2, false);
    }

    public ValueObject[][] selectValues(boolean bl, boolean bl2, String string, Object[] objectArray, String string2) throws AllegroGraphException {
        Object[] objectArray2 = this.verifyEnabled().selectValues(this, string, objectArray, string2, bl, bl2);
        return (ValueObject[][])this.selectValuesArray(false, objectArray2, false);
    }

    public ValueObject[] selectSingleValues(String string, Object[] objectArray, String string2) throws AllegroGraphException {
        Object[] objectArray2 = this.verifyEnabled().selectValues(this, string, objectArray, string2, false, false);
        return (ValueObject[])this.selectValuesArray(true, objectArray2, false);
    }

    public ValueObject[] selectSingleValues(boolean bl, boolean bl2, String string, Object[] objectArray, String string2) throws AllegroGraphException {
        Object[] objectArray2 = this.verifyEnabled().selectValues(this, string, objectArray, string2, bl, bl2);
        return (ValueObject[])this.selectValuesArray(true, objectArray2, false);
    }

    public ValueObject[] getFreetextUniqueSubjects(String string) throws AllegroGraphException {
        Object[] objectArray = this.verifyEnabled().getFreetextSubjects(this, string, this.selectLimit);
        return (ValueObject[])this.selectValuesArray(true, objectArray, false);
    }

    public TriplesIterator getFreetextStatements(String string) throws AllegroGraphException {
        return this.verifyEnabled().getFreetextStatements(this, string, this.defaultLookAhead);
    }

    public String[] getFreetextPredicates() throws AllegroGraphException {
        return this.verifyEnabled().freetextPredicates(this, null);
    }

    public void registerFreetextPredicate(Object object) throws AllegroGraphException {
        this.verifyEnabled().freetextPredicates(this, this.validRefs(object));
    }

    Object selectValuesArray(boolean bl, Object[] objectArray, boolean bl2) throws AllegroGraphException {
        if (objectArray == null) {
            if (bl) {
                return new ValueObject[0];
            }
            return new ValueObject[0][0];
        }
        UPIImpl[] uPIImplArray = (UPIImpl[])objectArray[0];
        if (uPIImplArray == null) {
            if (bl) {
                return new ValueObject[0];
            }
            return new ValueObject[0][0];
        }
        int[] nArray = (int[])objectArray[1];
        String[] stringArray = (String[])objectArray[2];
        String[] stringArray2 = (String[])objectArray[3];
        int n = (Integer)objectArray[4];
        int n2 = (Integer)objectArray[5];
        if (bl && n2 != 1) {
            throw new IllegalArgumentException("Asked for single result but received " + n2);
        }
        Object object = objectArray[6];
        int n3 = (Integer)objectArray[7];
        int n4 = uPIImplArray.length;
        Object object2 = null;
        if (8 < objectArray.length) {
            object2 = objectArray[8];
        }
        if (bl) {
            ValueObject[] valueObjectArray = new ValueObject[n4];
            for (int i = 0; i < n4; ++i) {
                valueObjectArray[i] = this.newSelectValue(bl2, uPIImplArray[i], nArray[i], stringArray[i], stringArray2[i]);
            }
            return this.registerValues(valueObjectArray, object, n, n3, object2, bl2);
        }
        if (n2 == 0) {
            ValueObject[][] valueObjectArray = new ValueObject[n4][0];
            return this.registerValues(valueObjectArray, object, n, n3, object2, bl2);
        }
        int n5 = n4 / n2;
        int n6 = 0;
        int n7 = 0;
        ValueObject[][] valueObjectArray = new ValueObject[n5][n2];
        while (n6 < n4) {
            for (int i = 0; i < n2; ++i) {
                valueObjectArray[n7][i] = this.newSelectValue(bl2, uPIImplArray[n6], nArray[n6], stringArray[n6], stringArray2[n6]);
                ++n6;
            }
            ++n7;
        }
        return this.registerValues(valueObjectArray, object, n, n3, object2, bl2);
    }

    Object registerValues(Object object, Object object2, int n, int n2, Object object3, boolean bl) throws AllegroGraphException {
        if (n > 0 || object3 != null) {
            this.ags.valueMap.put(object, new valueMapEntry(this, object2, n, n2, object3, bl));
        }
        this.discardOldTokens(false);
        return object;
    }

    public ValueObject[][] selectValues(String string) throws AllegroGraphException {
        return this.selectValues(false, false, string, new Object[0], "");
    }

    public ValueObject[][] selectValues(boolean bl, boolean bl2, String string) throws AllegroGraphException {
        return this.selectValues(bl, bl2, string, new Object[0], "");
    }

    public int valuesLength(ValueObject[][] valueObjectArray) {
        return valueObjectArray.length;
    }

    public int moreValues(Object object) {
        valueMapEntry valueMapEntry2 = (valueMapEntry)this.ags.valueMap.get(object);
        if (valueMapEntry2 == null) {
            return 0;
        }
        if (valueMapEntry2.savedMore > valueMapEntry2.savedPlimit) {
            return -valueMapEntry2.savedMore;
        }
        return valueMapEntry2.savedMore;
    }

    public String[] valueNames(Object object) {
        valueMapEntry valueMapEntry2 = (valueMapEntry)this.ags.valueMap.get(object);
        if (valueMapEntry2 == null) {
            return new String[0];
        }
        Object object2 = valueMapEntry2.savedVal;
        if (object2 == null) {
            return new String[0];
        }
        if (object2 instanceof String[]) {
            return (String[])object2;
        }
        return new String[0];
    }

    public ValueObject[][] selectMore(ValueObject[][] valueObjectArray) throws AllegroGraphException {
        return (ValueObject[][])this.selectMoreInternal(false, valueObjectArray);
    }

    public ValueObject[] selectMore(ValueObject[] valueObjectArray) throws AllegroGraphException {
        return (ValueObject[])this.selectMoreInternal(true, valueObjectArray);
    }

    Object selectMoreInternal(boolean bl, Object object) throws AllegroGraphException {
        ValueObject[][] valueObjectArray;
        valueMapEntry valueMapEntry2 = (valueMapEntry)this.ags.valueMap.get(object);
        if (valueMapEntry2 == null) {
            return this.selectNull(bl);
        }
        String string = (String)valueMapEntry2.savedToken;
        boolean bl2 = valueMapEntry2.savedNullOk;
        Object[] objectArray = this.verifyEnabled().nextValuesArray(this, string, this.selectLimit);
        if (objectArray == null) {
            return this.selectNull(bl);
        }
        UPIImpl[] uPIImplArray = (UPIImpl[])objectArray[0];
        int[] nArray = (int[])objectArray[1];
        String[] stringArray = (String[])objectArray[2];
        String[] stringArray2 = (String[])objectArray[3];
        int n = (Integer)objectArray[4];
        int n2 = (Integer)objectArray[5];
        String string2 = (String)objectArray[6];
        int n3 = (Integer)objectArray[7];
        int n4 = uPIImplArray.length;
        int n5 = 0;
        if (n > 0) {
            valueMapEntry2.savedToken = string2;
            valueMapEntry2.savedMore = n;
            valueMapEntry2.savedPlimit = n3;
        } else {
            this.ags.valueMap.remove(object);
        }
        if (bl && n2 == 1) {
            ValueObject[] valueObjectArray2 = (ValueObject[])object;
            if (n4 == valueObjectArray2.length) {
                for (int i = 0; i < n4; ++i) {
                    valueObjectArray2[i] = this.newSelectValue(bl2, uPIImplArray[i], nArray[i], stringArray[i], stringArray2[i]);
                }
                return valueObjectArray2;
            }
            int n6 = n4 / n2;
            ValueObject[] valueObjectArray3 = new ValueObject[n6];
            for (n5 = 0; n5 < n4; ++n5) {
                valueObjectArray3[n5] = this.newSelectValue(bl2, uPIImplArray[n5], nArray[n5], stringArray[n5], stringArray2[n5]);
            }
            if (n > 0) {
                this.ags.valueMap.remove(object);
                this.ags.valueMap.put(valueObjectArray3, valueMapEntry2);
            }
            this.discardOldTokens(false);
            return valueObjectArray3;
        }
        ValueObject[][] valueObjectArray4 = (ValueObject[][])object;
        if (n4 == n2 * valueObjectArray4.length) {
            for (int i = 0; i < valueObjectArray4.length; ++i) {
                ValueObject[] valueObjectArray5 = new ValueObject[n2];
                for (int j = 0; j < n2; ++j) {
                    valueObjectArray5[j] = this.newSelectValue(bl2, uPIImplArray[n5], nArray[n5], stringArray[n5], stringArray2[n5]);
                    ++n5;
                }
                valueObjectArray4[i] = valueObjectArray5;
            }
            return valueObjectArray4;
        }
        if (n2 == 0) {
            valueObjectArray = new ValueObject[n4][0];
        } else {
            int n7 = 0;
            n7 = n4 / n2;
            n5 = 0;
            int n8 = 0;
            valueObjectArray = new ValueObject[n7][n2];
            while (n5 < n4) {
                for (int i = 0; i < n2; ++i) {
                    valueObjectArray[n8][i] = this.newSelectValue(bl2, uPIImplArray[n5], nArray[n5], stringArray[n5], stringArray2[n5]);
                    ++n5;
                }
                ++n8;
            }
        }
        if (n > 0) {
            this.ags.valueMap.remove(valueObjectArray4);
            this.ags.valueMap.put(valueObjectArray, valueMapEntry2);
        }
        this.discardOldTokens(false);
        return valueObjectArray;
    }

    public boolean twinqlAsk(String string) throws AllegroGraphException {
        return this.verifyEnabled().twinqlAsk(this, string, false);
    }

    public ValueObject[][] twinqlSelect(String string, String string2, int n, int n2) throws AllegroGraphException {
        return this.twinqlSelect(false, string, string2, n, n2);
    }

    public ValueObject[][] twinqlSelect(boolean bl, String string, String string2, int n, int n2) throws AllegroGraphException {
        return this.twinqlSelect(bl, string, string2, n, n2, new Object[0]);
    }

    ValueObject[][] twinqlSelect(boolean bl, String string, String string2, int n, int n2, Object[] objectArray) throws AllegroGraphException {
        Object[] objectArray2 = this.verifyEnabled().twinqlSelect(this, string, string2, n, n2, this.selectLimit, bl, objectArray);
        return (ValueObject[][])this.selectValuesArray(false, objectArray2, true);
    }

    public long twinqlCount(String string, String string2, int n, int n2) throws AllegroGraphException {
        Object[] objectArray = this.verifyEnabled().twinqlSelect(this, string, string2, n, n2, -1, false);
        return AGConnector.longValue(objectArray[0]);
    }

    public TriplesIterator twinqlFind(String string, int n, int n2) throws AllegroGraphException {
        return this.verifyEnabled().twinqlFind(this, string, n, n2, this.selectLimit, false);
    }

    public String twinqlQuery(String string, String string2, int n, int n2) throws AllegroGraphException {
        return this.verifyEnabled().twinqlQuery(this, string, string2, n, n2, false);
    }

    public Triple createStatement(ResourceNode resourceNode, URINode uRINode, ValueNode valueNode) {
        return this.createStatement(resourceNode, uRINode, valueNode, null);
    }

    private int intResult(Object object) {
        return AGConnector.toInt(object);
    }

    public int getUnmergedCount() throws AllegroGraphException {
        Object object = this.verifyEnabled().indexing(this, 2, 0, null);
        return this.intResult(object);
    }

    public int getUnindexedTripleCount() throws AllegroGraphException {
        Object object = this.verifyEnabled().indexing(this, 1, 0, null);
        return this.intResult(object);
    }

    public int getUnindexedThreshold() throws AllegroGraphException {
        Object object = this.verifyEnabled().indexing(this, 3, 0, null);
        return this.intResult(object);
    }

    public void setUnindexedThreshold(int n) throws AllegroGraphException {
        this.verifyEnabled().indexing(this, 13, n, null);
    }

    public int getUnmergedThreshold() throws AllegroGraphException {
        Object object = this.verifyEnabled().indexing(this, 4, 0, null);
        return this.intResult(object);
    }

    public void setUnmergedThreshold(int n) throws AllegroGraphException {
        this.verifyEnabled().indexing(this, 14, n, null);
    }

    public String[] getIndexFlavors() throws AllegroGraphException {
        Object object = this.verifyEnabled().indexing(this, 5, 0, null);
        if (object == null) {
            return new String[0];
        }
        return (String[])object;
    }

    public void setIndexFlavors(String[] stringArray) throws AllegroGraphException {
        this.verifyEnabled().indexing(this, 35, 0, stringArray);
    }

    public void addIndexFlavors(String[] stringArray) throws AllegroGraphException {
        this.verifyEnabled().indexing(this, 15, 0, stringArray);
    }

    public void dropIndexFlavors(String[] stringArray) throws AllegroGraphException {
        this.verifyEnabled().indexing(this, 25, 0, stringArray);
    }

    public void addDataMapping(String[] stringArray) throws AllegroGraphException {
        this.verifyEnabled().mapping(this, 11, stringArray);
    }

    public void setDataMapping(String[] stringArray) throws AllegroGraphException {
        this.verifyEnabled().mapping(this, 21, stringArray);
    }

    public String[] getDataMapping() throws AllegroGraphException {
        Object object = this.verifyEnabled().mapping(this, 1, null);
        if (object == null) {
            return new String[0];
        }
        if (object instanceof String[]) {
            return (String[])object;
        }
        return new String[0];
    }

    public Object[] evalInServer(String string) throws AllegroGraphException {
        return this.verifyEnabled().evalInServer(this, string);
    }

    public int serverTrace(boolean bl) {
        try {
            this.verifyEnabled().serverTrace(this, bl, null);
            return 0;
        }
        catch (AllegroGraphException allegroGraphException) {
            return -1;
        }
    }

    public int serverTrace(String string) {
        try {
            this.verifyEnabled().serverTrace(this, true, string);
            return 0;
        }
        catch (AllegroGraphException allegroGraphException) {
            return -1;
        }
    }

    public String[] getNamespaces() {
        if (this.nsregs == null) {
            return new String[0];
        }
        return this.nsregs.toArray();
    }

    public NamespaceRegistry getNamespaceRegistry() {
        if (null == this.nsregs) {
            return null;
        }
        return new NamespaceRegistry(this.nsregs);
    }

    public void registerNamespace(String string, String string2) throws AllegroGraphException {
        this.nsregsInit().register(string, string2);
        this.verifyEnabled().namespaces(this, this.nsregs.toArray());
    }

    public void registerNamespaces(String[] stringArray) throws AllegroGraphException {
        if (stringArray == null) {
            return;
        }
        if (0 == stringArray.length) {
            return;
        }
        this.nsregsInit();
        for (int i = 0; i < stringArray.length; i += 2) {
            this.nsregs.register(stringArray[i], stringArray[i + 1]);
        }
        this.verifyEnabled().namespaces(this, this.nsregs.toArray());
    }

    public void registerNamespaces(NamespaceRegistry namespaceRegistry) throws AllegroGraphException {
        this.nsregsInit().register(namespaceRegistry);
        this.verifyEnabled().namespaces(this, this.nsregs.toArray());
    }

    public void setNamespaceRegistry(NamespaceRegistry namespaceRegistry) throws AllegroGraphException {
        this.nsregs = new NamespaceRegistry(namespaceRegistry);
        this.verifyEnabled().namespaces(this, this.nsregs == null ? null : this.nsregs.toArray());
    }

    public void setNamespaceRegistry() throws AllegroGraphException {
        this.nsregs = this.ags == null ? null : (null == this.ags.nsregs ? null : new NamespaceRegistry(this.ags.nsregs));
        this.verifyEnabled().namespaces(this, this.nsregs == null ? null : this.nsregs.toArray());
    }

    public ValueNode addPart(String string) throws AllegroGraphException {
        if (string.startsWith("_:")) {
            return this.createBNode(string);
        }
        Object[] objectArray = this.verifyEnabled().addPart(this, AllegroGraph.refNtripleString(string));
        UPIImpl uPIImpl = objectArray[0] instanceof UPIImpl ? (UPIImpl)objectArray[0] : null;
        int n = 0;
        if (1 < objectArray.length) {
            n = (int)AGConnector.longValue(objectArray[1]);
        }
        String string2 = null;
        String string3 = null;
        if (2 < objectArray.length) {
            string2 = (String)objectArray[2];
        }
        if (3 < objectArray.length) {
            string2 = (String)objectArray[3];
        }
        return (ValueNode)this.newValue(uPIImpl, n, string2, string3);
    }

    AllegroGraph(AllegroGraphConnection allegroGraphConnection, String string, AGInternals[] aGInternalsArray, boolean bl) throws AllegroGraphException {
        this.ags = allegroGraphConnection;
        this.storeName = string;
        this.storeDirectory = null;
        int[] nArray = new int[aGInternalsArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            if (aGInternalsArray[i].ags != allegroGraphConnection) {
                throw new AllegroGraphException("Component of federated triple store must be opened on same connection.");
            }
            if (0 > aGInternalsArray[i].tsx) {
                throw new AllegroGraphException("Components of federated triple store must be open triple stores.");
            }
            nArray[i] = aGInternalsArray[i].tsx;
        }
        this.tsx = this.verifyEnabled().federate(string, nArray, bl);
        this.ags.addTS(this);
        this.initNamespaces();
    }

    AllegroGraph(AllegroGraphConnection allegroGraphConnection, String string, String string2) throws AllegroGraphException {
        this.ags = allegroGraphConnection;
        this.storeName = string;
        this.storeDirectory = string2;
        Object[] objectArray = this.verifyEnabled().findStore(string, string2, null);
        if (null == objectArray) {
            throw new AllegroGraphException("Could not find triple store.");
        }
        this.tsx = (Integer)objectArray[0];
        this.storeName = (String)objectArray[1];
        this.storeDirectory = (String)objectArray[2];
        this.ags.addTS(this);
    }

    public AllegroGraph(String string) {
        this.storeName = string;
    }

    AllegroGraph(AGInternals aGInternals, int n, String string, String string2) {
        this.ags = aGInternals.ags;
        this.storeName = string;
        this.storeDirectory = string2;
        this.tsx = n;
        this.ags.addTS(this);
    }

    public AGInternals[] getStores() throws AllegroGraphException {
        Object[] objectArray = this.verifyEnabled().getStores(this);
        if (null == objectArray) {
            return null;
        }
        AGInternals[] aGInternalsArray = new AGInternals[objectArray.length / 3];
        for (int i = 0; i < aGInternalsArray.length; ++i) {
            aGInternalsArray[i] = new AllegroGraph(this, (Integer)objectArray[i * 3], (String)objectArray[1 + i * 3], (String)objectArray[2 + i * 3]);
        }
        return aGInternalsArray;
    }

    public boolean getSyncEveryTime() {
        return this.sync;
    }

    public void setSyncEveryTime(boolean bl) {
        this.sync = bl;
    }

    public String toString() {
        return this.getClass().getName() + "<" + this.tsx + " " + this.storeName + ">";
    }

    public SNAExtension getSNAExtension() {
        if (null == this.sna) {
            this.sna = new SNAExtension(this);
        }
        return this.sna;
    }

    public GeoExtension getGeoExtension() {
        if (null == this.geo) {
            this.geo = new GeoExtension(this);
        }
        return this.geo;
    }

    private Object ntripleContext(Object object) throws AllegroGraphException {
        if (object instanceof String && "source".equalsIgnoreCase((String)object)) {
            return "source";
        }
        return AllegroGraph.anyContextRef(object, 1);
    }

    public boolean isSPOGICacheEnabled() throws AllegroGraphException {
        Object[] objectArray = this.verifyEnabled().clientOption(this, "spogi-cache", "state", -1);
        if (objectArray == null) {
            return false;
        }
        if (0 == objectArray.length) {
            return false;
        }
        return 1L == AGConnector.longValue(objectArray[0]);
    }

    public void setSPOGICacheEnabled(boolean bl) throws AllegroGraphException {
        this.verifyEnabled().clientOption(this, "spogi-cache", "state", bl ? 1 : 0);
    }

    public long getSPOGICacheSize() throws AllegroGraphException {
        Object[] objectArray = this.verifyEnabled().clientOption(this, "spogi-cache", "size", -1);
        return AGConnector.longValue(objectArray[0]);
    }

    public void setSPOGICacheSize(long l) throws AllegroGraphException {
        this.verifyEnabled().clientOption(this, "spogi-cache", "size", l);
    }

    static class valueMapEntry {
        Object savedToken;
        int savedMore;
        AGInternals savedAG;
        Object savedVal = null;
        int savedPlimit;
        boolean savedNullOk;

        public valueMapEntry(AGInternals aGInternals, Object object, int n, int n2, Object object2, boolean bl) {
            this.savedToken = object;
            this.savedMore = n;
            this.savedAG = aGInternals;
            this.savedPlimit = n2;
            this.savedVal = object2;
            this.savedNullOk = bl;
        }

        protected synchronized void finalize() throws Throwable {
            if (this.savedAG.ags == null) {
                return;
            }
            if (null != this.savedToken) {
                this.savedAG.ags.oldTokens.add(this.savedToken);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StoreAttribute {
        EXPECTED_UNIQUE_RESOURCES("expected-unique-resources"),
        WITH_INDICES("with-indices"),
        INCLUDE_STANDARD_PARTS("include-standard-parts"),
        READ_ONLY("read-only"),
        INDIRECT_HOST("indirect-host"),
        INDIRECT_PORT("indirect-port");

        private String value;

        private StoreAttribute(String string2) {
            this.value = string2;
        }

        private String value() {
            return this.value;
        }
    }

    public static class V3_1BaseSept30 {
    }
}

