/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase.util;

import com.franz.ag.AllegroGraphException;
import com.franz.ag.GeospatialSubtype;
import com.franz.ag.NamespaceRegistry;
import com.franz.agbase.AllegroGraphConnection;
import com.franz.agbase.transport.AGConnector;
import com.franz.agbase.util.AGBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;

public class AGConnInternals {
    protected static final String agPrefPath = "franz.com/allegrograph/java";
    protected static String defaultMode = "direct";
    protected static String defaultHost = "";
    protected static int defaultPort = 4567;
    protected static int defaultPort2 = 4568;
    protected static int defaultDebug = 0;
    protected static String defaultLispCommand = "";
    protected static boolean defaultServerKeep = false;
    protected static int defaultPollCount = 1;
    protected static int defaultPollInterval = 500;
    protected static int defaultTimeout = 5000;
    protected static final String agLispKey = "lispcommand";
    protected static NamespaceRegistry initialns = new NamespaceRegistry(NamespaceRegistry.RDFandOwl);
    protected int pollCount = defaultPollCount;
    protected int pollInterval = defaultPollInterval;
    protected int timeout = defaultTimeout;
    protected String mode = defaultMode;
    protected String host = defaultHost;
    protected int port = defaultPort;
    protected int port2 = defaultPort2;
    protected int debug = defaultDebug;
    protected String lispCommand = defaultLispCommand;
    public boolean keep = defaultServerKeep;
    public AGConnector agc = null;
    public Vector<Object> oldTokens = new Vector(100);
    private ArrayList<Object> allTS = new ArrayList();
    public int oldBatch = 10;
    public GeospatialSubtype[] geoSubs = new GeospatialSubtype[256];
    public int debugMask = 0;
    public Map<Object, Object> valueMap = Collections.synchronizedMap(new WeakHashMap());
    public NamespaceRegistry nsregs = new NamespaceRegistry(initialns);
    public long serverId;

    public AGConnInternals() {
        for (int i = 0; i < this.geoSubs.length; ++i) {
            this.geoSubs[i] = null;
        }
        this.serverId = -1L;
    }

    public synchronized void addTS(AGBase aGBase) {
        this.allTS.add(aGBase);
    }

    public synchronized void dropTS(AGBase aGBase) {
        int n = this.allTS.indexOf(aGBase);
        this.allTS.remove(n);
    }

    public synchronized Object[] arrayOfTS() {
        return this.allTS.toArray();
    }

    public void freshState() {
        this.geoSubs = new GeospatialSubtype[256];
        this.oldTokens = new Vector(100);
        this.allTS = new ArrayList();
        this.valueMap = Collections.synchronizedMap(new WeakHashMap());
    }

    public String toString() {
        return this.getClass().getName() + "<" + this.serverId + " " + this.mode + ">";
    }

    public AGConnector getServer() {
        if (this.agc == null) {
            throw new IllegalStateException("Server is not enabled.");
        }
        return this.agc;
    }

    public boolean ifDebug(int n) {
        int n2 = 0;
        if (n > 0) {
            n2 = 1 << n - 1;
        }
        return (this.debugMask & n2) > 0;
    }

    public static Object serverOption(AllegroGraphConnection allegroGraphConnection, Object ... objectArray) throws AllegroGraphException {
        return allegroGraphConnection.getServer().serverOptionOne(objectArray);
    }
}

