/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agjena;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphConnection;
import com.franz.agbase.AllegroGraphException;
import com.franz.agjena.Utils;
import com.franz.agjena.exceptions.NiceException;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.Map;

public class StartUp {
    static HashMap<Object, Boolean> jenaAGStores = new HashMap();
    private static int debug = 0;
    private static boolean quiet = false;
    private static Map<String, String> DEFAULT_AGSERVER_LOCATION_MAP = new HashMap<String, String>();

    private static void startServer(AllegroGraphConnection allegroGraphConnection, String string) throws IOException {
        if (!quiet) {
            System.out.println("Starting server ...");
        }
        try {
            allegroGraphConnection.startServer();
        }
        catch (ConnectException connectException) {
            File file;
            String string2 = System.getProperty("os.name");
            String string3 = DEFAULT_AGSERVER_LOCATION_MAP.get(string2);
            if (string3 != null && !(file = new File(string3)).exists()) {
                string3 = null;
            }
            if (string3 != null && !string3.equals(string)) {
                System.out.print("Failed to start AllegroGraph server, possibly because ");
                if (string == null) {
                    System.out.println("no path provided to location of AllegroGraphJavaServer\n");
                } else {
                    System.out.println("incorrect path '" + string + "'provided to location of AllegroGraphJavaServer\n");
                }
                System.out.println("  Retrying at location '" + string3 + "'");
                StartUp.startServer(allegroGraphConnection, string3);
                return;
            }
            if (string != null) {
                throw new NiceException("Failed to start AllegroGraph server at location " + string, connectException);
            }
            throw connectException;
        }
        if (!quiet) {
            System.out.println("  started.");
        }
    }

    private static AllegroGraph helpStartUpTripleStore(AccessTripleStore accessTripleStore, String string, String string2, String string3, String[] stringArray) throws AllegroGraphException, IOException {
        Object object;
        int n = 4567;
        String string4 = null;
        boolean bl = string4 != null;
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            if (((String)object).equals("-p")) {
                n = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (((String)object).equals("-h")) {
                string = stringArray[++i];
                continue;
            }
            if (((String)object).equals("-d")) {
                string3 = stringArray[++i];
                continue;
            }
            if (((String)object).equals("-n")) {
                string2 = stringArray[++i];
                continue;
            }
            if (((String)object).equals("-z")) {
                debug = 1;
                continue;
            }
            if (((String)object).equals("-zz")) {
                debug = 2;
                continue;
            }
            if (((String)object).equals("-x")) {
                bl = true;
                continue;
            }
            if (((String)object).equals("-q")) {
                quiet = true;
                continue;
            }
            if (!((String)object).equals("-l")) continue;
            string4 = stringArray[++i];
        }
        if (Utils.isNullString(string)) {
            throw new NiceException("Name of host (server machine) is required");
        }
        if (Utils.isNullString(string2)) {
            throw new NiceException("Database name is required");
        }
        if (Utils.isNullString(string3)) {
            System.out.print("Database folder argument (-d) is required.");
            System.exit(1);
        }
        System.out.println("port=" + n + "  dbDirectory=" + string3 + "  dbName=" + string2);
        AllegroGraphConnection allegroGraphConnection = new AllegroGraphConnection();
        if (string4 != null) {
            AllegroGraphConnection.setDefaultCommand(string4);
            bl = true;
        }
        allegroGraphConnection.setPort(n);
        allegroGraphConnection.setHost(string);
        allegroGraphConnection.setDebug(debug);
        if (bl) {
            StartUp.startServer(allegroGraphConnection, string4);
        }
        if (!quiet) {
            System.out.println("Enabling connection ...");
        }
        try {
            Thread.sleep(2000L);
            allegroGraphConnection.enable();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof AllegroGraphException) {
                throw (AllegroGraphException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new NiceException(exception);
        }
        if (!quiet) {
            System.out.println("Connected to " + allegroGraphConnection);
        }
        object = null;
        try {
            switch (accessTripleStore) {
                case RENEW: {
                    object = allegroGraphConnection.renew(string2, string3);
                    break;
                }
                case ACCESS: {
                    object = allegroGraphConnection.access(string2, string3);
                    break;
                }
                case OPEN: {
                    object = allegroGraphConnection.open(string2, string3);
                    break;
                }
                case REPLACE: {
                    object = allegroGraphConnection.replace(string2, string3);
                    break;
                }
                case CREATE: {
                    object = allegroGraphConnection.create(string2, string3);
                }
            }
        }
        catch (Exception exception) {
            if (!quiet) {
                System.out.println("Caught exception while renewing triple store:\n" + exception.getMessage());
            }
            if (!quiet) {
                System.out.println("Stopping server ...");
            }
            int n2 = allegroGraphConnection.stopServer(false);
            if (!quiet) {
                switch (n2) {
                    case 0: {
                        System.out.println("OK");
                    }
                    case 1: {
                        System.out.println("Nothing to terminate.");
                    }
                }
                System.out.println("Oh oh.");
            }
            return null;
        }
        jenaAGStores.put(object, true);
        System.out.println("Connected database " + string2 + " contains " + ((AllegroGraph)object).numberOfTriples() + " triples");
        return object;
    }

    public static AllegroGraph startUpTripleStore(AccessTripleStore accessTripleStore, String string, String string2, String string3, String[] stringArray) {
        try {
            return StartUp.helpStartUpTripleStore(accessTripleStore, string, string2, string3, stringArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new NiceException("Failure starting up AllegroGraph server.", exception);
        }
    }

    public static void shutDownTripleStore(AllegroGraph allegroGraph) {
        if (allegroGraph == null) {
            return;
        }
        if (!quiet) {
            System.out.println("All done.  Closing triple store.");
        }
        try {
            allegroGraph.closeTripleStore();
            if (jenaAGStores.get(allegroGraph).booleanValue()) {
                jenaAGStores.remove(allegroGraph);
                allegroGraph.getConnection().disable();
            }
            if (!quiet) {
                System.out.println("Stopping the server.");
            }
            allegroGraph.getConnection().stopServer(false);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new NiceException("Failure shutting down AllegroGraph server.", exception);
        }
    }

    public static void main(String[] stringArray) {
        String string = "localhost";
        String string2 = "/tmp/test";
        String string3 = "/Users/bmacgregor/Desktop/AGFolder";
        AllegroGraph allegroGraph = StartUp.startUpTripleStore(AccessTripleStore.RENEW, string, string2, string3, stringArray);
        StartUp.shutDownTripleStore(allegroGraph);
    }

    static {
        DEFAULT_AGSERVER_LOCATION_MAP.put("Mac OS X", "/Applications/AllegroGraph/AllegroGraphJavaServer");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AccessTripleStore {
        ACCESS("access"),
        RENEW("renew"),
        OPEN("open"),
        CREATE("create"),
        REPLACE("replace");

        private String command;

        private AccessTripleStore(String string2) {
            this.command = string2;
        }

        public String getCommand() {
            return this.command;
        }
    }
}

