/*
 * Decompiled with CFR 0.152.
 */
package com.knowledgereefsystems.agsail;

import com.knowledgereefsystems.agsail.AllegroSailConnection;
import com.knowledgereefsystems.agsail.AllegroSailTestCase;
import java.io.File;
import java.util.Iterator;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.model.vocabulary.XMLSchema;

public class TestValues
extends AllegroSailTestCase {
    public TestValues(String string) throws Exception {
        super(string);
    }

    public void testCreateLiteralsThroughValueFactory() throws Exception {
        ValueFactory valueFactory = this.sail.getValueFactory();
        Literal literal = valueFactory.createLiteral("a plain literal");
        TestValues.assertNotNull((Object)literal);
        TestValues.assertNull((Object)literal.getLanguage());
        TestValues.assertEquals((String)"a plain literal", (String)literal.getLabel());
        TestValues.assertNull((Object)literal.getDatatype());
        literal = valueFactory.createLiteral("auf Deutsch, bitte", "de");
        TestValues.assertNotNull((Object)literal);
        TestValues.assertEquals((String)"de", (String)literal.getLanguage());
        TestValues.assertEquals((String)"auf Deutsch, bitte", (String)literal.getLabel());
        TestValues.assertNull((Object)literal.getDatatype());
        literal = valueFactory.createLiteral("foo", XMLSchema.STRING);
        TestValues.assertNotNull((Object)literal);
        TestValues.assertNull((Object)literal.getLanguage());
        TestValues.assertEquals((String)"foo", (String)literal.getLabel());
        TestValues.assertEquals((Object)XMLSchema.STRING, (Object)literal.getDatatype());
        literal = valueFactory.createLiteral(42);
        TestValues.assertNotNull((Object)literal);
        TestValues.assertNull((Object)literal.getLanguage());
        TestValues.assertEquals((String)"42", (String)literal.getLabel());
        TestValues.assertEquals((int)42, (int)literal.intValue());
        TestValues.assertEquals((Object)XMLSchema.INT, (Object)literal.getDatatype());
        literal = valueFactory.createLiteral(42L);
        TestValues.assertNotNull((Object)literal);
        TestValues.assertNull((Object)literal.getLanguage());
        TestValues.assertEquals((String)"42", (String)literal.getLabel());
        TestValues.assertEquals((long)42L, (long)literal.longValue());
        TestValues.assertEquals((Object)XMLSchema.LONG, (Object)literal.getDatatype());
        literal = valueFactory.createLiteral((short)42);
        TestValues.assertNotNull((Object)literal);
        TestValues.assertNull((Object)literal.getLanguage());
        TestValues.assertEquals((String)"42", (String)literal.getLabel());
        TestValues.assertEquals((short)42, (short)literal.shortValue());
        TestValues.assertEquals((Object)XMLSchema.SHORT, (Object)literal.getDatatype());
        literal = valueFactory.createLiteral(true);
        TestValues.assertNotNull((Object)literal);
        TestValues.assertNull((Object)literal.getLanguage());
        TestValues.assertEquals((String)"true", (String)literal.getLabel());
        TestValues.assertEquals((boolean)true, (boolean)literal.booleanValue());
        TestValues.assertEquals((Object)XMLSchema.BOOLEAN, (Object)literal.getDatatype());
        literal = valueFactory.createLiteral((byte)99);
        TestValues.assertNotNull((Object)literal);
        TestValues.assertNull((Object)literal.getLanguage());
        TestValues.assertEquals((String)"99", (String)literal.getLabel());
        TestValues.assertEquals((int)99, (int)literal.byteValue());
        TestValues.assertEquals((Object)XMLSchema.BYTE, (Object)literal.getDatatype());
        XMLGregorianCalendar xMLGregorianCalendar = XMLDatatypeUtil.parseCalendar((String)"2002-10-10T12:00:00-05:00");
        literal = valueFactory.createLiteral(xMLGregorianCalendar);
        TestValues.assertNotNull((Object)literal);
        TestValues.assertNull((Object)literal.getLanguage());
        TestValues.assertEquals((String)"2002-10-10T12:00:00-05:00", (String)literal.getLabel());
        TestValues.assertEquals((Object)xMLGregorianCalendar, (Object)literal.calendarValue());
        TestValues.assertEquals((Object)XMLSchema.DATETIME, (Object)literal.getDatatype());
    }

    public void testGetValuesFromTripleStore() throws Exception {
        ValueFactory valueFactory = this.sail.getValueFactory();
        this.loadTrig(new File("resources/com/knowledgereefsystems/agsail/queryTest.trig"));
        AllegroSailConnection allegroSailConnection = this.sail.getConnection();
        URI uRI = valueFactory.createURI("http://knowledgereefsystems.com/agsail/test/ford");
        Literal literal = (Literal)((Statement)this.toSet(allegroSailConnection.getStatements((Resource)uRI, RDFS.COMMENT, null, false, new Resource[0])).iterator().next()).getObject();
        TestValues.assertNotNull((Object)literal);
        TestValues.assertNull((Object)literal.getLanguage());
        TestValues.assertEquals((String)"he really knows where his towel is", (String)literal.getLabel());
        TestValues.assertNull((Object)literal.getDatatype());
        URI uRI2 = valueFactory.createURI("http://knowledgereefsystems.com/agsail/test/thor");
        URI uRI3 = valueFactory.createURI("http://xmlns.com/foaf/0.1/name");
        Iterator iterator = this.toSet(allegroSailConnection.getStatements((Resource)uRI2, uRI3, null, false, new Resource[0])).iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            literal = (Literal)((Statement)iterator.next()).getObject();
            if (!literal.getLanguage().equals("en")) continue;
            bl = true;
            TestValues.assertEquals((String)"Thor", (String)literal.getLabel());
            TestValues.assertNull((Object)literal.getDatatype());
        }
        TestValues.assertTrue((boolean)bl);
        URI uRI4 = valueFactory.createURI("http://xmlns.com/foaf/0.1/msnChatID");
        literal = (Literal)((Statement)this.toSet(allegroSailConnection.getStatements((Resource)uRI2, uRI4, null, false, new Resource[0])).iterator().next()).getObject();
        TestValues.assertNotNull((Object)literal);
        TestValues.assertNull((Object)literal.getLanguage());
        TestValues.assertEquals((String)"Thorster123", (String)literal.getLabel());
        TestValues.assertEquals((Object)XMLSchema.STRING, (Object)literal.getDatatype());
        URI uRI5 = valueFactory.createURI("http://knowledgereefsystems.com/agsail/test/hasValue");
        URI uRI6 = valueFactory.createURI("http://knowledgereefsystems.com/agsail/test/stringValue");
        literal = (Literal)((Statement)this.toSet(allegroSailConnection.getStatements((Resource)uRI6, uRI5, null, false, new Resource[0])).iterator().next()).getObject();
        TestValues.assertNotNull((Object)literal);
        TestValues.assertNull((Object)literal.getLanguage());
        TestValues.assertEquals((String)"foo", (String)literal.getLabel());
        TestValues.assertEquals((Object)XMLSchema.STRING, (Object)literal.getDatatype());
        uRI6 = valueFactory.createURI("http://knowledgereefsystems.com/agsail/test/byteValue");
        literal = (Literal)((Statement)this.toSet(allegroSailConnection.getStatements((Resource)uRI6, uRI5, null, false, new Resource[0])).iterator().next()).getObject();
        TestValues.assertNotNull((Object)literal);
        TestValues.assertNull((Object)literal.getLanguage());
        TestValues.assertEquals((String)"99", (String)literal.getLabel());
        TestValues.assertEquals((Object)XMLSchema.BYTE, (Object)literal.getDatatype());
        TestValues.assertEquals((int)99, (int)literal.byteValue());
        uRI6 = valueFactory.createURI("http://knowledgereefsystems.com/agsail/test/booleanValue");
        literal = (Literal)((Statement)this.toSet(allegroSailConnection.getStatements((Resource)uRI6, uRI5, null, false, new Resource[0])).iterator().next()).getObject();
        TestValues.assertNotNull((Object)literal);
        TestValues.assertNull((Object)literal.getLanguage());
        TestValues.assertEquals((String)"false", (String)literal.getLabel());
        TestValues.assertEquals((Object)XMLSchema.BOOLEAN, (Object)literal.getDatatype());
        TestValues.assertEquals((boolean)false, (boolean)literal.booleanValue());
        uRI6 = valueFactory.createURI("http://knowledgereefsystems.com/agsail/test/intValue");
        literal = (Literal)((Statement)this.toSet(allegroSailConnection.getStatements((Resource)uRI6, uRI5, null, false, new Resource[0])).iterator().next()).getObject();
        TestValues.assertNotNull((Object)literal);
        TestValues.assertNull((Object)literal.getLanguage());
        TestValues.assertEquals((String)"42", (String)literal.getLabel());
        TestValues.assertEquals((Object)XMLSchema.INT, (Object)literal.getDatatype());
        TestValues.assertEquals((int)42, (int)literal.intValue());
        uRI6 = valueFactory.createURI("http://knowledgereefsystems.com/agsail/test/shortValue");
        literal = (Literal)((Statement)this.toSet(allegroSailConnection.getStatements((Resource)uRI6, uRI5, null, false, new Resource[0])).iterator().next()).getObject();
        TestValues.assertNotNull((Object)literal);
        TestValues.assertNull((Object)literal.getLanguage());
        TestValues.assertEquals((String)"42", (String)literal.getLabel());
        TestValues.assertEquals((Object)XMLSchema.SHORT, (Object)literal.getDatatype());
        TestValues.assertEquals((short)42, (short)literal.shortValue());
        uRI6 = valueFactory.createURI("http://knowledgereefsystems.com/agsail/test/longValue");
        literal = (Literal)((Statement)this.toSet(allegroSailConnection.getStatements((Resource)uRI6, uRI5, null, false, new Resource[0])).iterator().next()).getObject();
        TestValues.assertNotNull((Object)literal);
        TestValues.assertNull((Object)literal.getLanguage());
        TestValues.assertEquals((String)"42", (String)literal.getLabel());
        TestValues.assertEquals((Object)XMLSchema.LONG, (Object)literal.getDatatype());
        TestValues.assertEquals((long)42L, (long)literal.longValue());
        uRI6 = valueFactory.createURI("http://knowledgereefsystems.com/agsail/test/floatValue");
        literal = (Literal)((Statement)this.toSet(allegroSailConnection.getStatements((Resource)uRI6, uRI5, null, false, new Resource[0])).iterator().next()).getObject();
        TestValues.assertNotNull((Object)literal);
        TestValues.assertNull((Object)literal.getLanguage());
        TestValues.assertEquals((String)"3.1415926", (String)literal.getLabel());
        TestValues.assertEquals((Object)XMLSchema.FLOAT, (Object)literal.getDatatype());
        TestValues.assertEquals((Object)Float.valueOf(3.1415925f), (Object)Float.valueOf(literal.floatValue()));
        uRI6 = valueFactory.createURI("http://knowledgereefsystems.com/agsail/test/doubleValue");
        literal = (Literal)((Statement)this.toSet(allegroSailConnection.getStatements((Resource)uRI6, uRI5, null, false, new Resource[0])).iterator().next()).getObject();
        TestValues.assertNotNull((Object)literal);
        TestValues.assertNull((Object)literal.getLanguage());
        TestValues.assertEquals((String)"3.1415926", (String)literal.getLabel());
        TestValues.assertEquals((Object)XMLSchema.DOUBLE, (Object)literal.getDatatype());
        TestValues.assertEquals((Object)3.1415926, (Object)literal.doubleValue());
        uRI6 = valueFactory.createURI("http://knowledgereefsystems.com/agsail/test/dateTimeValue");
        XMLGregorianCalendar xMLGregorianCalendar = XMLDatatypeUtil.parseCalendar((String)"2002-10-10T12:00:00-05:00");
        literal = (Literal)((Statement)this.toSet(allegroSailConnection.getStatements((Resource)uRI6, uRI5, null, false, new Resource[0])).iterator().next()).getObject();
        TestValues.assertNotNull((Object)literal);
        TestValues.assertNull((Object)literal.getLanguage());
        TestValues.assertEquals((String)"2002-10-10T12:00:00-05:00", (String)literal.getLabel());
        TestValues.assertEquals((Object)XMLSchema.DATETIME, (Object)literal.getDatatype());
        TestValues.assertEquals((Object)xMLGregorianCalendar, (Object)literal.calendarValue());
        allegroSailConnection.close();
    }

    public void testBlankNodes() throws Exception {
        System.out.println("who needs blank nodes?");
    }
}

