package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGAddStatements {

	/**
	 * Demonstrates some basics of adding triples over a socket.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		// Create a fresh triple-store for this example.
		AllegroGraph ts = ags.renew("addstatements", AGPaths.TRIPLE_STORES);
		
		// Add a single triple to the store
		ts.addStatement("<http://example.org/Dog>",  
				"<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>",  
				"<http://www.w3.org/2002/07/owl#Class>"); 

		// For bulk loading over a socket, it is more efficient to buffer 
		// the operation by grouping the triple components into arrays. 
		// The following statement creates 4 triples from corresponding 
		// elements of the arrays.
		ts.addStatements(  
		new String[]{  
		    "<http://example.org/Cat>",  
		    "<http://example.org/Dog>",  
		    "<http://example.org/Giraffe>",  
		    "<http://example.org/Lion>" },  
		new String[]{  
		    "<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>",  
		    "<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>",  
		    "<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>",  
		    "<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>" },  
		new String[]{  
		    "<http://www.w3.org/2002/07/owl#Class>",  
		    "<http://www.w3.org/2002/07/owl#Class>",  
		    "<http://www.w3.org/2002/07/owl#Class>",  
		    "<http://www.w3.org/2002/07/owl#Class>" }  
		);                             

		// When an array consists of identical elements, it can be 
		// shortened to a single element. The following statement 
		// creates 4 triples where the predicate and object 
		// components are identical.
		ts.addStatements(  
		    new String[]{  
		        "<http://example.org/Cat>",  
			    "<http://example.org/Dog>",  
		        "<http://example.org/Giraffe>",  
		        "<http://example.org/Lion>" },  
		    new String[]{"<http://www.w3.org/2000/01/rdf-schema#subClassOf>"},  
		    new String[]{"<http://example.org/Mammal>"}  
		); 
		
		System.out.println("Added " + ts.numberOfTriples() + " triples to the store.");
		
		// Close the store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}
}
