package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGPrologIncludeInferred {

	/**
	 * Demonstrates some basics of using the includeInferred setting in PrologSelect queries. 
	 * 
	 * @param unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		// Create a fresh triple-store for this example.
		AllegroGraph ts = ags.renew("prologincludeinferred", AGPaths.TRIPLE_STORES);
		
		// Register your namespaces
		ts.registerNamespace("ex","http://example.org/");
		
		// Add some triples to the store
		ts.addStatement("!ex:a","!ex:owned-by","!ex:b");
		ts.addStatement("!ex:c","!ex:owns","!ex:d");
		ts.addStatement("!ex:jans","!ex:owns","!ex:birra");
		ts.addStatement("!ex:owned-by","!owl:inverseOf","!ex:owns");

		// Index the store
		ts.indexAllTriples();
		
		// Set up a PrologSelect query object that does not include RDFS++ inferences.
		PrologSelectQuery q = new PrologSelectQuery();
		q.setTripleStore(ts);
		q.setIncludeInferred(false);

		// Here the q functor will not include rdfs++-inferred
		// results because the includeInferred setting is false.
		String[] vars = new String[]{"x","y"};
		String pquery = "(q ?x !ex:owns ?y)";
		q.setVariables(vars);
		q.setQuery(pquery);
		ValueSetIterator it = q.run();
		System.out.println("Results (no reasoning) for " + pquery);
		AGUtils.showResults(it);

		// Now include inferences.
		q.setIncludeInferred(true);
		it = q.run();
		System.out.println("Results (with reasoning) for " + pquery);
		AGUtils.showResults(it);
		
		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}
