package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGSNACliques {

	/**
	 * Demonstrates locating cliques in a Social Network.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple-store.
		AllegroGraph ts = ags.renew("snacliques", AGPaths.TRIPLE_STORES);
		
		// Register namespaces
		ts.registerNamespace("ex", "http://example.org/");
		
		// Load a small graph of data
		AGLoadNtriples.loadNTriplesWithTiming(ts, AGPaths.dataSources("sna-cycle.nt"));
		
		// Get an SNA extension instance for this store to work with SNA features 
		SNAExtension sna = ts.getSNAExtension();
		
		// Register a generator
		Object[] parts = new Object[2];
		parts[0] = "objects-of";
		parts[1] = "!ex:to";
		sna.registerGenerator("to", parts);
		
		// Define a group of actors
		String[] group = {"!ex:a","!ex:b","!ex:c","!ex:d","!ex:e","!ex:f","!ex:g","!ex:h"};
		
		// find cliques involving each actor
		for (int i=0;i<group.length;i++) {
			UPI[][] cliques = sna.getCliques(group[i], "to", 2);
			System.out.println("There are " + cliques.length + " cliques involving " + group[i]);
		}
		
		// Close the store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}
