package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGSetServerParams {

	/**
	 * Demonstrates some basics of setting server parameters
	 * 
	 * For this example you will need a server running on port 4126.
	 * See also the instructions on starting a server manually. 
	 * 
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {

		// Save some current default values to reset them later. 
		int db = AllegroGraphConnection.getDefaultDebug();
		int pollcount = AllegroGraphConnection.getDefaultPollCount();
		int pollinterval  = AllegroGraphConnection.getDefaultPollInterval();
		int port  = AllegroGraphConnection.getDefaultPort();
		
		// Modify some default server parameters 
		AllegroGraphConnection.setDefaultDebug(0);
		AllegroGraphConnection.setDefaultPolling(3, 600);
		AllegroGraphConnection.setDefaultPort(4126);

		// Connect to a server, which must already be running.
		// Note that the default connection is now to port 4126
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem -- please start a server on port " + ags.getPort(), e);
		}

		// Show information about the connection
		AGServerInfo.showConnectionInstanceInfo(ags);
		
		// Modify some current connection settings 
		ags.setChunkSize(1000000);
		ags.setDebug(1);
		ags.setDefaultExpectedResources(2000000);
		ags.setHost("foo.example.com");
		ags.setPolling(2, 500);
		ags.setPort(5678);
		ags.setServerKeep(true);
		ags.setDefaultServerKeep(false);
		
		// Show information about the connection
		AGServerInfo.showConnectionInstanceInfo(ags);
		
		// Disconnect from the server
		ags.disable();
		
		// Set connection defaults back to their original values
		AllegroGraphConnection.setDefaultDebug(db);
		AllegroGraphConnection.setDefaultPolling(pollcount, pollinterval);
		AllegroGraphConnection.setDefaultPort(port);
	}
}