package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGSparqlUnions {

	/**
	 * Demonstrates some basics of using UNION in SPARQL
	 * 
	 * @param args unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		
		// Create fresh triple-store for this example.
		AllegroGraph ts = ags.renew("sparql", AGPaths.TRIPLE_STORES);
				
		// Register any namespaces
		ts.registerNamespace("dc10", "http://purl.org/dc/elements/1.0/");
		ts.registerNamespace("dc11", "http://purl.org/dc/elements/1.1/");
		
		// Define blank nodes
		BlankNode a = (BlankNode)ts.createBNode("_:a");
		BlankNode b = (BlankNode)ts.createBNode("_:b");
		BlankNode c = (BlankNode)ts.createBNode("_:c");
		
		// Add some data to the store
		ts.addStatement(a,"!dc10:title",ts.createLiteral("SPARQL Query Language Tutorial"));
		ts.addStatement(a,"!dc10:creator",ts.createLiteral("Alice"));
		ts.addStatement(b,"!dc11:title",ts.createLiteral("SPARQL Protocol Tutorial"));
		ts.addStatement(b,"!dc11:creator",ts.createLiteral("Bob"));
		ts.addStatement(c,"!dc10:title",ts.createLiteral("SPARQL"));
		ts.addStatement(c,"!dc11:title",ts.createLiteral("SPARQL (Updated)"));

		// This query finds titles of the books in the data, whether the title 
		// is recorded using Dublin Core properties from version 1.0 or version 1.1.
		String query =
		"PREFIX dc10:  <http://purl.org/dc/elements/1.0/> " +
		"PREFIX dc11:  <http://purl.org/dc/elements/1.1/> " +
		"SELECT ?title " +
		"WHERE  { { ?book dc10:title  ?title } UNION { ?book dc11:title  ?title } }";
		
		// Query the store and show the results
		SPARQLQuery sq = new SPARQLQuery();
		sq.setTripleStore(ts);
		sq.setQuery(query);
		AGSparqlSelect.doSparqlSelect(sq);
		
		// This query will only match a book if it has both a title and creator 
		// predicate from the same version of Dublin Core.
		query =
		"PREFIX dc10:  <http://purl.org/dc/elements/1.0/> " +
		"PREFIX dc11:  <http://purl.org/dc/elements/1.1/> " +
		"SELECT ?title ?author " +
		"WHERE  { { ?book dc10:title ?title .  ?book dc10:creator ?author } " +
					"UNION " +
					"{ ?book dc11:title ?title .  ?book dc11:creator ?author } " +
					"}";
		
		// Query the store and show the results
		sq.setQuery(query);
		AGSparqlSelect.doSparqlSelect(sq);
			
		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}