package com.franz.agjena.examples;



import java.util.Iterator;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphConnection;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.examples.AGPaths;
import com.franz.agjena.AllegroGraphGraphMaker;
import com.franz.agjena.AllegroGraphModel;
import com.franz.agjena.AllegroGraphReasoner;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.Model;

public class AGJenaNamedGraphs {

	/**
	 * Demonstrates using multiple named Graphs in store, and inference
	 *
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple store
		AllegroGraph ts = ags.renew("jenatest4", AGPaths.TRIPLE_STORES);

		// Get a Graph Maker for the store
	    AllegroGraphGraphMaker maker = new AllegroGraphGraphMaker(ts);
        maker.setDefaultIsGraphOfAllGraphs(true);

        // Create several Graphs and Models 
        String demoNamespace = "http://ag.franz.com/demo#";
        String graphName1 = demoNamespace + "context1";
        String graphName2 = demoNamespace + "context2";
        Graph graphAll = maker.getGraph(); // default graph represents the graph containing all triples 
        Graph graphOne = maker.createGraph(graphName1);
        Graph graphTwo = maker.createGraph(graphName2);
        Graph graphThree = new AllegroGraphReasoner().bind(graphTwo);
        Model modelAll = new AllegroGraphModel(graphAll);
        Model modelOne = new AllegroGraphModel(graphOne);
        Model modelTwo = new AllegroGraphModel(graphTwo);
        
        // Show all graph names
        for (Iterator<?> it = maker.listGraphs(); it.hasNext();) {
        	System.out.println("GraphName: " + it.next());
        }

        // Load some data
		String inputFileName1 = AGPaths.dataSources("vc-db-1.rdf");
        String inputFileName2 = AGPaths.dataSources("football.nt");
        modelOne.read(inputFileName1, "RDF/XML" );
        modelTwo.read(inputFileName2, "N-TRIPLE" );
        
        // A query
        String query = "select ?s ?p ?o where {?s ?p ?o }";
        
    	// return all triples (or none)
    	AGJenaUtils.doQuery(query, modelAll);
        
    	// retrieve all vcard triples
    	AGJenaUtils.doQuery(query, modelOne);

    	// retrieve all football triples (no inference)        	
    	AGJenaUtils.doQuery(query, modelTwo);

    	// retrieve all football triples with inference
    	AGJenaUtils.doQuery(query, graphThree);
   	
		// Close the store and disconnect from the server
		ts.closeTripleStore();
		ags.disable();
	}

}
