/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase.impl;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.TriplesIterator;
import com.franz.agbase.UPI;
import com.franz.agbase.URINode;
import com.franz.agbase.impl.ResourceNodeImpl;
import com.franz.agbase.impl.UPIImpl;
import com.franz.agbase.util.AGInternals;

public class URINodeImpl
extends ResourceNodeImpl
implements URINode {
    private static final long serialVersionUID = 8675791173081086903L;
    String uri = null;
    public static final URINode nullContext = new URINodeImpl(null, UPIImpl.nullUPI(), null);

    URINodeImpl(AllegroGraph allegroGraph, UPI uPI, String string) {
        this.owner = allegroGraph;
        this.nodeUPI = uPI;
        this.uri = string;
    }

    public UPI getAGId() throws AllegroGraphException {
        UPI uPI = this.queryAGId();
        uPI = URINodeImpl.getUPI(this.owner, uPI, this.uri);
        this.setAGId(uPI);
        return uPI;
    }

    public static UPI getUPI(AGInternals aGInternals, UPI uPI, String string) throws AllegroGraphException {
        if (UPIImpl.canReference(uPI)) {
            return uPI;
        }
        if (string == null) {
            throw new IllegalStateException("Cannot realize a node without a URI");
        }
        uPI = aGInternals.verifyEnabled().newResource(aGInternals, string);
        return uPI;
    }

    public String queryURI() {
        return this.uri;
    }

    public String getLocalName() {
        this.uri = this.owner.getText(this.nodeUPI, this.uri);
        int n = this.uri.indexOf("#");
        if (n < 0) {
            return "";
        }
        return this.uri.substring(n + 1);
    }

    public String getNamespace() {
        this.uri = this.owner.getText(this.nodeUPI, this.uri);
        int n = this.uri.indexOf("#");
        if (n < 0) {
            return this.uri;
        }
        return this.uri.substring(0, n + 1);
    }

    public String toString() {
        this.uri = this.owner.getText(this.nodeUPI, this.uri);
        return this.uri;
    }

    public boolean equals(Object object) {
        switch (this.sameAGId(object)) {
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        if (object instanceof URINode) {
            return this.toString().equals(object.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public TriplesIterator getPredicateStatements() throws AllegroGraphException {
        return this.owner.getStatements(null, this, null);
    }

    public String getURI() {
        return this.toString();
    }

    public void add() throws AllegroGraphException {
        this.getAGId();
    }
}

