/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agjena;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.BlankNode;
import com.franz.agbase.LiteralNode;
import com.franz.agbase.UPI;
import com.franz.agbase.ValueObject;
import com.franz.agbase.impl.BlankNodeImpl;
import com.franz.agbase.impl.URINodeImpl;
import com.franz.agbase.util.AGInternals;
import com.franz.agjena.Utils;
import com.franz.agjena.exceptions.NiceException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Blank;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import java.util.HashMap;
import java.util.Map;

public class JenaToAGManager {
    private AllegroGraph agStore;
    Map<Node, UPI> blankNodeToUPIMap = new HashMap<Node, UPI>();
    Map<UPI, Node> UPIToBlankNodeMap = new HashMap<UPI, Node>();

    JenaToAGManager(AllegroGraph allegroGraph) {
        this.agStore = allegroGraph;
    }

    AllegroGraph getAGStore() {
        return this.agStore;
    }

    private synchronized UPI lookupUPIForBlankNode(Node_Blank node_Blank, boolean bl) throws AllegroGraphException {
        UPI uPI = this.blankNodeToUPIMap.get(node_Blank);
        if (uPI != null) {
            return uPI;
        }
        if (!bl) {
            return null;
        }
        UPI uPI2 = this.agStore.createBNodeIds(1)[0];
        this.UPIToBlankNodeMap.put(uPI2, (Node)node_Blank);
        this.blankNodeToUPIMap.put((Node)node_Blank, uPI2);
        return uPI2;
    }

    protected synchronized Node lookupBlankNodeForUPI(UPI uPI, boolean bl) {
        Node node = this.UPIToBlankNodeMap.get(uPI);
        if (node != null) {
            return node;
        }
        if (!bl) {
            return null;
        }
        Node node2 = Node.createAnon((AnonId)AnonId.create((String)uPI.toString()));
        this.UPIToBlankNodeMap.put(uPI, node2);
        this.blankNodeToUPIMap.put(node2, uPI);
        return node2;
    }

    private static String getLanguageTag(Node_Literal node_Literal) {
        String string = node_Literal.getLiteralLanguage();
        if (string == null) {
            return null;
        }
        if (string.equals("")) {
            return null;
        }
        return string;
    }

    public String jenaNodeToAgStringTerm(Node node) {
        Object object = this.jenaNodeToAGTerm(node, false);
        if (object instanceof UPI) {
            String string = this.agStore.refToString(object);
            return string;
        }
        return (String)object;
    }

    public Object jenaNodeToAGTerm(Node node) {
        return this.jenaNodeToAGTerm(node, false);
    }

    public Object jenaNodeToAGTerm(Node node, boolean bl) {
        if (node instanceof Node_Blank) {
            try {
                return this.lookupUPIForBlankNode((Node_Blank)node, true);
            }
            catch (AllegroGraphException allegroGraphException) {
                throw new IllegalStateException(allegroGraphException.toString());
            }
        }
        if (node instanceof Node_URI) {
            return AGInternals.refNodeToString(node.getURI());
        }
        if (node instanceof Node_Literal) {
            Node_Literal node_Literal = (Node_Literal)node;
            return AGInternals.refLitToString(node_Literal.getLiteralLexicalForm(), JenaToAGManager.getLanguageTag(node_Literal), node_Literal.getLiteralDatatypeURI());
        }
        if (bl) {
            return null;
        }
        throw new IllegalArgumentException("Must be concrete Node");
    }

    public Node assembleJenaGraphNode(UPI uPI, int n, String string, String string2) {
        switch (n) {
            case 1: {
                return this.lookupBlankNodeForUPI(uPI, true);
            }
            case 2: {
                return Node.createURI((String)string);
            }
            case 3: {
                return Node.createLiteral((String)string);
            }
            case 4: {
                return Node.createLiteral((String)string, (String)string2, (boolean)false);
            }
            case 5: {
                RDFDatatype rDFDatatype = TypeMapper.getInstance().getTypeByName(string2);
                return Node.createLiteral((String)string, null, (RDFDatatype)rDFDatatype);
            }
        }
        throw new IllegalArgumentException("Cannot convert AG " + n + "=" + this.agStore.typeToString(n) + "/" + string + "/" + string2 + " to Jena Graph Node");
    }

    public Node valueObjectToJenaNode(ValueObject valueObject) {
        try {
            if (valueObject instanceof LiteralNode) {
                LiteralNode literalNode = (LiteralNode)valueObject;
                Node node = null;
                node = !Utils.isNullString(literalNode.getLanguage()) ? this.assembleJenaGraphNode(literalNode.getAGId(), 4, literalNode.getLabel(), literalNode.getLanguage()) : this.assembleJenaGraphNode(literalNode.getAGId(), 3, literalNode.getLabel(), null);
                return node;
            }
            if (valueObject instanceof BlankNode) {
                BlankNode blankNode = (BlankNode)valueObject;
                Node node = this.assembleJenaGraphNode(((BlankNodeImpl)blankNode).getAGId(), 1, blankNode.getID(), null);
                return node;
            }
            URINodeImpl uRINodeImpl = (URINodeImpl)valueObject;
            Node node = this.assembleJenaGraphNode(uRINodeImpl.getAGId(), 2, uRINodeImpl.getURI(), null);
            return node;
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new NiceException(allegroGraphException);
        }
    }

    public RDFNode valueObjectToRDFNode(ValueObject valueObject, ModelCom modelCom) {
        Node node = this.valueObjectToJenaNode(valueObject);
        if (node.isLiteral()) {
            return new LiteralImpl((Node)((Node_Literal)node), modelCom);
        }
        return new ResourceImpl(node, modelCom);
    }
}

