/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agsail.impl;

import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.Triple;
import com.franz.agbase.TriplesIterator;
import com.franz.agbase.UPI;
import com.franz.agsail.AGForSail;
import com.franz.agsail.AGSailCursor;
import com.franz.agsail.AGSailTriple;
import com.franz.agsail.impl.AGSailFactory;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class AGSailCursorImpl
implements AGSailCursor {
    private AGForSail ag;
    private TriplesIterator directInstance = null;
    Resource ssail = null;
    URI psail = null;
    Value osail = null;
    Resource csail = null;

    public int getLookAhead() {
        return this.directInstance.getLookAhead();
    }

    public void setLookAhead(int n) {
        this.directInstance.setLookAhead(n);
    }

    public AGForSail getAG() {
        return this.ag;
    }

    AGSailCursorImpl(AGForSail aGForSail, TriplesIterator triplesIterator) {
        this.ag = aGForSail;
        this.directInstance = triplesIterator;
    }

    private void stepInstances() {
        this.ssail = null;
        this.psail = null;
        this.osail = null;
        this.csail = null;
    }

    public AGForSail getStore() {
        return this.ag;
    }

    public long get_id() {
        return this.directInstance.get_id();
    }

    public synchronized UPI getS() {
        return this.directInstance.getS();
    }

    public String querySubject() {
        return this.directInstance.querySubject();
    }

    public String queryObject() {
        return this.directInstance.queryObject();
    }

    public String queryPredicate() {
        return this.directInstance.queryPredicate();
    }

    public String queryContext() {
        return this.directInstance.queryContext();
    }

    public synchronized String getSubjectLabel() throws AllegroGraphException {
        return this.directInstance.getSubjectLabel();
    }

    public Resource getSubject() throws AllegroGraphException {
        if (this.ssail == null) {
            this.ssail = (Resource)this.ag.coerceToSailValue(this.directInstance.getSubject());
        }
        return this.ssail;
    }

    public Resource getContext() throws AllegroGraphException {
        if (this.csail == null) {
            this.csail = (Resource)this.ag.coerceToSailValue(this.directInstance.getContext());
        }
        return this.csail;
    }

    public synchronized UPI getP() {
        return this.directInstance.getP();
    }

    public synchronized String getPredicateLabel() throws AllegroGraphException {
        return this.directInstance.getPredicateLabel();
    }

    public URI getPredicate() throws AllegroGraphException {
        if (this.psail == null) {
            this.psail = (URI)this.ag.coerceToSailValue(this.directInstance.getPredicate());
        }
        return this.psail;
    }

    public synchronized UPI getO() {
        return this.directInstance.getO();
    }

    public synchronized UPI getC() {
        return this.directInstance.getC();
    }

    public synchronized String getObjectLabel() throws AllegroGraphException {
        return this.directInstance.getObjectLabel();
    }

    public synchronized String getContextLabel() throws AllegroGraphException {
        return this.directInstance.getContextLabel();
    }

    public Value getObject() throws AllegroGraphException {
        if (this.osail == null) {
            this.osail = this.ag.coerceToSailValue(this.directInstance.getObject());
        }
        return this.osail;
    }

    public synchronized AGSailTriple queryTriple() {
        return AGSailFactory.makeTriple(this.ag, this.directInstance.queryTriple());
    }

    public synchronized AGSailTriple getTriple() throws AllegroGraphException {
        return AGSailFactory.makeTriple(this.ag, this.directInstance.getTriple());
    }

    public synchronized Statement next() {
        if (this.hasNext()) {
            try {
                this.step();
            }
            catch (AllegroGraphException allegroGraphException) {
                throw new IllegalStateException("Cursor.next " + allegroGraphException);
            }
        }
        return this.queryTriple();
    }

    public synchronized AGSailTriple getNext() {
        if (this.hasNext()) {
            try {
                this.step();
            }
            catch (AllegroGraphException allegroGraphException) {
                throw new IllegalStateException("Cursor.next " + allegroGraphException);
            }
        }
        return this.queryTriple();
    }

    public boolean atTriple() {
        return this.directInstance.atTriple();
    }

    public boolean hasNext() {
        return this.directInstance.hasNext();
    }

    public boolean limitReached() {
        return this.directInstance.limitReached();
    }

    public void close() {
        this.stepInstances();
        this.directInstance.close();
    }

    public synchronized boolean step() throws AllegroGraphException {
        this.stepInstances();
        return this.directInstance.step();
    }

    public synchronized AGSailTriple[] step(int n) throws AllegroGraphException {
        Triple[] tripleArray = this.directInstance.step(n);
        AGSailTriple[] aGSailTripleArray = new AGSailTriple[tripleArray.length];
        for (int i = 0; i < aGSailTripleArray.length; ++i) {
            aGSailTripleArray[i] = this.ag.coerceToSailTriple(tripleArray[i]);
        }
        this.stepInstances();
        return aGSailTripleArray;
    }

    public synchronized String toString() {
        return ((Object)this.directInstance).toString();
    }

    public synchronized void remove() {
        this.stepInstances();
        this.directInstance.remove();
    }
}

