/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository;

import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.repository.RepositoryConnectionTest;
import org.openrdf.repository.RepositoryResult;

public abstract class RDFSchemaRepositoryConnectionTest
extends RepositoryConnectionTest {
    private URI person;
    private URI woman;
    private URI man;

    public RDFSchemaRepositoryConnectionTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.person = this.vf.createURI("http://xmlns.com/foaf/0.1/Person");
        this.woman = this.vf.createURI("http://example.org/Woman");
        this.man = this.vf.createURI("http://example.org/Man");
    }

    public void testDomainInference() throws Exception {
        this.testCon.add((Resource)this.name, RDFS.DOMAIN, (Value)this.person, new Resource[0]);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        RDFSchemaRepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)this.bob, RDF.TYPE, (Value)this.person, true, new Resource[0]));
    }

    public void testSubClassInference() throws Exception {
        this.testCon.setAutoCommit(false);
        this.testCon.add((Resource)this.woman, RDFS.SUBCLASSOF, (Value)this.person, new Resource[0]);
        this.testCon.add((Resource)this.man, RDFS.SUBCLASSOF, (Value)this.person, new Resource[0]);
        this.testCon.add((Resource)this.alice, RDF.TYPE, (Value)this.woman, new Resource[0]);
        this.testCon.setAutoCommit(true);
        RDFSchemaRepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)this.alice, RDF.TYPE, (Value)this.person, true, new Resource[0]));
    }

    public void testMakeExplicit() throws Exception {
        this.testCon.setAutoCommit(false);
        this.testCon.add((Resource)this.woman, RDFS.SUBCLASSOF, (Value)this.person, new Resource[0]);
        this.testCon.add((Resource)this.alice, RDF.TYPE, (Value)this.woman, new Resource[0]);
        this.testCon.setAutoCommit(true);
        RDFSchemaRepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)this.alice, RDF.TYPE, (Value)this.person, true, new Resource[0]));
        this.testCon.add((Resource)this.alice, RDF.TYPE, (Value)this.person, new Resource[0]);
        RDFSchemaRepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)this.alice, RDF.TYPE, (Value)this.person, true, new Resource[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExplicitFlag() throws Exception {
        RepositoryResult repositoryResult = this.testCon.getStatements((Resource)RDF.TYPE, RDF.TYPE, null, true, new Resource[0]);
        try {
            RDFSchemaRepositoryConnectionTest.assertTrue((String)"result should not be empty", (boolean)repositoryResult.hasNext());
        }
        finally {
            repositoryResult.close();
        }
        repositoryResult = this.testCon.getStatements((Resource)RDF.TYPE, RDF.TYPE, null, false, new Resource[0]);
        try {
            RDFSchemaRepositoryConnectionTest.assertFalse((String)"result should be empty", (boolean)repositoryResult.hasNext());
        }
        finally {
            repositoryResult.close();
        }
    }

    public void testInferencerUpdates() throws Exception {
        this.testCon.setAutoCommit(false);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        this.testCon.remove((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        this.testCon.setAutoCommit(true);
        RDFSchemaRepositoryConnectionTest.assertFalse((boolean)this.testCon.hasStatement((Resource)this.bob, RDF.TYPE, (Value)RDFS.RESOURCE, true, new Resource[0]));
    }

    public void testInferencerQueryDuringTransaction() throws Exception {
        this.testCon.setAutoCommit(false);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        RDFSchemaRepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)this.bob, RDF.TYPE, (Value)RDFS.RESOURCE, true, new Resource[0]));
        this.testCon.setAutoCommit(true);
    }

    public void testInferencerTransactionIsolation() throws Exception {
        this.testCon.setAutoCommit(false);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        RDFSchemaRepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)this.bob, RDF.TYPE, (Value)RDFS.RESOURCE, true, new Resource[0]));
        RDFSchemaRepositoryConnectionTest.assertFalse((boolean)this.testCon2.hasStatement((Resource)this.bob, RDF.TYPE, (Value)RDFS.RESOURCE, true, new Resource[0]));
        this.testCon.setAutoCommit(true);
        RDFSchemaRepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)this.bob, RDF.TYPE, (Value)RDFS.RESOURCE, true, new Resource[0]));
        RDFSchemaRepositoryConnectionTest.assertTrue((boolean)this.testCon2.hasStatement((Resource)this.bob, RDF.TYPE, (Value)RDFS.RESOURCE, true, new Resource[0]));
    }
}

