/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository;

import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.Ignore;
import org.openrdf.model.BNode;
import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.GraphImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.BindingSet;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.Dataset;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.helpers.RDFHandlerBase;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public abstract class RepositoryConnectionTest
extends TestCase {
    protected static final String FOAF_NS = "http://xmlns.com/foaf/0.1/";
    protected static final String DC_NS = "http://purl.org/dc/elements/1.1/";
    public static final String TEST_DIR_PREFIX = "/testcases/";
    protected Repository testRepository;
    protected RepositoryConnection testCon;
    protected RepositoryConnection testCon2;
    protected ValueFactory vf;
    protected BNode bob;
    protected BNode alice;
    protected BNode alexander;
    protected URI name;
    protected URI mbox;
    protected URI publisher;
    protected URI unknownContext;
    protected URI context1;
    protected URI context2;
    protected Literal nameAlice;
    protected Literal nameBob;
    protected Literal mboxAlice;
    protected Literal mboxBob;
    protected Literal strangeUnicodeVarname;

    public RepositoryConnectionTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.testRepository = this.createRepository();
        this.testRepository.initialize();
        this.testCon = this.testRepository.getConnection();
        this.testCon.clear(new Resource[0]);
        this.testCon.clearNamespaces();
        this.testCon2 = this.testRepository.getConnection();
        this.vf = this.testRepository.getValueFactory();
        this.bob = this.vf.createBNode();
        this.alice = this.vf.createBNode();
        this.alexander = this.vf.createBNode();
        this.name = this.vf.createURI("http://xmlns.com/foaf/0.1/name");
        this.mbox = this.vf.createURI("http://xmlns.com/foaf/0.1/mbox");
        this.publisher = this.vf.createURI("http://purl.org/dc/elements/1.1/publisher");
        this.nameAlice = this.vf.createLiteral("Alice");
        this.nameBob = this.vf.createLiteral("Bob");
        this.mboxAlice = this.vf.createLiteral("alice@example.org");
        this.mboxBob = this.vf.createLiteral("bob@example.org");
        this.strangeUnicodeVarname = this.vf.createLiteral("strangeUnicodeVarname");
        this.unknownContext = new URIImpl("urn:unknownContext");
        this.context1 = this.vf.createURI("urn:x-local:graph1");
        this.context2 = this.vf.createURI("urn:x-local:graph2");
    }

    protected void tearDown() throws Exception {
        this.testCon2.close();
        this.testCon2 = null;
        this.testCon.close();
        this.testCon = null;
        this.testRepository.shutDown();
        this.testRepository = null;
        this.vf = null;
    }

    protected abstract Repository createRepository() throws Exception;

    public void testAddStatement() throws Exception {
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        RepositoryConnectionTest.assertTrue((String)"Repository should contain newly added statement", (boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
        Statement statement = this.vf.createStatement((Resource)this.alice, this.name, (Value)this.nameAlice);
        this.testCon.add(statement, new Resource[0]);
        RepositoryConnectionTest.assertTrue((String)"Repository should contain newly added statement", (boolean)this.testCon.hasStatement(statement, false, new Resource[0]));
        RepositoryConnectionTest.assertTrue((String)"Repository should contain newly added statement", (boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
        SailRepository sailRepository = new SailRepository((Sail)new MemoryStore());
        sailRepository.initialize();
        RepositoryConnection repositoryConnection = sailRepository.getConnection();
        repositoryConnection.add((Iteration)this.testCon.getStatements(null, null, null, false, new Resource[0]), new Resource[0]);
        RepositoryConnectionTest.assertTrue((String)"Temp Repository should contain newly added statement", (boolean)repositoryConnection.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
        repositoryConnection.close();
        sailRepository.shutDown();
    }

    @Ignore
    public void testTransactionIsolation() throws Exception {
        this.testCon.setAutoCommit(false);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        RepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
        RepositoryConnectionTest.assertFalse((boolean)this.testCon2.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
        this.testCon.commit();
        RepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
        RepositoryConnectionTest.assertTrue((boolean)this.testCon2.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
    }

    public void testAddReader() throws Exception {
        InputStream inputStream = RepositoryConnectionTest.class.getResourceAsStream("/testcases/default-graph.ttl");
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        this.testCon.add((Reader)inputStreamReader, "", RDFFormat.TURTLE, new Resource[0]);
        ((Reader)inputStreamReader).close();
        RepositoryConnectionTest.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameBob, false, new Resource[0]));
        RepositoryConnectionTest.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameAlice, false, new Resource[0]));
        InputStream inputStream2 = RepositoryConnectionTest.class.getResourceAsStream("/testcases/graph1.ttl");
        InputStreamReader inputStreamReader2 = new InputStreamReader(inputStream2, "UTF-8");
        this.testCon.add((Reader)inputStreamReader2, "", RDFFormat.TURTLE, new Resource[]{this.context1});
        ((Reader)inputStreamReader2).close();
        InputStream inputStream3 = RepositoryConnectionTest.class.getResourceAsStream("/testcases/graph2.ttl");
        InputStreamReader inputStreamReader3 = new InputStreamReader(inputStream3, "UTF-8");
        this.testCon.add((Reader)inputStreamReader3, "", RDFFormat.TURTLE, new Resource[]{this.context2});
        ((Reader)inputStreamReader3).close();
        RepositoryConnectionTest.assertTrue((String)"alice should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[0]));
        RepositoryConnectionTest.assertFalse((String)"alice should not be known in context1", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[]{this.context1}));
        RepositoryConnectionTest.assertTrue((String)"alice should be known in context2", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[]{this.context2}));
        RepositoryConnectionTest.assertTrue((String)"bob should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[0]));
        RepositoryConnectionTest.assertFalse((String)"bob should not be known in context2", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[]{this.context2}));
        RepositoryConnectionTest.assertTrue((String)"bib should be known in context1", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[]{this.context1}));
    }

    public void testAddInputStream() throws Exception {
        InputStream inputStream = RepositoryConnectionTest.class.getResourceAsStream("/testcases/default-graph.ttl");
        this.testCon.add(inputStream, "", RDFFormat.TURTLE, new Resource[0]);
        inputStream.close();
        RepositoryConnectionTest.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameBob, false, new Resource[0]));
        RepositoryConnectionTest.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameAlice, false, new Resource[0]));
        InputStream inputStream2 = RepositoryConnectionTest.class.getResourceAsStream("/testcases/graph1.ttl");
        this.testCon.add(inputStream2, "", RDFFormat.TURTLE, new Resource[]{this.context1});
        inputStream2.close();
        InputStream inputStream3 = RepositoryConnectionTest.class.getResourceAsStream("/testcases/graph2.ttl");
        this.testCon.add(inputStream3, "", RDFFormat.TURTLE, new Resource[]{this.context2});
        inputStream3.close();
        RepositoryConnectionTest.assertTrue((String)"alice should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[0]));
        RepositoryConnectionTest.assertFalse((String)"alice should not be known in context1", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[]{this.context1}));
        RepositoryConnectionTest.assertTrue((String)"alice should be known in context2", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[]{this.context2}));
        RepositoryConnectionTest.assertTrue((String)"bob should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[0]));
        RepositoryConnectionTest.assertFalse((String)"bob should not be known in context2", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[]{this.context2}));
        RepositoryConnectionTest.assertTrue((String)"bib should be known in context1", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[]{this.context1}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddGzipInputStream() throws Exception {
        InputStream inputStream = RepositoryConnectionTest.class.getResourceAsStream("/testcases/default-graph.ttl.gz");
        try {
            this.testCon.add(inputStream, "", RDFFormat.TURTLE, new Resource[0]);
        }
        finally {
            inputStream.close();
        }
        RepositoryConnectionTest.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameBob, false, new Resource[0]));
        RepositoryConnectionTest.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameAlice, false, new Resource[0]));
    }

    public void testAddZipFile() throws Exception {
        InputStream inputStream = RepositoryConnectionTest.class.getResourceAsStream("/testcases/graphs.zip");
        this.testCon.add(inputStream, "", RDFFormat.TURTLE, new Resource[0]);
        RepositoryConnectionTest.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameBob, false, new Resource[0]));
        RepositoryConnectionTest.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameAlice, false, new Resource[0]));
        RepositoryConnectionTest.assertTrue((String)"alice should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[0]));
        RepositoryConnectionTest.assertTrue((String)"bob should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[0]));
    }

    public void testAutoCommit() throws Exception {
        this.testCon.setAutoCommit(false);
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[0]);
        RepositoryConnectionTest.assertTrue((String)"Uncommitted update should be visible to own connection", (boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
        this.testCon.commit();
        RepositoryConnectionTest.assertTrue((String)"Repository should contain statement after commit", (boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
        this.testCon.setAutoCommit(true);
    }

    public void testRollback() throws Exception {
        this.testCon.setAutoCommit(false);
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[0]);
        RepositoryConnectionTest.assertTrue((String)"Uncommitted updates should be visible to own connection", (boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
        this.testCon.rollback();
        RepositoryConnectionTest.assertFalse((String)"Repository should not contain statement after rollback", (boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
        this.testCon.setAutoCommit(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleTupleQuery() throws Exception {
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" SELECT name, mbox");
        stringBuilder.append(" FROM {} foaf:name {name};");
        stringBuilder.append("         foaf:mbox {mbox}");
        stringBuilder.append(" USING NAMESPACE foaf = <http://xmlns.com/foaf/0.1/>");
        TupleQueryResult tupleQueryResult = this.testCon.prepareTupleQuery(QueryLanguage.SERQL, stringBuilder.toString()).evaluate();
        try {
            RepositoryConnectionTest.assertTrue((tupleQueryResult != null ? 1 : 0) != 0);
            RepositoryConnectionTest.assertTrue((boolean)tupleQueryResult.hasNext());
            while (tupleQueryResult.hasNext()) {
                BindingSet bindingSet = (BindingSet)tupleQueryResult.next();
                RepositoryConnectionTest.assertTrue((boolean)bindingSet.hasBinding("name"));
                RepositoryConnectionTest.assertTrue((boolean)bindingSet.hasBinding("mbox"));
                Value value = bindingSet.getValue("name");
                Value value2 = bindingSet.getValue("mbox");
                RepositoryConnectionTest.assertTrue((this.nameAlice.equals(value) || this.nameBob.equals(value) ? 1 : 0) != 0);
                RepositoryConnectionTest.assertTrue((this.mboxAlice.equals(value2) || this.mboxBob.equals(value2) ? 1 : 0) != 0);
            }
        }
        finally {
            tupleQueryResult.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleTupleQueryUnicode() throws Exception {
        this.testCon.add((Resource)this.alexander, this.name, (Value)this.strangeUnicodeVarname, new Resource[0]);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" SELECT person");
        stringBuilder.append(" FROM {person} foaf:name {").append(this.strangeUnicodeVarname.getLabel()).append("}");
        stringBuilder.append(" USING NAMESPACE foaf = <http://xmlns.com/foaf/0.1/>");
        TupleQueryResult tupleQueryResult = this.testCon.prepareTupleQuery(QueryLanguage.SERQL, stringBuilder.toString()).evaluate();
        try {
            RepositoryConnectionTest.assertTrue((tupleQueryResult != null ? 1 : 0) != 0);
            RepositoryConnectionTest.assertTrue((boolean)tupleQueryResult.hasNext());
            while (tupleQueryResult.hasNext()) {
                BindingSet bindingSet = (BindingSet)tupleQueryResult.next();
                RepositoryConnectionTest.assertTrue((boolean)bindingSet.hasBinding("person"));
                RepositoryConnectionTest.assertEquals((Object)this.alexander, (Object)bindingSet.getValue("person"));
            }
        }
        finally {
            tupleQueryResult.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPreparedTupleQuery() throws Exception {
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" SELECT name, mbox");
        stringBuilder.append(" FROM {} foaf:name {name};");
        stringBuilder.append("         foaf:mbox {mbox}");
        stringBuilder.append(" USING NAMESPACE foaf = <http://xmlns.com/foaf/0.1/>");
        TupleQuery tupleQuery = this.testCon.prepareTupleQuery(QueryLanguage.SERQL, stringBuilder.toString());
        tupleQuery.setBinding("name", (Value)this.nameBob);
        TupleQueryResult tupleQueryResult = tupleQuery.evaluate();
        try {
            RepositoryConnectionTest.assertTrue((tupleQueryResult != null ? 1 : 0) != 0);
            RepositoryConnectionTest.assertTrue((boolean)tupleQueryResult.hasNext());
            while (tupleQueryResult.hasNext()) {
                BindingSet bindingSet = (BindingSet)tupleQueryResult.next();
                RepositoryConnectionTest.assertTrue((boolean)bindingSet.hasBinding("name"));
                RepositoryConnectionTest.assertTrue((boolean)bindingSet.hasBinding("mbox"));
                Value value = bindingSet.getValue("name");
                Value value2 = bindingSet.getValue("mbox");
                RepositoryConnectionTest.assertEquals((String)("unexpected value for name: " + value), (Object)this.nameBob, (Object)value);
                RepositoryConnectionTest.assertEquals((String)("unexpected value for mbox: " + value2), (Object)this.mboxBob, (Object)value2);
            }
        }
        finally {
            tupleQueryResult.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPreparedTupleQueryUnicode() throws Exception {
        this.testCon.add((Resource)this.alexander, this.name, (Value)this.strangeUnicodeVarname, new Resource[0]);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" SELECT person");
        stringBuilder.append(" FROM {person} foaf:name {name}");
        stringBuilder.append(" USING NAMESPACE foaf = <http://xmlns.com/foaf/0.1/>");
        TupleQuery tupleQuery = this.testCon.prepareTupleQuery(QueryLanguage.SERQL, stringBuilder.toString());
        tupleQuery.setBinding("name", (Value)this.strangeUnicodeVarname);
        TupleQueryResult tupleQueryResult = tupleQuery.evaluate();
        try {
            RepositoryConnectionTest.assertTrue((tupleQueryResult != null ? 1 : 0) != 0);
            RepositoryConnectionTest.assertTrue((boolean)tupleQueryResult.hasNext());
            while (tupleQueryResult.hasNext()) {
                BindingSet bindingSet = (BindingSet)tupleQueryResult.next();
                RepositoryConnectionTest.assertTrue((boolean)bindingSet.hasBinding("person"));
                RepositoryConnectionTest.assertEquals((Object)this.alexander, (Object)bindingSet.getValue("person"));
            }
        }
        finally {
            tupleQueryResult.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleGraphQuery() throws Exception {
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" CONSTRUCT *");
        stringBuilder.append(" FROM {} foaf:name {name};");
        stringBuilder.append("         foaf:mbox {mbox}");
        stringBuilder.append(" USING NAMESPACE foaf = <http://xmlns.com/foaf/0.1/>");
        GraphQueryResult graphQueryResult = this.testCon.prepareGraphQuery(QueryLanguage.SERQL, stringBuilder.toString()).evaluate();
        try {
            RepositoryConnectionTest.assertTrue((graphQueryResult != null ? 1 : 0) != 0);
            RepositoryConnectionTest.assertTrue((boolean)graphQueryResult.hasNext());
            while (graphQueryResult.hasNext()) {
                Statement statement = (Statement)graphQueryResult.next();
                if (this.name.equals(statement.getPredicate())) {
                    RepositoryConnectionTest.assertTrue((this.nameAlice.equals(statement.getObject()) || this.nameBob.equals(statement.getObject()) ? 1 : 0) != 0);
                    continue;
                }
                RepositoryConnectionTest.assertTrue((boolean)this.mbox.equals(statement.getPredicate()));
                RepositoryConnectionTest.assertTrue((this.mboxAlice.equals(statement.getObject()) || this.mboxBob.equals(statement.getObject()) ? 1 : 0) != 0);
            }
        }
        finally {
            graphQueryResult.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPreparedGraphQuery() throws Exception {
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" CONSTRUCT *");
        stringBuilder.append(" FROM {} foaf:name {name};");
        stringBuilder.append("         foaf:mbox {mbox}");
        stringBuilder.append(" USING NAMESPACE foaf = <http://xmlns.com/foaf/0.1/>");
        GraphQuery graphQuery = this.testCon.prepareGraphQuery(QueryLanguage.SERQL, stringBuilder.toString());
        graphQuery.setBinding("name", (Value)this.nameBob);
        GraphQueryResult graphQueryResult = graphQuery.evaluate();
        try {
            RepositoryConnectionTest.assertTrue((graphQueryResult != null ? 1 : 0) != 0);
            RepositoryConnectionTest.assertTrue((boolean)graphQueryResult.hasNext());
            while (graphQueryResult.hasNext()) {
                Statement statement = (Statement)graphQueryResult.next();
                RepositoryConnectionTest.assertTrue((this.name.equals(statement.getPredicate()) || this.mbox.equals(statement.getPredicate()) ? 1 : 0) != 0);
                if (this.name.equals(statement.getPredicate())) {
                    RepositoryConnectionTest.assertTrue((String)("unexpected value for name: " + statement.getObject()), (boolean)this.nameBob.equals(statement.getObject()));
                    continue;
                }
                RepositoryConnectionTest.assertTrue((boolean)this.mbox.equals(statement.getPredicate()));
                RepositoryConnectionTest.assertTrue((String)("unexpected value for mbox: " + statement.getObject()), (boolean)this.mboxBob.equals(statement.getObject()));
            }
        }
        finally {
            graphQueryResult.close();
        }
    }

    public void testSimpleBooleanQuery() throws Exception {
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/> ");
        stringBuilder.append("ASK ");
        stringBuilder.append("{ ?p foaf:name ?name }");
        boolean bl = this.testCon.prepareBooleanQuery(QueryLanguage.SPARQL, stringBuilder.toString()).evaluate();
        RepositoryConnectionTest.assertTrue((boolean)bl);
    }

    public void testPreparedBooleanQuery() throws Exception {
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/> ");
        stringBuilder.append("ASK ");
        stringBuilder.append("{ ?p foaf:name ?name }");
        BooleanQuery booleanQuery = this.testCon.prepareBooleanQuery(QueryLanguage.SPARQL, stringBuilder.toString());
        booleanQuery.setBinding("name", (Value)this.nameBob);
        RepositoryConnectionTest.assertTrue((boolean)booleanQuery.evaluate());
    }

    public void testDataset() throws Exception {
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/> ");
        stringBuilder.append("ASK ");
        stringBuilder.append("{ ?p foaf:name ?name }");
        BooleanQuery booleanQuery = this.testCon.prepareBooleanQuery(QueryLanguage.SPARQL, stringBuilder.toString());
        booleanQuery.setBinding("name", (Value)this.nameBob);
        RepositoryConnectionTest.assertTrue((boolean)booleanQuery.evaluate());
        DatasetImpl datasetImpl = new DatasetImpl();
        datasetImpl.addDefaultGraph(this.context1);
        booleanQuery.setDataset((Dataset)datasetImpl);
        RepositoryConnectionTest.assertTrue((boolean)booleanQuery.evaluate());
        datasetImpl.addDefaultGraph(this.context2);
        booleanQuery.setDataset((Dataset)datasetImpl);
        RepositoryConnectionTest.assertTrue((boolean)booleanQuery.evaluate());
        datasetImpl.removeDefaultGraph(this.context1);
        booleanQuery.setDataset((Dataset)datasetImpl);
        RepositoryConnectionTest.assertFalse((boolean)booleanQuery.evaluate());
        stringBuilder.setLength(0);
        stringBuilder.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/> ");
        stringBuilder.append("ASK ");
        stringBuilder.append("{ GRAPH ?g { ?p foaf:name ?name } }");
        booleanQuery = this.testCon.prepareBooleanQuery(QueryLanguage.SPARQL, stringBuilder.toString());
        booleanQuery.setBinding("name", (Value)this.nameBob);
        booleanQuery.setDataset((Dataset)datasetImpl);
        RepositoryConnectionTest.assertFalse((boolean)booleanQuery.evaluate());
        datasetImpl.addDefaultGraph(this.context1);
        datasetImpl.addNamedGraph(this.context2);
        booleanQuery.setDataset((Dataset)datasetImpl);
        RepositoryConnectionTest.assertFalse((boolean)booleanQuery.evaluate());
        datasetImpl.addNamedGraph(this.context1);
        booleanQuery.setDataset((Dataset)datasetImpl);
        RepositoryConnectionTest.assertTrue((boolean)booleanQuery.evaluate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetStatements() throws Exception {
        Object object;
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        RepositoryConnectionTest.assertTrue((String)"Repository should contain statement", (boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
        RepositoryResult repositoryResult = this.testCon.getStatements(null, this.name, null, false, new Resource[0]);
        try {
            RepositoryConnectionTest.assertTrue((String)"Iterator should not be null", (repositoryResult != null ? 1 : 0) != 0);
            RepositoryConnectionTest.assertTrue((String)"Iterator should not be empty", (boolean)repositoryResult.hasNext());
            while (repositoryResult.hasNext()) {
                object = (Statement)repositoryResult.next();
                RepositoryConnectionTest.assertNull((String)"Statement should not be in a context ", (Object)object.getContext());
                RepositoryConnectionTest.assertTrue((String)"Statement predicate should be equal to name ", (boolean)object.getPredicate().equals(this.name));
            }
        }
        finally {
            repositoryResult.close();
        }
        object = (List)Iterations.addAll((Iteration)this.testCon.getStatements(null, this.name, null, false, new Resource[0]), new ArrayList());
        RepositoryConnectionTest.assertTrue((String)"List should not be null", (object != null ? 1 : 0) != 0);
        RepositoryConnectionTest.assertFalse((String)"List should not be empty", (boolean)object.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetStatementsInSingleContext() throws Exception {
        Object object;
        this.testCon.setAutoCommit(false);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.setAutoCommit(true);
        RepositoryConnectionTest.assertTrue((String)"Repository should contain statement", (boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
        RepositoryConnectionTest.assertTrue((String)"Repository should contain statement in context1", (boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[]{this.context1}));
        RepositoryConnectionTest.assertFalse((String)"Repository should not contain statement in context2", (boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[]{this.context2}));
        RepositoryResult repositoryResult = this.testCon.getStatements((Resource)this.bob, this.name, null, false, new Resource[0]);
        try {
            while (repositoryResult.hasNext()) {
                object = (Statement)repositoryResult.next();
                RepositoryConnectionTest.assertTrue((boolean)this.bob.equals(object.getSubject()));
                RepositoryConnectionTest.assertTrue((boolean)this.name.equals(object.getPredicate()));
                RepositoryConnectionTest.assertTrue((boolean)this.nameBob.equals(object.getObject()));
                RepositoryConnectionTest.assertTrue((boolean)this.context1.equals(object.getContext()));
            }
        }
        finally {
            repositoryResult.close();
        }
        repositoryResult = this.testCon.getStatements(null, null, null, false, new Resource[]{this.context1});
        try {
            while (repositoryResult.hasNext()) {
                object = (Statement)repositoryResult.next();
                RepositoryConnectionTest.assertTrue((boolean)this.context1.equals(object.getContext()));
            }
        }
        finally {
            repositoryResult.close();
        }
        repositoryResult = this.testCon.getStatements(null, null, null, false, new Resource[]{this.unknownContext});
        try {
            RepositoryConnectionTest.assertTrue((repositoryResult != null ? 1 : 0) != 0);
            RepositoryConnectionTest.assertFalse((boolean)repositoryResult.hasNext());
        }
        finally {
            repositoryResult.close();
        }
        object = (List)Iterations.addAll((Iteration)this.testCon.getStatements(null, this.name, null, false, new Resource[]{this.context1}), new ArrayList());
        RepositoryConnectionTest.assertTrue((String)"List should not be null", (object != null ? 1 : 0) != 0);
        RepositoryConnectionTest.assertFalse((String)"List should not be empty", (boolean)object.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetStatementsInMultipleContexts() throws Exception {
        Statement statement;
        int n;
        this.testCon.clear(new Resource[0]);
        this.testCon.setAutoCommit(false);
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.setAutoCommit(true);
        RepositoryResult repositoryResult = this.testCon.getStatements(null, null, null, false, new Resource[]{null, this.context2});
        try {
            n = 0;
            while (repositoryResult.hasNext()) {
                ++n;
                statement = (Statement)repositoryResult.next();
                RepositoryConnectionTest.assertTrue((statement.getContext() == null || this.context2.equals(statement.getContext()) ? 1 : 0) != 0);
            }
            RepositoryConnectionTest.assertEquals((String)"there should be three statements", (int)3, (int)n);
        }
        finally {
            repositoryResult.close();
        }
        repositoryResult = this.testCon.getStatements(null, null, null, false, new Resource[]{this.context1, this.context2});
        try {
            n = 0;
            while (repositoryResult.hasNext()) {
                ++n;
                statement = (Statement)repositoryResult.next();
                RepositoryConnectionTest.assertTrue((boolean)this.context2.equals(statement.getContext()));
            }
            RepositoryConnectionTest.assertEquals((String)"there should be two statements", (int)2, (int)n);
        }
        finally {
            repositoryResult.close();
        }
        repositoryResult = this.testCon.getStatements(null, null, null, false, new Resource[]{this.unknownContext, this.context2});
        try {
            n = 0;
            while (repositoryResult.hasNext()) {
                ++n;
                statement = (Statement)repositoryResult.next();
                RepositoryConnectionTest.assertTrue((boolean)this.context2.equals(statement.getContext()));
            }
            RepositoryConnectionTest.assertEquals((String)"there should be two statements", (int)2, (int)n);
        }
        finally {
            repositoryResult.close();
        }
        this.testCon.setAutoCommit(false);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        this.testCon.setAutoCommit(true);
        repositoryResult = this.testCon.getStatements(null, null, null, false, new Resource[]{this.context1});
        try {
            RepositoryConnectionTest.assertTrue((repositoryResult != null ? 1 : 0) != 0);
            RepositoryConnectionTest.assertTrue((boolean)repositoryResult.hasNext());
        }
        finally {
            repositoryResult.close();
        }
        repositoryResult = this.testCon.getStatements(null, null, null, false, new Resource[]{null, this.context2});
        try {
            n = 0;
            while (repositoryResult.hasNext()) {
                ++n;
                statement = (Statement)repositoryResult.next();
                RepositoryConnectionTest.assertTrue((statement.getContext() == null || this.context2.equals(statement.getContext()) ? 1 : 0) != 0);
            }
            RepositoryConnectionTest.assertEquals((String)"there should be four statements", (int)4, (int)n);
        }
        finally {
            repositoryResult.close();
        }
        repositoryResult = this.testCon.getStatements(null, null, null, false, new Resource[]{this.context1, this.context2});
        try {
            n = 0;
            while (repositoryResult.hasNext()) {
                ++n;
                statement = (Statement)repositoryResult.next();
                RepositoryConnectionTest.assertTrue((this.context1.equals(statement.getContext()) || this.context2.equals(statement.getContext()) ? 1 : 0) != 0);
            }
            RepositoryConnectionTest.assertEquals((String)"there should be four statements", (int)4, (int)n);
        }
        finally {
            repositoryResult.close();
        }
    }

    public void testDuplicateFilter() throws Exception {
        this.testCon.setAutoCommit(false);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context2});
        this.testCon.setAutoCommit(true);
        RepositoryResult repositoryResult = this.testCon.getStatements((Resource)this.bob, this.name, null, true, new Resource[0]);
        repositoryResult.enableDuplicateFilter();
        int n = 0;
        while (repositoryResult.hasNext()) {
            repositoryResult.next();
            ++n;
        }
        RepositoryConnectionTest.assertEquals((int)1, (int)n);
    }

    public void testRemoveStatements() throws Exception {
        this.testCon.setAutoCommit(false);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[0]);
        this.testCon.setAutoCommit(true);
        RepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
        RepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
        this.testCon.remove((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        RepositoryConnectionTest.assertFalse((boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
        RepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
        this.testCon.remove((Resource)this.alice, null, null, new Resource[0]);
        RepositoryConnectionTest.assertFalse((boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
        RepositoryConnectionTest.assertTrue((boolean)this.testCon.isEmpty());
    }

    public void testRemoveStatementCollection() throws Exception {
        this.testCon.setAutoCommit(false);
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        this.testCon.setAutoCommit(true);
        RepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
        RepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
        Collection collection = Iterations.addAll((Iteration)this.testCon.getStatements(null, null, null, false, new Resource[0]), new ArrayList());
        this.testCon.remove((Iterable)collection, new Resource[0]);
        RepositoryConnectionTest.assertFalse((boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
        RepositoryConnectionTest.assertFalse((boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveStatementIteration() throws Exception {
        this.testCon.setAutoCommit(false);
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        this.testCon.setAutoCommit(true);
        RepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
        RepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
        RepositoryResult repositoryResult = this.testCon.getStatements(null, null, null, false, new Resource[0]);
        try {
            this.testCon.remove((Iteration)repositoryResult, new Resource[0]);
        }
        finally {
            repositoryResult.close();
        }
        RepositoryConnectionTest.assertFalse((boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
        RepositoryConnectionTest.assertFalse((boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetNamespaces() throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<rdf:RDF\n");
        stringBuilder.append("    xmlns:example='http://example.org/'\n");
        stringBuilder.append("    xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'\n");
        stringBuilder.append("    xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#' >\n");
        stringBuilder.append("  <rdf:Description rdf:about='http://example.org/Main'>\n");
        stringBuilder.append("    <rdfs:label>Main Node</rdfs:label>\n");
        stringBuilder.append("  </rdf:Description>\n");
        stringBuilder.append("</rdf:RDF>");
        this.testCon.add((Reader)new StringReader(stringBuilder.toString()), "", RDFFormat.RDFXML, new Resource[0]);
        RepositoryResult repositoryResult = this.testCon.getNamespaces();
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            int n = 0;
            while (repositoryResult.hasNext()) {
                ++n;
                Namespace namespace = (Namespace)repositoryResult.next();
                hashMap.put(namespace.getPrefix(), namespace.getName());
            }
            RepositoryConnectionTest.assertEquals((String)"There should be exactly three namespaces", (int)3, (int)n);
            RepositoryConnectionTest.assertTrue((String)"namespace for prefix 'example' should exist", (boolean)hashMap.containsKey("example"));
            RepositoryConnectionTest.assertTrue((String)"namespace for prefix 'rdfs' should exist", (boolean)hashMap.containsKey("rdfs"));
            RepositoryConnectionTest.assertTrue((String)"namespace for prefix 'rdf' should exist", (boolean)hashMap.containsKey("rdf"));
            RepositoryConnectionTest.assertTrue((String)"namespace name for 'example' not well-defined", (boolean)((String)hashMap.get("example")).equals("http://example.org/"));
            RepositoryConnectionTest.assertTrue((String)"namespace name for 'rdfs' not well-defined", (boolean)((String)hashMap.get("rdfs")).equals("http://www.w3.org/2000/01/rdf-schema#"));
            RepositoryConnectionTest.assertTrue((String)"namespace name for 'rdf' not well-defined", (boolean)((String)hashMap.get("rdf")).equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
        }
        finally {
            repositoryResult.close();
        }
    }

    public void testClear() throws Exception {
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        RepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[0]));
        this.testCon.clear(new Resource[0]);
        RepositoryConnectionTest.assertFalse((boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[0]));
    }

    public void testRecoverFromParseError() throws RepositoryException, IOException {
        String string = "bad";
        String string2 = "@prefix foo: <http://example.org/foo#>.\nfoo:a foo:b foo:c.";
        try {
            this.testCon.add((Reader)new StringReader(string), "", RDFFormat.TURTLE, new Resource[0]);
            RepositoryConnectionTest.fail((String)"Invalid data should result in an exception");
        }
        catch (RDFParseException rDFParseException) {
            // empty catch block
        }
        try {
            this.testCon.add((Reader)new StringReader(string2), "", RDFFormat.TURTLE, new Resource[0]);
        }
        catch (RDFParseException rDFParseException) {
            RepositoryConnectionTest.fail((String)"Valid data should not result in an exception");
        }
        RepositoryConnectionTest.assertEquals((String)"Repository contains incorrect number of statements", (long)1L, (long)this.testCon.size(new Resource[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStatementSerialization() throws Exception {
        Statement statement;
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        RepositoryResult repositoryResult = this.testCon.getStatements(null, null, null, true, new Resource[0]);
        try {
            statement = (Statement)repositoryResult.next();
        }
        finally {
            repositoryResult.close();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(statement);
        objectOutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Statement statement2 = (Statement)objectInputStream.readObject();
        objectInputStream.close();
        RepositoryConnectionTest.assertTrue((boolean)statement.equals(statement2));
        RepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement(statement, true, new Resource[0]));
        RepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement(statement2, true, new Resource[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBNodeSerialization() throws Exception {
        Statement statement;
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        RepositoryResult repositoryResult = this.testCon.getStatements(null, null, null, false, new Resource[0]);
        try {
            statement = (Statement)repositoryResult.next();
        }
        finally {
            repositoryResult.close();
        }
        BNode bNode = (BNode)statement.getSubject();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(bNode);
        objectOutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        BNode bNode2 = (BNode)objectInputStream.readObject();
        objectInputStream.close();
        RepositoryConnectionTest.assertTrue((boolean)bNode.equals(bNode2));
        RepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)bNode, this.name, (Value)this.nameBob, true, new Resource[0]));
        RepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)bNode2, this.name, (Value)this.nameBob, true, new Resource[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testURISerialization() throws Exception {
        Statement statement;
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        RepositoryResult repositoryResult = this.testCon.getStatements(null, null, null, false, new Resource[0]);
        try {
            statement = (Statement)repositoryResult.next();
        }
        finally {
            repositoryResult.close();
        }
        URI uRI = statement.getPredicate();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(uRI);
        objectOutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        URI uRI2 = (URI)objectInputStream.readObject();
        objectInputStream.close();
        RepositoryConnectionTest.assertTrue((boolean)uRI.equals(uRI2));
        RepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)this.bob, uRI, (Value)this.nameBob, true, new Resource[0]));
        RepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)this.bob, uRI2, (Value)this.nameBob, true, new Resource[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLiteralSerialization() throws Exception {
        Statement statement;
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        RepositoryResult repositoryResult = this.testCon.getStatements(null, null, null, false, new Resource[0]);
        try {
            statement = (Statement)repositoryResult.next();
        }
        finally {
            repositoryResult.close();
        }
        Literal literal = (Literal)statement.getObject();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(literal);
        objectOutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Literal literal2 = (Literal)objectInputStream.readObject();
        objectInputStream.close();
        RepositoryConnectionTest.assertTrue((boolean)literal.equals(literal2));
        RepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)literal, true, new Resource[0]));
        RepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)literal2, true, new Resource[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGraphSerialization() throws Exception {
        GraphImpl graphImpl;
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[0]);
        RepositoryResult repositoryResult = this.testCon.getStatements(null, null, null, true, new Resource[0]);
        try {
            graphImpl = new GraphImpl(this.vf, (Collection)repositoryResult.asList());
        }
        finally {
            repositoryResult.close();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(graphImpl);
        objectOutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Graph graph = (Graph)objectInputStream.readObject();
        objectInputStream.close();
        RepositoryConnectionTest.assertFalse((boolean)graph.isEmpty());
        for (Statement statement : graph) {
            RepositoryConnectionTest.assertTrue((boolean)graphImpl.contains((Object)statement));
            RepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement(statement, true, new Resource[0]));
        }
    }

    public void testEmptyRollback() throws Exception {
        RepositoryConnectionTest.assertTrue((boolean)this.testCon.isEmpty());
        RepositoryConnectionTest.assertTrue((boolean)this.testCon2.isEmpty());
        this.testCon.setAutoCommit(false);
        this.testCon.add((Resource)this.vf.createBNode(), this.vf.createURI("urn:pred"), (Value)this.vf.createBNode(), new Resource[0]);
        RepositoryConnectionTest.assertFalse((boolean)this.testCon.isEmpty());
        RepositoryConnectionTest.assertTrue((boolean)this.testCon2.isEmpty());
        this.testCon.rollback();
        RepositoryConnectionTest.assertTrue((boolean)this.testCon.isEmpty());
        RepositoryConnectionTest.assertTrue((boolean)this.testCon2.isEmpty());
    }

    public void testEmptyCommit() throws Exception {
        RepositoryConnectionTest.assertTrue((boolean)this.testCon.isEmpty());
        RepositoryConnectionTest.assertTrue((boolean)this.testCon2.isEmpty());
        this.testCon.setAutoCommit(false);
        this.testCon.add((Resource)this.vf.createBNode(), this.vf.createURI("urn:pred"), (Value)this.vf.createBNode(), new Resource[0]);
        RepositoryConnectionTest.assertFalse((boolean)this.testCon.isEmpty());
        RepositoryConnectionTest.assertTrue((boolean)this.testCon2.isEmpty());
        this.testCon.commit();
        RepositoryConnectionTest.assertFalse((boolean)this.testCon.isEmpty());
        RepositoryConnectionTest.assertFalse((boolean)this.testCon2.isEmpty());
    }

    public void testOpen() throws Exception {
        RepositoryConnectionTest.assertTrue((boolean)this.testCon.isOpen());
        RepositoryConnectionTest.assertTrue((boolean)this.testCon2.isOpen());
        this.testCon.close();
        RepositoryConnectionTest.assertFalse((boolean)this.testCon.isOpen());
        RepositoryConnectionTest.assertTrue((boolean)this.testCon2.isOpen());
    }

    public void testSizeRollback() throws Exception {
        RepositoryConnectionTest.assertEquals((long)0L, (long)this.testCon.size(new Resource[0]));
        RepositoryConnectionTest.assertEquals((long)0L, (long)this.testCon2.size(new Resource[0]));
        this.testCon.setAutoCommit(false);
        this.testCon.add((Resource)this.vf.createBNode(), this.vf.createURI("urn:pred"), (Value)this.vf.createBNode(), new Resource[0]);
        RepositoryConnectionTest.assertEquals((long)1L, (long)this.testCon.size(new Resource[0]));
        RepositoryConnectionTest.assertEquals((long)0L, (long)this.testCon2.size(new Resource[0]));
        this.testCon.add((Resource)this.vf.createBNode(), this.vf.createURI("urn:pred"), (Value)this.vf.createBNode(), new Resource[0]);
        RepositoryConnectionTest.assertEquals((long)2L, (long)this.testCon.size(new Resource[0]));
        RepositoryConnectionTest.assertEquals((long)0L, (long)this.testCon2.size(new Resource[0]));
        this.testCon.rollback();
        RepositoryConnectionTest.assertEquals((long)0L, (long)this.testCon.size(new Resource[0]));
        RepositoryConnectionTest.assertEquals((long)0L, (long)this.testCon2.size(new Resource[0]));
    }

    public void testSizeCommit() throws Exception {
        RepositoryConnectionTest.assertEquals((long)0L, (long)this.testCon.size(new Resource[0]));
        RepositoryConnectionTest.assertEquals((long)0L, (long)this.testCon2.size(new Resource[0]));
        this.testCon.setAutoCommit(false);
        this.testCon.add((Resource)this.vf.createBNode(), this.vf.createURI("urn:pred"), (Value)this.vf.createBNode(), new Resource[0]);
        RepositoryConnectionTest.assertEquals((long)1L, (long)this.testCon.size(new Resource[0]));
        RepositoryConnectionTest.assertEquals((long)0L, (long)this.testCon2.size(new Resource[0]));
        this.testCon.add((Resource)this.vf.createBNode(), this.vf.createURI("urn:pred"), (Value)this.vf.createBNode(), new Resource[0]);
        RepositoryConnectionTest.assertEquals((long)2L, (long)this.testCon.size(new Resource[0]));
        RepositoryConnectionTest.assertEquals((long)0L, (long)this.testCon2.size(new Resource[0]));
        this.testCon.commit();
        RepositoryConnectionTest.assertEquals((long)2L, (long)this.testCon.size(new Resource[0]));
        RepositoryConnectionTest.assertEquals((long)2L, (long)this.testCon2.size(new Resource[0]));
    }

    public void testAddRemove() throws Exception {
        URI uRI = this.vf.createURI("http://xmlns.com/foaf/0.1/Person");
        final Statement statement = this.vf.createStatement((Resource)this.bob, this.name, (Value)this.nameBob);
        this.testCon.add((Resource)this.bob, RDF.TYPE, (Value)uRI, new Resource[0]);
        this.testCon.setAutoCommit(false);
        this.testCon.add(statement, new Resource[0]);
        this.testCon.remove(statement, new Resource[0]);
        this.testCon.commit();
        this.testCon.exportStatements(null, null, null, false, (RDFHandler)new RDFHandlerBase(){

            public void handleStatement(Statement statement2) throws RDFHandlerException {
                Assert.assertTrue((!statement.equals(statement2) ? 1 : 0) != 0);
            }
        }, new Resource[0]);
    }

    public void testInferredStatementCount() throws Exception {
        RepositoryConnectionTest.assertTrue((boolean)this.testCon.isEmpty());
        int n = this.getTotalStatementCount(this.testCon);
        URI uRI = this.vf.createURI("urn:root");
        this.testCon.add((Resource)uRI, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
        this.testCon.remove((Resource)uRI, RDF.TYPE, (Value)RDF.LIST, new Resource[0]);
        RepositoryConnectionTest.assertTrue((boolean)this.testCon.isEmpty());
        RepositoryConnectionTest.assertEquals((int)n, (int)this.getTotalStatementCount(this.testCon));
    }

    public void testGetContextIDs() throws Exception {
        RepositoryConnectionTest.assertEquals((int)0, (int)this.testCon.getContextIDs().asList().size());
        this.testCon.setAutoCommit(false);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        RepositoryConnectionTest.assertEquals(Arrays.asList(this.context1), (Object)this.testCon.getContextIDs().asList());
        this.testCon.remove((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        RepositoryConnectionTest.assertEquals((int)0, (int)this.testCon.getContextIDs().asList().size());
        this.testCon.setAutoCommit(true);
        RepositoryConnectionTest.assertEquals((int)0, (int)this.testCon.getContextIDs().asList().size());
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context2});
        RepositoryConnectionTest.assertEquals(Arrays.asList(this.context2), (Object)this.testCon.getContextIDs().asList());
    }

    public void testXmlCalendarZ() throws Exception {
        URI uRI;
        XMLGregorianCalendar xMLGregorianCalendar;
        URI uRI2;
        String string = "http://example.org/rdf/";
        int n = TimeZone.getDefault().getOffset(new Date(2007, 10, 6).getTime()) / 1000 / 60;
        String string2 = "SELECT ?s ?d WHERE { ?s <http://www.w3.org/1999/02/22-rdf-syntax-ns#value> ?d . FILTER (?d <= ?date) }";
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        for (int i = 1; i < 5; ++i) {
            uRI2 = this.vf.createURI(string, "date" + i);
            xMLGregorianCalendar = datatypeFactory.newXMLGregorianCalendar();
            xMLGregorianCalendar.setYear(2000);
            xMLGregorianCalendar.setMonth(11);
            xMLGregorianCalendar.setDay(i * 2);
            this.testCon.add((Resource)uRI2, RDF.VALUE, (Value)this.vf.createLiteral(xMLGregorianCalendar), new Resource[0]);
            uRI = this.vf.createURI(string, "dateZ" + i);
            xMLGregorianCalendar = datatypeFactory.newXMLGregorianCalendar();
            xMLGregorianCalendar.setYear(2007);
            xMLGregorianCalendar.setMonth(11);
            xMLGregorianCalendar.setDay(i * 2);
            xMLGregorianCalendar.setTimezone(n);
            this.testCon.add((Resource)uRI, RDF.VALUE, (Value)this.vf.createLiteral(xMLGregorianCalendar), new Resource[0]);
        }
        XMLGregorianCalendar xMLGregorianCalendar2 = datatypeFactory.newXMLGregorianCalendar();
        xMLGregorianCalendar2.setYear(2007);
        xMLGregorianCalendar2.setMonth(11);
        xMLGregorianCalendar2.setDay(6);
        xMLGregorianCalendar2.setTimezone(n);
        uRI2 = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, string2);
        uRI2.setBinding("date", (Value)this.vf.createLiteral(xMLGregorianCalendar2));
        xMLGregorianCalendar = uRI2.evaluate();
        uRI = new ArrayList();
        while (xMLGregorianCalendar.hasNext()) {
            uRI.add(xMLGregorianCalendar.next());
        }
        RepositoryConnectionTest.assertEquals((int)7, (int)uRI.size());
    }

    public void testOptionalFilter() throws Exception {
        String string = "{ ?s :p1 ?v1 OPTIONAL {?s :p2 ?v2 FILTER(?v1<3) } }";
        URI uRI = this.vf.createURI("urn:test:s");
        URI uRI2 = this.vf.createURI("urn:test:p1");
        URI uRI3 = this.vf.createURI("urn:test:p2");
        Literal literal = this.vf.createLiteral(1);
        Literal literal2 = this.vf.createLiteral(2);
        Literal literal3 = this.vf.createLiteral(3);
        this.testCon.add((Resource)uRI, uRI2, (Value)literal, new Resource[0]);
        this.testCon.add((Resource)uRI, uRI3, (Value)literal2, new Resource[0]);
        this.testCon.add((Resource)uRI, uRI2, (Value)literal3, new Resource[0]);
        String string2 = "PREFIX :<urn:test:> SELECT ?s ?v1 ?v2 WHERE " + string;
        TupleQuery tupleQuery = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, string2);
        TupleQueryResult tupleQueryResult = tupleQuery.evaluate();
        HashSet<List<Value>> hashSet = new HashSet<List<Value>>();
        while (tupleQueryResult.hasNext()) {
            BindingSet bindingSet = (BindingSet)tupleQueryResult.next();
            hashSet.add(Arrays.asList(bindingSet.getValue("v1"), bindingSet.getValue("v2")));
        }
        tupleQueryResult.close();
        RepositoryConnectionTest.assertTrue((boolean)hashSet.contains(Arrays.asList(literal, literal2)));
        RepositoryConnectionTest.assertTrue((boolean)hashSet.contains(Arrays.asList(literal3, null)));
    }

    public void testOrPredicate() throws Exception {
        String string = "{ :s ?p :o FILTER (?p = :p1 || ?p = :p2) }";
        URI uRI = this.vf.createURI("urn:test:s");
        URI uRI2 = this.vf.createURI("urn:test:p1");
        URI uRI3 = this.vf.createURI("urn:test:p2");
        URI uRI4 = this.vf.createURI("urn:test:o");
        this.testCon.add((Resource)uRI, uRI2, (Value)uRI4, new Resource[0]);
        this.testCon.add((Resource)uRI, uRI3, (Value)uRI4, new Resource[0]);
        String string2 = "PREFIX :<urn:test:> SELECT ?p WHERE " + string;
        TupleQuery tupleQuery = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, string2);
        TupleQueryResult tupleQueryResult = tupleQuery.evaluate();
        ArrayList<Value> arrayList = new ArrayList<Value>();
        while (tupleQueryResult.hasNext()) {
            BindingSet bindingSet = (BindingSet)tupleQueryResult.next();
            arrayList.add(bindingSet.getValue("p"));
        }
        tupleQueryResult.close();
        RepositoryConnectionTest.assertTrue((boolean)arrayList.contains(uRI2));
        RepositoryConnectionTest.assertTrue((boolean)arrayList.contains(uRI3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTotalStatementCount(RepositoryConnection repositoryConnection) throws RepositoryException {
        RepositoryResult repositoryResult = repositoryConnection.getStatements(null, null, null, true, new Resource[0]);
        try {
            int n = 0;
            while (repositoryResult.hasNext()) {
                repositoryResult.next();
                ++n;
            }
            int n2 = n;
            return n2;
        }
        finally {
            repositoryResult.close();
        }
    }
}

