package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGCloseTripleStore {

	/**
	 * Demonstrates basics of closing a triple store
	 * 
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		
		// Connect to the server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem.", e);
		}

		// Create a fresh triple store.
		AllegroGraph ts = ags.renew("newstore", AGPaths.TRIPLE_STORES);
		System.out.println("New triple store opened with " + ts.numberOfTriples() + " triples.");

		// Close the triple store
		System.out.println("Closing the triple store.");
		ts.closeTripleStore();

		// It's an error to access a closed triple store
		System.out.println("Attempting to get the closed store's triple count.");
		try {
			ts.numberOfTriples();
		} catch (IllegalStateException e) {
			System.out.println("Expected Error: " + e.getMessage());
		}
		
		// Disconnect from the server
		System.out.println("Disconnecting from the server.");
		ags.disable();
		System.out.println("Done.");
		
	}
	
}
