package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGISWCASWC2007 {

	/**
	 * Demonstrates loading and querying of the ISWC+ASWC 2007 RDF data set.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple store
		AllegroGraph ts = ags.renew("iwscawsc2007", AGPaths.TRIPLE_STORES);

		// Load the data
		AGLoadRDF.loadRDFWithTiming(ts,AGPaths.dataSources("iswc-aswc-2007-complete.rdf"));
		
		// Index the triple store for faster querying
		AGIndexAllTriples.indexAllTriplesWithTiming(ts);

		// Query the data set for a summary of the business intelligence
		// tutorial being taught by Jans Aasman
		String query =
		"PREFIX tutorial: <http://data.semanticweb.org/conference/iswc-aswc/2007/tutorial/> " +
	    "PREFIX ical: <http://www.w3.org/2002/12/cal/ical#> " +
		"SELECT ?summary " +
		"WHERE { tutorial:business-intelligence ical:summary ?summary }";

		// Query the store and show the results
		SPARQLQuery sq = new SPARQLQuery();
		sq.setTripleStore(ts);
		sq.setQuery(query);
		AGSparqlSelect.doSparqlSelect(sq);
		
		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}
