package com.franz.agbase.examples;

import com.franz.agbase.*;


public class AGLoadWithPredicateMapping {

	/**
	 * Demonstrates loading a triple store with predicate mappings defined.
	 * 
	 * @param unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple store for this example. 
		AllegroGraph ts = ags.renew("datamapping", AGPaths.TRIPLE_STORES);

		// Add 3 predicate mappings for the temporal predicates so that their
		// values are loaded as date-time UPI's, enabling more efficient storage
		// and range querying over dates.
		String[] map = new String[9];
		map[0] = "http://franz.com/ns/allegrograph/3.0/temporal/time";
		map[1] = "date-time";
		map[2] = "predicate";
		map[3] = "http://franz.com/ns/allegrograph/3.0/temporal/starttime";
		map[4] = "date-time";
		map[5] = "predicate";
		map[6] = "http://franz.com/ns/allegrograph/3.0/temporal/endtime";
		map[7] = "date-time";
		map[8] = "predicate";
		ts.addDataMapping(map);
		
		// Load some temporal data
		AGLoadNtriples.loadNTriplesWithTiming(ts, AGPaths.dataSources("temporal.nt"));

		// Index the store for faster querying
		AGIndexAllTriples.indexAllTriplesWithTiming(ts);
		
		// Register any namespaces
		ts.registerNamespace("ex", "http://example.org/");
		ts.registerNamespace("t", "http://franz.com/ns/allegrograph/3.0/temporal/");

		TriplesIterator cc = ts.getStatements(null, "!t:starttime", null);
		AGUtils.showTriples(cc);
		
		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}
