package com.franz.agbase.examples;


import com.franz.agbase.AllegroGraphException;

public class AGLubmSparql {

	static int port = 0;
	static String store = null;
	static String ubnamespace = "http://www.lehigh.edu/~zhp2/2004/0401/univ-bench.owl#";
	
	public static void main(String[] args) throws AllegroGraphException {		
		processArgs(args);
		AGLubm50Sparql.port = port;
		AGLubm50Sparql.store = store;
		AGLubm50Sparql.ubnamespace = ubnamespace;
		AGLubm50Sparql.main(args);
	}

	static void showUsage() {
		System.out.println("Usage: ");
		System.out.println("  required: -port <integer> [e.g. -port 4567]");
		System.out.println("  required: -store <store> [e.g. -store /stores/LUBM-50]");
		System.out.println("  optional: -ub <namespace> [defaults to -ub \"http://www.lehigh.edu/~zhp2/2004/0401/univ-bench.owl#\"]");
		System.out.println("  optional: -help or -? prints this usage message");
		System.exit(1);
	}
	
	/**
	 * Process command line args.
	 * 
	 * @param args
	 */
	public static void processArgs(String[] args) {
		for (int i=0; i<args.length; i++) {
			String arg = args[i];
			if (arg.equals("-store")) {
				store = args[++i];
			} else if (arg.startsWith("-ub")) {
				ubnamespace = args[++i];
			} else if (arg.equals("-port")) {
				try {
					port = Integer.parseInt(args[++i]);
				} catch (NumberFormatException e) {
					System.out.println("Invalid port: " + arg);
					showUsage();
				}
			} else {
				if (!arg.endsWith("help")&&!arg.endsWith("?")) {
					System.out.println("Unrecognized arg: " + arg);
				}
				showUsage();
			}
		}
		if (port==0 || store==null) {
			showUsage();
		}
	}	
		
}
