package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGReasoningTransitiveProperty {

	/**
	 * Demonstrates reasoning involving owl:TransitiveProperty
	 * 
	 * @param args unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		// Create fresh triple-store for this example.
		AllegroGraph ts = ags.renew("transitiveproperty", AGPaths.TRIPLE_STORES);
		
		// Register your namespaces
		ts.registerNamespace("ex","http://example.org/");
		
		// Add some triples to the store
		ts.addStatement("!ex:a","!ex:p", "!ex:b");
		ts.addStatement("!ex:b","!ex:p", "!ex:c");
		ts.addStatement("!ex:c","!ex:p", "!ex:d");
		ts.addStatement("!ex:p","!rdf:type", "!owl:TransitiveProperty");
		
		// Retrieve some triples without reasoning 
		TriplesIterator cc = ts.getStatements(false,"!ex:a","!ex:p",null);
		System.out.println("Ground triples in the store:");
		AGUtils.showTriples(cc);

		// Now demonstrate reasoning
		cc = ts.getStatements(true,"!ex:a","!ex:p",null);
		System.out.println("Infer statements in the transitive closure of ex:a under ex:p");
		AGUtils.showTriples(cc);

		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}