package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGSNADegreesNeighbors {

	/**
	 * Demonstrates determining Degrees and Neighbors in a Social Network.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple-store.
		AllegroGraph ts = ags.renew("snadegreesneighbors", AGPaths.TRIPLE_STORES);
		
		// Register namespaces
		ts.registerNamespace("ex", "http://example.org/");
		
		// Load a small graph of data
		AGLoadNtriples.loadNTriplesWithTiming(ts, AGPaths.dataSources("sna.nt"));
		
		// Get an SNA extension instance for this store to work with SNA features 
		SNAExtension sna = ts.getSNAExtension();
		
		// Register a generator
		Object[] parts = new Object[2];
		parts[0] = "objects-of";
		parts[1] = "!ex:likes";
		sna.registerGenerator("likes-objects", parts);
		
		// Register another generator
		parts[0] = "objects-of";
		parts[1] = "!ex:knows";
		sna.registerGenerator("knows-objects", parts);
		
		// Define a group of actors
		String[] group = {"!ex:a","!ex:b","!ex:c","!ex:d","!ex:e","!ex:f","!ex:g","!ex:h","!ex:i","!ex:j"};
		
		// And the list of generators
		String[] generators = {"likes-objects","knows-objects"};
		
		// Show the nodal degrees of each node with respect to each generator 
		for (int i=0;i<group.length;i++) {
			for (int j=0;j<generators.length;j++){
				long nodalDegree = sna.getNodalDegree(group[i], generators[j]);
				System.out.println("Nodal Degree of " + group[i] + " using " + generators[j] + " is " + nodalDegree);
			}
		}

		// Show the nodal neighbors of each node with respect to each generator
		for (int i=0;i<group.length;i++) {
			for (int j=0;j<generators.length;j++){
				UPI[] nodalNeighbors = sna.getNodalNeighbors(group[i], generators[j]);
				System.out.println("Nodal Neighbors of " + group[i] + " using " + generators[j] + " are " 
						+ AGUtils.upiArrayToString(ts,nodalNeighbors));
			}
		}

		// Close the store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}
