/*
 * Decompiled with CFR 0.152.
 */
package com.knowledgereefsystems.agsail;

import com.knowledgereefsystems.agsail.AllegroSailConnection;
import com.knowledgereefsystems.agsail.AllegroSailTestCase;
import info.aduna.iteration.CloseableIteration;
import org.openrdf.model.Namespace;
import org.openrdf.model.impl.NamespaceImpl;

public class TestNamespaces
extends AllegroSailTestCase {
    public TestNamespaces(String string) throws Exception {
        super(string);
    }

    public void testClearNamespaces() throws Exception {
        AllegroSailConnection allegroSailConnection = this.sail.getConnection();
        TestNamespaces.assertTrue((0 < this.count(allegroSailConnection.getNamespaces()) ? 1 : 0) != 0);
        allegroSailConnection.clearNamespaces();
        TestNamespaces.assertEquals((int)0, (int)this.count(allegroSailConnection.getNamespaces()));
        allegroSailConnection.close();
    }

    public void testGetNamespace() throws Exception {
        AllegroSailConnection allegroSailConnection = this.sail.getConnection();
        NamespaceImpl namespaceImpl = new NamespaceImpl("ns1", "http://example.org/ns1/");
        TestNamespaces.assertNull((Object)allegroSailConnection.getNamespace(namespaceImpl.getPrefix()));
        allegroSailConnection.setNamespace(namespaceImpl.getPrefix(), namespaceImpl.getName());
        TestNamespaces.assertEquals((String)namespaceImpl.getName(), (String)allegroSailConnection.getNamespace(namespaceImpl.getPrefix()));
        TestNamespaces.assertEquals((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#", (String)allegroSailConnection.getNamespace("rdf"));
        TestNamespaces.assertEquals((String)"http://www.w3.org/2000/01/rdf-schema#", (String)allegroSailConnection.getNamespace("rdfs"));
        allegroSailConnection.close();
    }

    public void testGetNamespaces() throws Exception {
        int n;
        AllegroSailConnection allegroSailConnection = this.sail.getConnection();
        int n2 = 0;
        int n3 = 0;
        int n4 = this.count(allegroSailConnection.getNamespaces());
        int n5 = 10;
        String string = "testns";
        String string2 = "http://example.org/test";
        for (n = 0; n < n5; ++n) {
            allegroSailConnection.setNamespace(string + n, string2 + n);
        }
        allegroSailConnection.commit();
        CloseableIteration closeableIteration = allegroSailConnection.getNamespaces();
        while (closeableIteration.hasNext()) {
            Namespace namespace = (Namespace)closeableIteration.next();
            ++n2;
            String string3 = namespace.getPrefix();
            String string4 = namespace.getName();
            if (!string3.startsWith(string)) continue;
            TestNamespaces.assertEquals((String)string4, (String)(string2 + string3.substring(string.length())));
        }
        closeableIteration.close();
        for (n = 0; n < n5; ++n) {
            allegroSailConnection.removeNamespace(string + n);
        }
        allegroSailConnection.commit();
        n3 = this.count(allegroSailConnection.getNamespaces());
        TestNamespaces.assertEquals((int)n2, (int)(n4 + n5));
        TestNamespaces.assertEquals((int)n3, (int)n4);
        allegroSailConnection.close();
    }

    public void testSetNamespace() throws Exception {
        AllegroSailConnection allegroSailConnection = this.sail.getConnection();
        String string = "foo";
        String string2 = "";
        String string3 = "http://example.org/foo";
        String string4 = "http://example.org/bar";
        allegroSailConnection.removeNamespace(string);
        allegroSailConnection.removeNamespace(string2);
        allegroSailConnection.commit();
        TestNamespaces.assertNull((Object)allegroSailConnection.getNamespace(string));
        TestNamespaces.assertNull((Object)allegroSailConnection.getNamespace(string2));
        allegroSailConnection.setNamespace(string, string3);
        allegroSailConnection.commit();
        TestNamespaces.assertEquals((String)allegroSailConnection.getNamespace(string), (String)string3);
        allegroSailConnection.setNamespace(string, string4);
        allegroSailConnection.commit();
        TestNamespaces.assertEquals((String)allegroSailConnection.getNamespace(string), (String)string4);
        allegroSailConnection.setNamespace(string2, string3);
        allegroSailConnection.commit();
        TestNamespaces.assertEquals((String)allegroSailConnection.getNamespace(string2), (String)string3);
        allegroSailConnection.close();
    }

    public void testRemoveNamespace() throws Exception {
        AllegroSailConnection allegroSailConnection = this.sail.getConnection();
        String string = "foo";
        String string2 = "";
        String string3 = "http://example.org/foo";
        allegroSailConnection.setNamespace(string, string3);
        allegroSailConnection.commit();
        TestNamespaces.assertEquals((String)allegroSailConnection.getNamespace(string), (String)string3);
        allegroSailConnection.removeNamespace(string);
        allegroSailConnection.commit();
        TestNamespaces.assertNull((Object)allegroSailConnection.getNamespace(string));
        allegroSailConnection.setNamespace(string2, string3);
        allegroSailConnection.commit();
        TestNamespaces.assertEquals((String)allegroSailConnection.getNamespace(string2), (String)string3);
        allegroSailConnection.removeNamespace(string2);
        allegroSailConnection.commit();
        TestNamespaces.assertNull((Object)allegroSailConnection.getNamespace(string2));
        allegroSailConnection.close();
    }
}

