/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase;

import com.franz.ag.AllegroGraphException;
import com.franz.ag.UPI;
import com.franz.agbase.transport.AGConnector;
import com.franz.agbase.util.AGInternals;
import java.lang.reflect.Array;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SNAExtension {
    private AGInternals ag = null;

    SNAExtension(AGInternals aGInternals) {
        this.ag = aGInternals;
    }

    public void copyGeneratorsFrom(SNAExtension sNAExtension) throws AllegroGraphException {
        this.ag.verifyEnabled().applyAGFn(this.ag, "ag-copy-generators", new Object[]{new Integer(sNAExtension.ag.tsx)});
    }

    private UPI[] getUPIArray(Object[] objectArray) {
        if (null == objectArray) {
            return new UPI[0];
        }
        if (0 == objectArray.length) {
            return new UPI[0];
        }
        return AGConnector.toUPIArray(objectArray[0]);
    }

    public void registerGenerator(String string, Object[] objectArray) throws AllegroGraphException {
        if (null == objectArray) {
            this.ag.verifyEnabled().applyAGFn(this.ag, "ag-register-generator", new Object[0]);
            return;
        }
        if (0 == objectArray.length) {
            return;
        }
        Object object = objectArray[0];
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(string);
        if (object instanceof String) {
            this.decodePart(objectArray, arrayList);
        } else if (object instanceof Object[]) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.decodePart((Object[])objectArray[i], arrayList);
            }
        } else {
            throw new IllegalArgumentException("Generator parts array is not well-formed.");
        }
        this.ag.verifyEnabled().applyAGFn(this.ag, "ag-register-generator", arrayList.toArray());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void decodePart(Object[] objectArray, ArrayList<Object> arrayList) {
        if (objectArray == null) {
            return;
        }
        arrayList.add(new Integer(objectArray.length));
        boolean bl = false;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (0 == i) {
                if (!(object instanceof String)) {
                    throw new IllegalArgumentException("First item in generator part must be a string.");
                }
                String string = (String)object;
                if ("objects-of".equalsIgnoreCase(string) || "subjects-of".equalsIgnoreCase(string) || "undirected".equalsIgnoreCase(string)) {
                    bl = true;
                } else {
                    if (!"select".equalsIgnoreCase(string)) throw new IllegalArgumentException("Unknown generator part " + string);
                    bl = false;
                }
            } else if (bl) {
                object = this.ag.validRef(object);
            }
            arrayList.add(object);
        }
    }

    public UPI[] breadthFirstSearch(Object object, Object object2, String string, int n) throws AllegroGraphException {
        return this.getUPIArray(this.ag.verifyEnabled().applyAGFn(this.ag, "ag-breadth-first-search", new Object[]{this.ag.validRef(object), this.ag.validRef(object2), string, new Integer(n)}));
    }

    public void mapBreadthFirstSearch(Object object, Object object2, String string, String string2, int n) throws AllegroGraphException {
        this.ag.verifyEnabled().applyAGFn(this.ag, "ag-breadth-first-map", new Object[]{this.ag.validRef(object), this.ag.validRef(object2), string, string2, new Integer(n)});
    }

    private UPI[][] toPathArray(Object[] objectArray) {
        Object object = objectArray[0];
        if (object == null) {
            return new UPI[0][0];
        }
        if (!(object instanceof UPI[])) {
            if (object.getClass().isArray()) {
                if (AGConnector.hasLongValue(object = Array.get(object, 0)) && 0L == AGConnector.longValue(object)) {
                    return new UPI[0][0];
                }
                throw new IllegalStateException("Unexpected path array " + object);
            }
            throw new IllegalStateException("Unexpected path array " + object);
        }
        Object[] objectArray2 = (Object[])object;
        int n = (int)AGConnector.longValue(objectArray2[0]);
        UPI[][] uPIArray = new UPI[n][];
        int n2 = 0;
        int n3 = 1;
        while (n3 < objectArray2.length) {
            int n4 = (int)AGConnector.longValue(objectArray2[n3]);
            ++n3;
            UPI[] uPIArray2 = new UPI[n4];
            for (int i = 0; i < n4; ++i) {
                uPIArray2[i] = (UPI)objectArray2[n3];
                ++n3;
            }
            uPIArray[n2] = uPIArray2;
            ++n2;
        }
        return uPIArray;
    }

    public UPI[][] allBreadthFirstSearchPaths(Object object, Object object2, String string, int n) throws AllegroGraphException {
        return this.toPathArray(this.ag.verifyEnabled().applyAGFn(this.ag, "ag-breadth-first-all", new Object[]{this.ag.validRef(object), this.ag.validRef(object2), string, new Integer(n)}));
    }

    public UPI[] depthFirstSearch(Object object, Object object2, String string, int n) throws AllegroGraphException {
        return this.getUPIArray(this.ag.verifyEnabled().applyAGFn(this.ag, "ag-depth-first-search", new Object[]{this.ag.validRef(object), this.ag.validRef(object2), string, new Integer(n)}));
    }

    public void mapDepthFirstSearch(Object object, Object object2, String string, String string2, int n) throws AllegroGraphException {
        this.ag.verifyEnabled().applyAGFn(this.ag, "ag-depth-first-map", new Object[]{this.ag.validRef(object), this.ag.validRef(object2), string, string2, new Integer(n)});
    }

    public UPI[][] allDepthFirstSearchPaths(Object object, Object object2, String string, int n) throws AllegroGraphException {
        return this.toPathArray(this.ag.verifyEnabled().applyAGFn(this.ag, "ag-depth-first-all", new Object[]{this.ag.validRef(object), this.ag.validRef(object2), string, new Integer(n)}));
    }

    public UPI[] bidirectionalSearch(Object object, Object object2, String string, int n) throws AllegroGraphException {
        return this.getUPIArray(this.ag.verifyEnabled().applyAGFn(this.ag, "ag-bidirectional-search", new Object[]{this.ag.validRef(object), this.ag.validRef(object2), string, new Integer(n)}));
    }

    public void mapBidirectionalSearch(Object object, Object object2, String string, String string2, int n) throws AllegroGraphException {
        this.ag.verifyEnabled().applyAGFn(this.ag, "ag-bidirectional-map", new Object[]{this.ag.validRef(object), this.ag.validRef(object2), string, string2, new Integer(n)});
    }

    public UPI[][] allBidirectionalSearchPaths(Object object, Object object2, String string, int n) throws AllegroGraphException {
        return this.toPathArray(this.ag.verifyEnabled().applyAGFn(this.ag, "ag-bidirectional-all", new Object[]{this.ag.validRef(object), this.ag.validRef(object2), string, new Integer(n)}));
    }

    public void mapBreadthFirstSearchPathsBipartite(Object object, Object object2, String string, String string2, String string3, int n) throws AllegroGraphException {
        this.ag.verifyEnabled().applyAGFn(this.ag, "ag-breadth-first-bipartite", new Object[]{this.ag.validRef(object), this.ag.validRef(object2), string, string2, string3, new Integer(n)});
    }

    public void mapDepthFirstSearchPathsBipartite(Object object, Object object2, String string, String string2, String string3, int n) throws AllegroGraphException {
        this.ag.verifyEnabled().applyAGFn(this.ag, "ag-depth-first-bipartite", new Object[]{this.ag.validRef(object), this.ag.validRef(object2), string, string2, string3, new Integer(n)});
    }

    public void mapBidirectionalSearchPathsBipartite(Object object, Object object2, String string, String string2, String string3, int n) throws AllegroGraphException {
        this.ag.verifyEnabled().applyAGFn(this.ag, "ag-bidirectional-bipartite", new Object[]{this.ag.validRef(object), this.ag.validRef(object2), string, string2, string3, new Integer(n)});
    }

    public UPI[] getNodalNeighbors(Object object, String string) throws AllegroGraphException {
        return this.getUPIArray(this.ag.verifyEnabled().applyAGFn(this.ag, "ag-nodal-neighbors", new Object[]{this.ag.validRef(object), string}));
    }

    public long getNodalDegree(Object object, String string) throws AllegroGraphException {
        Object[] objectArray = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-nodal-degree", new Object[]{this.ag.validRef(object), string});
        if (objectArray == null) {
            return 0L;
        }
        if (0 == objectArray.length) {
            return 0L;
        }
        return AGConnector.longValue(objectArray[0]);
    }

    public UPI[] getEgoGroup(Object object, String string, int n) throws AllegroGraphException {
        return this.getUPIArray(this.ag.verifyEnabled().applyAGFn(this.ag, "ag-ego-group", new Object[]{this.ag.validRef(object), new Integer(n), string}));
    }

    public double getDensity(Object object, String string) throws AllegroGraphException {
        Object[] objectArray = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-density", new Object[]{this.ag.validRefs(object), string});
        if (objectArray == null) {
            return 0.0;
        }
        if (0 == objectArray.length) {
            return 0.0;
        }
        return AGConnector.doubleValue(objectArray[0]);
    }

    public double getDegreeCentrality(Object object, Object object2, String string) throws AllegroGraphException {
        Object[] objectArray = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-degree-centrality", new Object[]{this.ag.validRef(object, null), this.ag.validRefs(object2), string});
        if (objectArray == null) {
            return 0.0;
        }
        if (0 == objectArray.length) {
            return 0.0;
        }
        return AGConnector.doubleValue(objectArray[0]);
    }

    public double getClosenessCentrality(Object object, Object object2, String string) throws AllegroGraphException {
        Object[] objectArray = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-closeness-centrality", new Object[]{this.ag.validRef(object, null), this.ag.validRefs(object2), string});
        if (objectArray == null) {
            return 0.0;
        }
        if (0 == objectArray.length) {
            return 0.0;
        }
        return AGConnector.doubleValue(objectArray[0]);
    }

    public double getBetweennessCentrality(Object object, Object object2, String string) throws AllegroGraphException {
        Object[] objectArray = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-betweenness-centrality", new Object[]{this.ag.validRef(object, null), this.ag.validRefs(object2), string});
        if (objectArray == null) {
            return 0.0;
        }
        if (0 == objectArray.length) {
            return 0.0;
        }
        return AGConnector.doubleValue(objectArray[0]);
    }

    public boolean isClique(Object object, String string) throws AllegroGraphException {
        Object[] objectArray = this.ag.verifyEnabled().applyAGFn(this.ag, "ag-is-clique", new Object[]{this.ag.validRefs(object), string});
        if (null == objectArray) {
            return false;
        }
        if (0 == objectArray.length) {
            return false;
        }
        return null != objectArray[0];
    }

    public UPI[][] getCliques(Object object, String string, int n) throws AllegroGraphException {
        return this.toPathArray(this.ag.verifyEnabled().applyAGFn(this.ag, "ag-cliques", new Object[]{this.ag.validRef(object), string, new Integer(n)}));
    }

    public void mapCliques(Object object, String string, String string2, int n) throws AllegroGraphException {
        this.ag.verifyEnabled().applyAGFn(this.ag, "ag-map-cliques", new Object[]{this.ag.validRef(object), string, string2, new Integer(n)});
    }
}

