package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGFreetextIndex {

	/**
	 * Demonstrates Freetext indexing and search on the Kennedy data 
	 *
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple store
		AllegroGraph ts = ags.renew("kennedy", AGPaths.TRIPLE_STORES);

		// Register any predicates whose objects are to be searched for text
		// You must register predicates before the data is loaded.
		ts.registerFreetextPredicate("<http://example.org/kennedy/first-name>");
		
		// You can confirm that the server got the registration
		String[] ftpreds = ts.getFreetextPredicates();
		AGUtils.printStringArray("getFreetextPredicates:", ftpreds);

		// Load the Kennedy data
		AGLoadNtriples.loadNTriplesWithTiming(ts, AGPaths.dataSources("kennedy.ntriples"));
		
		// Index the store for querying, wait until indexing is complete.
		ts.indexAllTriples(true);

		// Search the store for statements whose objects contain Arnold
		TriplesIterator cc = ts.getFreetextStatements("'Arnold'");
		AGUtils.showTriples(cc);
		
		// Close the triple store and disconnect from the server
		ts.closeTripleStore();
		ags.disable();
	}

}
