package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGGeospatialPredicateMapping {

	/**
	 * Demonstrates using a Geospatial predicate mapping to load geospatial data.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple-store.
		AllegroGraph ts = ags.renew("geospatialpredicatemapping", AGPaths.TRIPLE_STORES);
		
		// Register namespaces
		ts.registerNamespace("ex","http://example.org/places/");
		ts.registerNamespace("geo","http://franz.com/ns/allegrograph/3.0/geospatial/");
		
		// Get a GeoExtension instance for this store to work with geospatial features 
		GeoExtension geo = ts.getGeoExtension();
		
		// Define a geospatial subtype to encode longitude-latitude coordinates 
		GeospatialSubtype subtype50 = geo.registerLatitudeStripingInMiles(50.0);
		geo.addSubtype(subtype50);
		
		// Add a predicate mapping to encode loaded locations as Geospatial UPIs
		geo.addSphericalPredicateMapping("http://example.org/locationB", subtype50);
		//geo.addSphericalDatatypeMapping("http://franz.com/ns/allegrograph/3.0/geospatial/spherical/miles/-180.0/180.0/-90.0/90.0/50.0d0", subtype50);
		
		// Load some geospatial data
		AGLoadNtriples.loadNTriplesWithTiming(ts, AGPaths.dataSources("geospatial.nt"));

		// Show all triples in the store
		TriplesIterator cc = ts.getStatements(null,null,null);
		AGUtils.showTriples(cc);
		
		// Close the store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}
