package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGNamedGraphs {

	/**
	 * Demonstrates some basics of working with named graphs.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		// Create a fresh triple-store for this example.
		AllegroGraph ts = ags.renew("namedgraphs", AGPaths.TRIPLE_STORES);
		
		// Register any namespaces
		ts.registerNamespace("ex","http://example.org/");
		
		// Add a triple to the default graph in the store
		ts.addStatement("!ex:a", "!ex:p", "!ex:b");
		
		// Add a triple to a named graph in the store
		ts.addStatement("!ex:Dog","!rdf:type","!owl:Class","<http://animals.example.org>"); 
		
		// Show all triples in all graphs in the store
		System.out.println("Show all triples in all graphs in the store");
		TriplesIterator cc = ts.getStatements(null, null, null, null);
		AGUtils.showTriples(cc);
		
		// Show all triples in a named graph in the store
		System.out.println("Show all triples in graph http://animals.example.org");
		cc = ts.getStatements(null, null, null, "<http://animals.example.org>");
		AGUtils.showTriples(cc);
		
		// Show all triples in the default graph
		System.out.println("Show all triples in the default graph");
		cc = ts.getStatements(null, null, null);
		AGUtils.showTriples(cc);
		
		// Another way of showing all triples in the default graph
		System.out.println("Another way of showing all triples in the default graph");
		cc = ts.getStatements(null, null, null, "");
		AGUtils.showTriples(cc);
		
		// Close the store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}
}
