package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGNamespaces {

	/**
	 * Demonstrates basic use of namespaces in triples
	 * 
	 * @param args unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		// Create fresh triple-store for this example.
		AllegroGraph ts = ags.renew("namespaces", AGPaths.TRIPLE_STORES);
		
		// Add a triple without using namespaces
		ts.addStatement("<http://example.org/c>",
				"<http://example.org/p>", 
				"<http://example.org/d>");

		// Register your namespaces
		// Note that rdf, owl, and some others come pre-registered
		ts.registerNamespace("ex","http://example.org/");
		ts.registerNamespace("xsd", "http://www.w3.org/2001/XMLSchema#");
		
		// Create a URI using a namespace and show it
		URINode a = (URINode)ts.addPart("!ex:a");
		AGUtils.showURI(a);
		
		// Create a Literal using a namespace
		LiteralNode lit = (LiteralNode)ts.addPart("!\"42\"^^xsd:integer");
		
		// Add some triples to the store using namespaces
		ts.addStatement(a,"!ex:p", lit);
		ts.addStatement("!ex:b","!ex:p", "!ex:c");
		ts.addStatement("!ex:p","!rdf:type", "!owl:TransitiveProperty");
		
		// Retrieve some triples without using namespaces
		TriplesIterator it = ts.getStatements(false,null,"<http://example.org/p>",null);
		System.out.println("Triples with predicate http://example.org/p:");
		AGUtils.showTriples(it);

		// Now using namespaces 
		it = ts.getStatements(false,null,"!ex:p",null);
		System.out.println("Triples with predicate ex:p");
		AGUtils.showTriples(it);

		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}