package com.franz.agjena.examples;


import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphConnection;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.examples.AGPaths;
import com.franz.agjena.AllegroGraphGraphMaker;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphMaker;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.test.NodeCreateUtils;

public class AGJenaGraphInterface {

	/**
	 * Demonstrates the Jena Graph interface to AllegroGraph.
	 *
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {

		// Show the empty graph 
	    showGraph(Graph.emptyGraph);
		
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple store
		AllegroGraph ts = ags.renew("store", AGPaths.TRIPLE_STORES);

		// Create a GraphMaker for the store.
	    GraphMaker maker = new AllegroGraphGraphMaker(ts);
	    
	    // Get the default graph
	    Graph g = maker.getGraph();
	    showGraph(g);
	    
	    // Add a triple to the graph
	    Node r = NodeCreateUtils.create( "r" ), s = NodeCreateUtils.create( "s" ), p = NodeCreateUtils.create( "P" );
	    Triple t1 = Triple.create( r, p, s );
	    g.add(t1);
	    showGraph(g);
	    
	    // Check that the graph contains the triple
	    boolean b = g.contains( t1 );
	    System.out.println("contains ( t1 ): " + b);
	    
	    // Check another way
	    b = g.contains( r, p, Node.ANY );
	    System.out.println("contains( r, p, Node.ANY ): " + b);
	    
	    // And yet another way
	    Triple t2 = Triple.create( r, p, s );
	    b = g.contains( t2 );
	    System.out.println("contains( t2 ): " + b);
	    
	    // Show number found using find
	    int size = g.find( r, p, Node.ANY ).toList().size();
	    System.out.println("number found: " + size);
	    
	    // And compare against the number of triples in the store
	    System.out.println("numberOfTriples(): " + ts.numberOfTriples());

		// Close the store and disconnect from the server
		ts.closeTripleStore();
		ags.disable();
	}

	public static void showGraph(Graph g) {
	    System.out.println(g.toString()+": "+g.size()+" triples.");
	}
}
