package com.franz.agjena.examples;


import com.franz.agjena.exceptions.NiceException;
import com.franz.agjena.query.AllegroGraphQuery;
import com.franz.agjena.query.AllegroGraphQueryExecutionFactory;
import com.franz.agjena.query.AllegroGraphQueryFactory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.sparql.core.DatasetImpl;
import com.hp.hpl.jena.sparql.resultset.ResultSetRewindable;

public class AGJenaUtils {
	
	/**
	 * Execute 'sparqlQuery' against 'model' and print a tabular result.
	 */
	public static void doQuery (String sparqlQuery, Model model) {
        AllegroGraphQuery query = AllegroGraphQueryFactory.create(sparqlQuery) ;
        System.out.println("Query: " + sparqlQuery);
        QueryExecution qe = AllegroGraphQueryExecutionFactory.create(query, model) ;
        ResultSetRewindable rs = ResultSetFactory.makeRewindable(qe.execSelect()) ;
        ResultSetFormatter.out(rs) ;
        qe.close() ; 
	}
	
	/**
	 * Execute 'sparqlQuery' against 'graph' and print a tabular result.
	 */
	public static void doQuery (String sparqlQuery, Graph graph) {
        AllegroGraphQuery query = AllegroGraphQueryFactory.create(sparqlQuery) ;
        System.out.println("Query: " + sparqlQuery);
        // THERE MUST BE A BETTER WAY TO DEFINE THE DATASET
        QueryExecution qe = AllegroGraphQueryExecutionFactory.create(query, new DatasetImpl(new ModelCom(graph))) ;
        ResultSetRewindable rs = ResultSetFactory.makeRewindable(qe.execSelect()) ;
        ResultSetFormatter.out(rs) ;
        qe.close() ; 
	}

	/**
	 * Print all statements in 'model' showing also the model's graph.
	 */
	public static void printModel (Model model) {
		try {
			StmtIterator it = model.listStatements();
			while (it.hasNext()) {
				Statement st = (Statement)it.next();
				System.out.println(st.toString() + " in " + model.getGraph().toString());
			}
		} catch (Exception ex) {throw new NiceException(ex);}
	}
	
}
