package com.franz.ag.impl;

import com.franz.ag.AllegroGraph;
import com.franz.ag.BlankNode;
import com.franz.ag.Cursor;
import com.franz.ag.DefaultGraph;
import com.franz.ag.EncodedLiteral;
import com.franz.ag.Literal;
import com.franz.ag.Node;
import com.franz.ag.Triple;
import com.franz.ag.UPI;
import com.franz.agbase.impl.LiteralNodeImpl.Lang;
import com.franz.agbase.impl.UPIImpl;

public class AGFactory {
	
	public static BlankNode makeBlankNode ( AllegroGraph ts, UPI i, String ss ) {
		return new BlankNodeImpl(ts, i, ss);
	}
	
	public static BlankNode makeBlankNode ( AllegroGraph ts, com.franz.agbase.BlankNode base ) {
		return new BlankNodeImpl(ts, base);
	}
	
	public static Cursor makeCursor(AllegroGraph rts, Object cursor, UPIImpl[] newts) {
		return new CursorImpl(rts, cursor, newts);
	}
	
	public static Cursor makeCursor(AllegroGraph rts, Object cursor, UPIImpl[] newts,
			String[] newdefs) {
		return new CursorImpl(rts, cursor, newts, newdefs);
	}
	
	public static Cursor makeCursor(AllegroGraph rts, com.franz.agbase.TriplesIterator base ) {
		return new CursorImpl(rts, base);
	}
	
	public static DefaultGraph makeDefaultGraph( AllegroGraph ag, UPI id ) {
		return new DefaultGraphImpl(ag, id);
	}
	
	public static DefaultGraph makeDefaultGraph( AllegroGraph ag, com.franz.agbase.DefaultGraph base ) {
		return new DefaultGraphImpl(ag, base);
	}
	
	public static EncodedLiteral makeEncodedLiteral ( AllegroGraph ts, long value, 
			String newEncoding ) {
		return new EncodedLiteralImpl(ts, value, newEncoding);
	}
	
	public static EncodedLiteral makeEncodedLiteral ( AllegroGraph ts, double value,
			String newEncoding ) {
		return new EncodedLiteralImpl(ts, value, newEncoding);
	}
	
	public static EncodedLiteral makeEncodedLiteral ( AllegroGraph ts, String value,
			String newEncoding ) {
		return new EncodedLiteralImpl(ts, value, newEncoding);
	}
	
	public static EncodedLiteral makeEncodedLiteral ( AllegroGraph ts, com.franz.agbase.EncodedLiteral base ) {
		return new EncodedLiteralImpl(ts, base);
	}
	
	public static Literal makeLiteral ( AllegroGraph ts, UPI i, String newLabel,
			UPI newTypeId, String newType, 
			Lang newLangSlot, String newLanguage ) {
		return new LiteralImpl(ts, i, newLabel, newTypeId, newType, newLangSlot, newLanguage);
	}
	
	public static Literal makeLiteral ( AllegroGraph ts, com.franz.agbase.LiteralNode base ) {
		return new LiteralImpl(ts, base);
	}
	
	public static Node makeNode( AllegroGraph ts, UPI i, String u ) {
		return new NodeImpl(ts, i, u);
	}
	
	public static Node makeNode( AllegroGraph ts, com.franz.agbase.URINode base ) {
		return new NodeImpl(ts, base);
	}
	
	public static Triple makeTriple ( AllegroGraph ts, UPI ss, UPI pp, UPI oo  ) {
		return new TripleImpl(ts, ss, pp, oo);
	}
	
	public static Triple makeTriple ( AllegroGraph ts, UPI ss, UPI pp, UPI oo,
			UPI cc  ) {
		return new TripleImpl(ts, ss, pp, oo, cc);
	}
	
	public static Triple makeTriple ( AllegroGraph ts, long i, UPI ss, UPI pp, 
			UPI oo  ) {
		return new TripleImpl(ts, i, ss, pp, oo);
	}
	
	public static Triple makeTriple ( AllegroGraph ts, long i, UPI ss, UPI pp,
			UPI oo, UPI cc  ) {
		return new TripleImpl(ts, i, ss, pp, oo, cc);
	}
	
	public static Triple makeTriple ( AllegroGraph ts, com.franz.agbase.Triple base ) {
		return new TripleImpl(ts, base);
	}
}
