/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna.biz/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.model;

import org.openrdf.sesame.sail.StatementIterator;

/**
 * A URI resource.
 *
 * @author Jeen Broekstra
 * @author Arjohn Kampman
 * @version $Revision: 1.1.2.1 $
 **/
public interface URI extends Resource {

	/**
	 * Gets the namespace of this URI.
	 *
	 * @return The URI's namespace.
	 **/
	public String getNamespace();

	/**
	 * Gets the local name of this URI.
	 *
	 * @return The URI's local name.
	 **/
	public String getLocalName();

	/**
	 * Returns the String-representation of this URI. The String-representation
	 * consists of the concatenation of the namespace and the local name.
	 *
	 * @return The String-representation of this URI.
	 **/
	public String getURI();
	
	/**
	 * Gets all statements from the RDF graph for which this URI is the predicate.
	 **/
	public StatementIterator getPredicateStatements()
		throws GraphException;
}
