package com.franz.agbase;

import java.util.HashMap;

import com.franz.agbase.util.AGC;

/**
 * This class defines a number of inner classes that form the AllegroGraph
 * error hierarchy.
 * 
 * <strong>
 * THESE EXCEPTIONS WILL ONLY BE THROWN BY A SERVER AT serverLevel(18).
 * Older servers such as 3.2 serverLevel(17) will throw unclassified exceptions.
 * </strong>
 * @author mm
 *
 */
public class AllegroGraphExceptions {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	
	/**
	 * This table maps to RuntimeException subclasses
	 */
	@SuppressWarnings("unchecked")
	HashMap<String, Class> rxMap = new HashMap<String, Class>();
	
	/**
	 * This table maps to AllegroGraphException subclasses
	 */
	@SuppressWarnings("unchecked")
	HashMap<String, Class> axMap = new HashMap<String, Class>();
	

	
	public static class InternalError extends IllegalArgumentException {
		public InternalError ( String msg ) { super(msg); }
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;
	
	}
	
	public static class Runtime extends IllegalArgumentException {
		Runtime ( String msg ) { super(msg); }
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;
	
	}
	
	public static class ServerError extends Runtime {
		public ServerError ( String msg ) { super(msg); }
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;
	}
	{ rxMap.put(AGC.AGE_SERVER_ERROR, ServerError.class); }
	
	public static class ClientError extends Runtime {
		public ClientError ( String msg ) { super(msg); }
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;
	}
	{ rxMap.put(AGC.AGE_CLIENT_ERROR, ClientError.class); }
	
	/**
	 * The AllegroGraph server ran out of memory during the last operation.
	 * @author mm
	 *
	 */
	public static class ServerMemory extends ServerError {
		public ServerMemory ( String msg ) { super(msg); }
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;
	}
	{ rxMap.put(AGC.AGE_STORAGE_CONDITION, ServerMemory.class); }
	
	/**
	 * The operation was interrupted by a client call from another thread.
	 * @author mm
	 *
	 */
	public static class Interrupted extends ServerError {
		public Interrupted ( String msg ) { super(msg); }
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;
	}
	{ rxMap.put(AGC.AGE_INTERRUPTED, Interrupted.class); }
	
	/**
	 * The triple store in question is busy in a long operation initiated by
	 * another client.
	 * @author mm
	 *
	 */
	public static class StoreBusy extends ServerError {
		public StoreBusy ( String msg ) { super(msg); }
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;
	}
	{ rxMap.put(AGC.AGE_STORE_BUSY, StoreBusy.class); }
	
	/**
	 * Accessing or creating a store failed because of some problem in the
	 * file system or the name.
	 * @author mm
	 *
	 */
	public static class StoreAccess extends ServerError {
		public StoreAccess ( String msg ) { super(msg); }
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;
	}
	{ rxMap.put(AGC.AGE_STORE_ACCESS, StoreAccess.class); }
	
	/**
	 * The client call had ill-formed arguments.
	 * @author mm
	 *
	 */
	public static class IllFormed extends ClientError {
		public IllFormed ( String msg ) { super(msg); }
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;
	}
	{ rxMap.put(AGC.AGE_ILL_FORMED, IllFormed.class); }
	
	/**
	 * The client call specified a triple part that could not be parsed or resolved.
	 * @author mm
	 *
	 */
	public static class PartRef extends ClientError {
		public PartRef ( String msg ) { super(msg); }
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;
	}
	{ rxMap.put(AGC.AGE_BAD_PART_REF, PartRef.class); }
	
	

}
