/*
 * Decompiled with CFR 0.152.
 */
package com.franz.ag.repository;

import com.franz.agbase.SPARQLQuery;
import com.franz.agbase.SPARQLQueryConstants;
import com.franz.agsail.util.AGSInternal;
import java.util.Iterator;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.Query;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.query.impl.MapBindingSet;

public class AGQuery
implements Query {
    AGSInternal ags = null;
    SPARQLQuery sq = null;
    protected MapBindingSet bindings = new MapBindingSet();
    protected int maxQueryTime = 0;

    public AGQuery(AGSInternal aGSInternal, SPARQLQuery sPARQLQuery) {
        this.ags = aGSInternal;
        this.sq = sPARQLQuery;
        sPARQLQuery.setEngine(SPARQLQueryConstants.ENGINE.ALGEBRA);
    }

    public SPARQLQuery getSPARQLQuery() {
        return this.sq;
    }

    public BindingSet getBindings() {
        return this.bindings;
    }

    public Dataset getDataset() {
        String[] stringArray;
        DatasetImpl datasetImpl = new DatasetImpl();
        String[] stringArray2 = stringArray = this.sq.getFrom();
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray2[i];
            datasetImpl.addDefaultGraph((URI)new URIImpl(string));
        }
        for (String string : stringArray2 = this.sq.getFromNamed()) {
            datasetImpl.addNamedGraph((URI)new URIImpl(string));
        }
        return datasetImpl;
    }

    public boolean getIncludeInferred() {
        return this.sq.isIncludeInferred();
    }

    public int getMaxQueryTime() {
        return this.maxQueryTime;
    }

    public void removeBinding(String string) {
        this.bindings.removeBinding(string);
    }

    public void setBinding(String string, Value value) {
        this.bindings.addBinding(string, value);
        Iterator iterator = this.bindings.iterator();
        Object[] objectArray = new Object[2 * this.bindings.size()];
        int n = 0;
        while (iterator.hasNext()) {
            Binding binding = (Binding)iterator.next();
            objectArray[n] = binding.getName();
            objectArray[n + 1] = this.ags.coerceToAGPart(binding.getValue());
            n += 2;
        }
        this.sq.setWithVariables(this.ags.getDirectInstance(), objectArray);
    }

    public void setDataset(Dataset dataset) {
        String[] stringArray3;
        Set set = dataset.getDefaultGraphs();
        String[] stringArray2 = new String[set.size()];
        int n = 0;
        for (String[] stringArray3 : set) {
            stringArray2[n] = stringArray3.stringValue();
            ++n;
        }
        this.sq.setFrom(stringArray2);
        Set set2 = dataset.getNamedGraphs();
        stringArray3 = new String[set2.size()];
        n = 0;
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            URI uRI = (URI)iterator.next();
            stringArray3[n] = uRI.stringValue();
            ++n;
        }
        this.sq.setFromNamed(stringArray3);
    }

    public void setIncludeInferred(boolean bl) {
        this.sq.setIncludeInferred(bl);
    }

    public void setMaxQueryTime(int n) {
        this.maxQueryTime = n;
    }
}

