/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase.impl;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.Triple;
import com.franz.agbase.TriplesIterator;
import com.franz.agbase.UPI;
import com.franz.agbase.ValueNode;
import com.franz.agbase.ValueObject;
import com.franz.agbase.impl.TripleImpl;
import com.franz.agbase.impl.UPIImpl;
import com.franz.agbase.util.AGInternals;

public class TriplesIteratorImpl
implements TriplesIterator {
    public static int defaultLookAhead = 1000;
    static final long NO_VALUE = -1L;
    private AllegroGraph ag;
    private Object source;
    int lookAhead = defaultLookAhead;
    long id = -1L;
    UPIImpl s = null;
    UPIImpl p = null;
    UPIImpl o = null;
    UPIImpl c = null;
    String sVal = null;
    int sType = 0;
    String sMod = null;
    String pVal = null;
    int pType = 0;
    String pMod = null;
    String oVal = null;
    int oType = 0;
    String oMod = null;
    String cVal = null;
    int cType = 0;
    String cMod = null;
    boolean nextp = false;
    boolean truncated = false;
    int cacheIndex = -1;
    UPI[] cache = null;
    static final int CACHE_CYCLE = 5;
    int[] cTypes = null;
    String[] cVals = null;
    String[] cMods = null;
    boolean withParts;
    public static final TriplesIterator emptyCursor = new TriplesIteratorImpl(null, null);

    public static int getDefaultLookAhead() {
        return defaultLookAhead;
    }

    public static void setDefaultLookAhead(int n) {
        defaultLookAhead = n < 1 ? 1000 : n;
    }

    public int getLookAhead() {
        return this.lookAhead;
    }

    public void setLookAhead(int n) {
        this.lookAhead = n < 1 ? defaultLookAhead : n;
    }

    public AllegroGraph getAG() {
        return this.ag;
    }

    public Object getSource() {
        return this.source;
    }

    public AGInternals getStore() {
        return this.ag;
    }

    public static TriplesIterator emptyCursor() {
        return emptyCursor;
    }

    static int initLookAhead(AGInternals aGInternals) {
        if (aGInternals == null) {
            return 0;
        }
        if (0 == aGInternals.defaultLookAhead) {
            return defaultLookAhead;
        }
        return aGInternals.defaultLookAhead;
    }

    TriplesIteratorImpl(AllegroGraph allegroGraph, Object object) {
        this.lookAhead = TriplesIteratorImpl.initLookAhead(allegroGraph);
        this.source = object;
        this.ag = allegroGraph;
        this.withParts = false;
    }

    TriplesIteratorImpl(AllegroGraph allegroGraph, Object object, UPIImpl[] uPIImplArray) {
        this.lookAhead = TriplesIteratorImpl.initLookAhead(allegroGraph);
        this.source = object;
        this.ag = allegroGraph;
        this.setCache((UPI[])uPIImplArray, true);
        this.withParts = false;
    }

    TriplesIteratorImpl(AllegroGraph allegroGraph, Object object, UPIImpl[] uPIImplArray, String[] stringArray) {
        this.lookAhead = TriplesIteratorImpl.initLookAhead(allegroGraph);
        this.source = object;
        this.ag = allegroGraph;
        this.setCache((UPI[])uPIImplArray, stringArray);
        this.withParts = true;
    }

    void setCache(UPI[] uPIArray, boolean bl) {
        if (bl) {
            this.cacheIndex = -1;
        }
        if (uPIArray == null) {
            if (bl) {
                this.nextp = false;
            }
            return;
        }
        this.cacheIndex = -1;
        this.cTypes = null;
        this.cVals = null;
        this.cMods = null;
        if (0 == uPIArray.length) {
            if (bl) {
                this.nextp = false;
            }
            return;
        }
        if (1 == uPIArray.length) {
            if (0L < ((UPIImpl)uPIArray[0]).getCode()) {
                this.nextp = true;
            }
            return;
        }
        this.cache = (UPI[])uPIArray.clone();
        this.cacheIndex = 0;
        this.nextp = true;
    }

    void setCache(UPI[] uPIArray, String[] stringArray) {
        this.cacheIndex = -1;
        this.cTypes = null;
        this.cVals = null;
        this.cMods = null;
        if (0 == uPIArray.length) {
            this.nextp = false;
            return;
        }
        if (1 == uPIArray.length) {
            this.cacheIndex = 0;
            if (0L < ((UPIImpl)uPIArray[0]).getCode()) {
                this.nextp = true;
            }
            return;
        }
        this.cache = (UPI[])uPIArray.clone();
        this.cacheIndex = 0;
        this.nextp = true;
        int n = this.cache.length;
        this.cTypes = new int[n];
        this.cVals = new String[n];
        this.cMods = new String[n];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            UPI uPI = this.cache[i];
            long l = ((UPIImpl)uPI).getCode();
            if (((UPIImpl)uPI).getUpi() == null && l < 0L) {
                int n4 = i + (int)l;
                this.cache[i] = this.cache[n4];
                this.cTypes[i] = this.cTypes[n4];
                this.cVals[i] = this.cVals[n4];
                this.cMods[i] = this.cMods[n4];
            } else {
                switch (n3) {
                    case 0: {
                        this.cTypes[i] = 6;
                        this.cVals[i] = null;
                        this.cMods[i] = null;
                        break;
                    }
                    default: {
                        n2 = TriplesIteratorImpl.decodeDef(stringArray, n2, i, this.cTypes, this.cVals, this.cMods);
                    }
                }
            }
            if (n3 == 4) {
                n3 = 0;
                continue;
            }
            ++n3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int decodeDef(String[] stringArray, int n, int n2, int[] nArray, String[] stringArray2, String[] stringArray3) {
        String string = stringArray[n];
        int n3 = string.length();
        if (!string.startsWith("%") || n3 < 2) {
            throw new IllegalArgumentException("Ill-formed node ref(a) " + string);
        }
        if (string.regionMatches(true, 1, "P", 0, 1)) {
            return TriplesIteratorImpl.decodeDef(stringArray, n + 1, n2, nArray, stringArray2, stringArray3);
        }
        if (string.regionMatches(true, 1, "B", 0, 1)) {
            nArray[n2] = 1;
            stringArray2[n2] = string.substring(2);
            stringArray3[n2] = null;
            return n + 1;
        } else if (string.regionMatches(true, 1, "N", 0, 1)) {
            nArray[n2] = 2;
            stringArray2[n2] = string.substring(2);
            stringArray3[n2] = null;
            return n + 1;
        } else if (string.regionMatches(true, 1, "L", 0, 1)) {
            nArray[n2] = 3;
            stringArray2[n2] = string.substring(2);
            stringArray3[n2] = null;
            return n + 1;
        } else if (string.regionMatches(true, 1, "G", 0, 1)) {
            nArray[n2] = 4;
            TriplesIteratorImpl.decodeBaseFifty(string, n2, stringArray3, stringArray2);
            return n + 1;
        } else if (string.regionMatches(true, 1, "T", 0, 1)) {
            nArray[n2] = 5;
            TriplesIteratorImpl.decodeBaseFifty(string, n2, stringArray2, stringArray3);
            return n + 1;
        } else if (string.regionMatches(true, 1, "M", 0, 1)) {
            nArray[n2] = 2;
            TriplesIteratorImpl.decodeNodeWithPrefix(stringArray, n, n2, stringArray2, stringArray3);
            return n + 1;
        } else if (string.regionMatches(true, 1, "XD", 0, 2)) {
            nArray[n2] = 7;
            stringArray2[n2] = "default graph";
            stringArray3[n2] = null;
            return n + 1;
        } else {
            if (!string.regionMatches(true, 1, "E", 0, 1)) throw new IllegalArgumentException("Ill-formed node ref(e) " + string);
            int n4 = string.indexOf(";", 2);
            if (n4 < 4) {
                throw new IllegalArgumentException("Ill-formed node ref(c) " + string);
            }
            stringArray3[n2] = string.substring(2, n4);
            stringArray2[n2] = string.substring(n4 + 2);
            if (string.regionMatches(true, n4 + 1, "S", 0, 1)) {
                nArray[n2] = 8;
                return n + 1;
            } else if (string.regionMatches(true, n4 + 1, "N", 0, 1)) {
                nArray[n2] = 9;
                return n + 1;
            } else {
                if (!string.regionMatches(true, n4 + 1, "D", 0, 1)) throw new IllegalArgumentException("Ill-formed node ref(d) " + string);
                nArray[n2] = 10;
            }
        }
        return n + 1;
    }

    static int baseFiftyDigit(String string, int n, int n2) {
        char c = string.charAt(n);
        int n3 = "0123456789abcdefghijklmnopqrstABCDEFGHIJKLMNOPQRST".indexOf(c);
        return n2 * 50 + n3;
    }

    static void decodeBaseFifty(String string, int n, String[] stringArray, String[] stringArray2) {
        int n2 = 0;
        for (int i = 2; i < string.length(); ++i) {
            if (string.regionMatches(true, i, "X", 0, 1)) {
                stringArray[n] = string.substring(i + 1, i + 1 + n2);
                stringArray2[n] = string.substring(i + 1 + n2);
                return;
            }
            n2 = TriplesIteratorImpl.baseFiftyDigit(string, i, n2);
        }
        throw new IllegalArgumentException("Ill-formed node ref(b) " + string);
    }

    static void decodeNodeWithPrefix(String[] stringArray, int n, int n2, String[] stringArray2, String[] stringArray3) {
        String string = stringArray[n];
        int n3 = 0;
        for (int i = 2; i < string.length(); ++i) {
            if (string.regionMatches(true, i, "X", 0, 1)) {
                stringArray2[n2] = stringArray[n3].substring(2) + string.substring(i + 1);
                stringArray3[n2] = null;
                return;
            }
            n3 = TriplesIteratorImpl.baseFiftyDigit(string, i, n3);
        }
        throw new IllegalArgumentException("Ill-formed node ref(d) " + string);
    }

    public long get_id() {
        return this.id;
    }

    public synchronized UPI getS() {
        if (this.atTriple()) {
            return this.s;
        }
        return null;
    }

    public String querySubject() {
        return this.sVal;
    }

    public String queryObject() {
        return this.oVal;
    }

    public String queryPredicate() {
        return this.pVal;
    }

    public String queryContext() {
        return this.cVal;
    }

    public synchronized String getSubjectLabel() throws AllegroGraphException {
        this.sVal = this.getPartLabel(this.s, 1, this.sType, this.sVal);
        return this.sVal;
    }

    public ValueNode getSubject() throws AllegroGraphException {
        return (ValueNode)this.getTripleComponent(this.s, 1);
    }

    public ValueNode getContext() throws AllegroGraphException {
        return (ValueNode)this.getTripleComponent(this.s, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ValueObject getTripleComponent(UPIImpl uPIImpl, int n) throws AllegroGraphException {
        UPIImpl uPIImpl2 = null;
        int n2 = 0;
        String string = null;
        String string2 = null;
        TriplesIteratorImpl triplesIteratorImpl = this;
        synchronized (triplesIteratorImpl) {
            if (!this.atTriple()) {
                return null;
            }
            if (uPIImpl == null) {
                return null;
            }
            uPIImpl2 = uPIImpl;
            n2 = this.getPartType(n);
            string = this.getPartLabel(n);
            string2 = this.getPartMod(n);
        }
        return this.ag.newValue(uPIImpl2, n2, string, string2);
    }

    public synchronized UPI getP() {
        if (this.atTriple()) {
            return this.p;
        }
        return null;
    }

    public synchronized String getPredicateLabel() throws AllegroGraphException {
        this.pVal = this.getPartLabel(this.p, 2, this.pType, this.pVal);
        return this.pVal;
    }

    public ValueNode getPredicate() throws AllegroGraphException {
        return (ValueNode)this.getTripleComponent(this.p, 2);
    }

    public synchronized UPI getO() {
        if (this.atTriple()) {
            return this.o;
        }
        return null;
    }

    public synchronized UPI getC() {
        if (this.atTriple()) {
            return this.c;
        }
        return null;
    }

    public synchronized String getObjectLabel() throws AllegroGraphException {
        this.oVal = this.getPartLabel(this.o, 3, this.oType, this.oVal);
        return this.oVal;
    }

    public synchronized String getContextLabel() throws AllegroGraphException {
        this.cVal = this.getPartLabel(this.c, 4, this.cType, this.cVal);
        return this.cVal;
    }

    int queryPartType(int n) {
        switch (n) {
            case 1: {
                return this.sType;
            }
            case 2: {
                return this.pType;
            }
            case 3: {
                return this.oType;
            }
            case 4: {
                return this.cType;
            }
        }
        return 0;
    }

    String queryPartLabel(int n) {
        switch (n) {
            case 1: {
                return this.sVal;
            }
            case 2: {
                return this.pVal;
            }
            case 3: {
                return this.oVal;
            }
            case 4: {
                return this.cVal;
            }
        }
        return null;
    }

    String queryPartMod(int n) {
        switch (n) {
            case 1: {
                return this.sMod;
            }
            case 2: {
                return this.pMod;
            }
            case 3: {
                return this.oMod;
            }
            case 4: {
                return this.cMod;
            }
        }
        return null;
    }

    public synchronized String getPartLabel(int n) throws AllegroGraphException {
        switch (n) {
            case 1: {
                this.sVal = this.getPartLabel(this.s, n, this.sType, this.sVal);
                return this.sVal;
            }
            case 2: {
                this.pVal = this.getPartLabel(this.p, n, this.pType, this.pVal);
                return this.pVal;
            }
            case 3: {
                this.oVal = this.getPartLabel(this.o, n, this.oType, this.oVal);
                return this.oVal;
            }
            case 4: {
                this.cVal = this.getPartLabel(this.c, n, this.cType, this.cVal);
                return this.cVal;
            }
        }
        throw new IllegalArgumentException("Not a triple part index: " + n);
    }

    synchronized String getPartLabel(UPI uPI, int n, int n2, String string) throws AllegroGraphException {
        if (!this.atTriple()) {
            return null;
        }
        if (uPI == null) {
            return null;
        }
        if (n2 == 0) {
            this.getCachedAll(n);
            n2 = this.queryPartType(n);
            string = this.queryPartLabel(n);
        }
        if (n2 == 0) {
            Object[] objectArray = this.getAll(uPI, n);
            string = (String)objectArray[1];
        }
        return string;
    }

    public synchronized String getPartMod(int n) throws AllegroGraphException {
        switch (n) {
            case 1: {
                this.sMod = this.getPartMod(this.s, n, this.sType, this.sMod);
                return this.sMod;
            }
            case 2: {
                this.pMod = this.getPartMod(this.p, n, this.pType, this.pMod);
                return this.pMod;
            }
            case 3: {
                this.oMod = this.getPartMod(this.o, n, this.oType, this.oMod);
                return this.oMod;
            }
            case 4: {
                this.cMod = this.getPartMod(this.c, n, this.cType, this.cMod);
                return this.cMod;
            }
        }
        throw new IllegalArgumentException("Not a triple part index: " + n);
    }

    synchronized String getPartMod(UPI uPI, int n, int n2, String string) throws AllegroGraphException {
        if (!this.atTriple()) {
            return null;
        }
        if (uPI == null) {
            return null;
        }
        if (string != null) {
            return string;
        }
        if (n2 == 0) {
            this.getCachedAll(n);
            n2 = this.queryPartType(n);
            string = this.queryPartMod(n);
        }
        if (n2 == 0) {
            Object[] objectArray = this.getAll(uPI, n);
            string = (String)objectArray[2];
        }
        return string;
    }

    public synchronized int getPartType(int n) throws AllegroGraphException {
        switch (n) {
            case 1: {
                this.sType = this.getPartType(this.s, n, this.sType);
                return this.sType;
            }
            case 2: {
                this.pType = this.getPartType(this.p, n, this.pType);
                return this.pType;
            }
            case 3: {
                this.oType = this.getPartType(this.o, n, this.oType);
                return this.oType;
            }
            case 4: {
                this.cType = this.getPartType(this.c, n, this.cType);
                return this.cType;
            }
        }
        throw new IllegalArgumentException("Not a triple part index: " + n);
    }

    synchronized int getPartType(UPI uPI, int n, int n2) throws AllegroGraphException {
        if (!this.atTriple()) {
            return 0;
        }
        if (uPI == null) {
            return 0;
        }
        if (n2 == 0) {
            this.getCachedAll(n);
            n2 = this.queryPartType(n);
        }
        if (n2 == 0) {
            Object[] objectArray = this.getAll(uPI, n);
            n2 = (Integer)objectArray[0];
        }
        return n2;
    }

    synchronized Object[] getAll(UPI uPI, int n) throws AllegroGraphException {
        Object[] objectArray = this.ag.verifyEnabled().getParts(this.ag, uPI);
        int n2 = (Integer)objectArray[0];
        switch (n) {
            case 1: {
                this.sType = n2;
                this.sVal = (String)objectArray[1];
                this.sMod = (String)objectArray[2];
                break;
            }
            case 2: {
                this.pType = n2;
                this.pVal = (String)objectArray[1];
                this.pMod = (String)objectArray[2];
                break;
            }
            case 3: {
                this.oType = n2;
                this.oVal = (String)objectArray[1];
                this.oMod = (String)objectArray[2];
                break;
            }
            case 4: {
                this.cType = n2;
                this.cVal = (String)objectArray[1];
                this.cMod = (String)objectArray[2];
            }
        }
        return objectArray;
    }

    public ValueNode getObject() throws AllegroGraphException {
        return (ValueNode)this.getTripleComponent(this.o, 3);
    }

    public synchronized TripleImpl queryTriple() {
        if (!this.atTriple()) {
            return null;
        }
        TripleImpl tripleImpl = new TripleImpl(this.ag, this.id, this.s, this.p, this.o, this.c);
        tripleImpl.subject = this.sVal;
        tripleImpl.sType = this.sType;
        tripleImpl.subjMod = this.sMod;
        tripleImpl.object = this.oVal;
        tripleImpl.oType = this.oType;
        tripleImpl.objMod = this.oMod;
        tripleImpl.predicate = this.pVal;
        tripleImpl.pType = this.pType;
        tripleImpl.predMod = this.pMod;
        tripleImpl.context = this.cVal;
        tripleImpl.cType = this.cType;
        tripleImpl.cxMod = this.cMod;
        return tripleImpl;
    }

    public synchronized Triple getTriple() throws AllegroGraphException {
        if (!this.atTriple()) {
            return null;
        }
        TripleImpl tripleImpl = new TripleImpl(this.ag, this.id, this.s, this.p, this.o, this.c);
        tripleImpl.subject = this.getSubjectLabel();
        tripleImpl.object = this.getObjectLabel();
        tripleImpl.predicate = this.getPredicateLabel();
        tripleImpl.context = this.getContextLabel();
        tripleImpl.sType = this.sType;
        tripleImpl.subjMod = this.sMod;
        tripleImpl.oType = this.oType;
        tripleImpl.objMod = this.oMod;
        tripleImpl.pType = this.pType;
        tripleImpl.predMod = this.pMod;
        tripleImpl.cType = this.cType;
        tripleImpl.cxMod = this.cMod;
        return tripleImpl;
    }

    public synchronized Triple next() {
        if (this.nextp) {
            try {
                this.step();
            }
            catch (AllegroGraphException allegroGraphException) {
                throw new IllegalStateException("Cursor.next " + allegroGraphException);
            }
        }
        return this.queryTriple();
    }

    public synchronized Triple getNext() {
        if (this.nextp) {
            try {
                this.step();
            }
            catch (AllegroGraphException allegroGraphException) {
                throw new IllegalStateException("Cursor.next " + allegroGraphException);
            }
        }
        return this.queryTriple();
    }

    public boolean atTriple() {
        return this.id != -1L;
    }

    public boolean hasNext() {
        return this.nextp;
    }

    public boolean limitReached() {
        return this.truncated;
    }

    public void close() {
        if (this.source == null) {
            return;
        }
        if (this.ag == null) {
            return;
        }
        try {
            this.ag.discardCursor(this.source);
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new IllegalStateException("Cursor.close " + allegroGraphException);
        }
        finally {
            this.source = null;
        }
    }

    protected synchronized void finalize() throws Throwable {
        if (this.ag == null) {
            return;
        }
        if (null == this.ag.ags) {
            return;
        }
        if (null != this.source) {
            this.ag.ags.oldTokens.add(this.source);
        }
    }

    boolean isCacheAvailable() {
        return this.nextp && this.cache != null && 0 <= this.cacheIndex && this.cacheIndex < this.cache.length - 1;
    }

    public synchronized boolean step() throws AllegroGraphException {
        if (this.isCacheAvailable()) {
            return this.stepCache();
        }
        if (!this.nextp) {
            return false;
        }
        if (this.source == null) {
            return false;
        }
        if (this.withParts) {
            Object[] objectArray = this.ag.verifyEnabled().nextCursorAndParts(this.ag, this.source, this.lookAhead);
            UPI[] uPIArray = (UPI[])objectArray[0];
            String[] stringArray = (String[])objectArray[1];
            if (uPIArray == null) {
                this.setCache(null, true);
                return false;
            }
            this.setCache(uPIArray, stringArray);
        } else {
            UPI[] uPIArray = this.ag.verifyEnabled().nextCursor(this.ag, this.source, this.lookAhead);
            if (uPIArray == null) {
                this.setCache(null, true);
                return false;
            }
            this.setCache(uPIArray, true);
        }
        return this.stepCache();
    }

    String stepVal() {
        if (this.cVals != null) {
            return this.cVals[this.cacheIndex];
        }
        return null;
    }

    int stepType() {
        if (this.cTypes != null) {
            return this.cTypes[this.cacheIndex];
        }
        return 0;
    }

    String stepMod() {
        if (this.cMods != null) {
            return this.cMods[this.cacheIndex];
        }
        return null;
    }

    synchronized void setTriple() {
        this.id = -1L;
        this.s = null;
        this.p = null;
        this.o = null;
        this.c = null;
        this.sVal = null;
        this.pVal = null;
        this.oVal = null;
        this.cVal = null;
        this.sType = 0;
        this.pType = 0;
        this.oType = 0;
        this.cType = 0;
        this.sMod = null;
        this.pMod = null;
        this.oMod = null;
        this.cMod = null;
    }

    UPIImpl getCache() {
        UPIImpl uPIImpl = (UPIImpl)this.cache[this.cacheIndex];
        if (null == uPIImpl) {
            return null;
        }
        if (null != uPIImpl.getUpi()) {
            return uPIImpl;
        }
        long l = uPIImpl.getCode();
        if (l < 0L) {
            return (UPIImpl)this.cache[this.cacheIndex + (int)l];
        }
        return uPIImpl;
    }

    synchronized boolean stepCache() {
        this.id = this.getCache().getCode();
        ++this.cacheIndex;
        this.s = this.getCache();
        this.sVal = this.stepVal();
        this.sType = this.stepType();
        this.sMod = this.stepMod();
        ++this.cacheIndex;
        this.p = this.getCache();
        this.pVal = this.stepVal();
        this.pType = this.stepType();
        this.pMod = this.stepMod();
        ++this.cacheIndex;
        this.o = this.getCache();
        this.oVal = this.stepVal();
        this.oType = this.stepType();
        this.oMod = this.stepMod();
        ++this.cacheIndex;
        this.c = this.getCache();
        this.cVal = this.stepVal();
        this.cType = this.stepType();
        this.cMod = this.stepMod();
        ++this.cacheIndex;
        if (this.cacheIndex == this.cache.length - 1) {
            UPIImpl uPIImpl = (UPIImpl)this.cache[this.cacheIndex];
            long l = uPIImpl.getCode();
            if (l > 0L && this.source != null) {
                this.nextp = true;
            } else {
                this.nextp = false;
                if (l < 0L) {
                    this.truncated = true;
                }
            }
            this.setCache(null, false);
        } else {
            this.nextp = true;
        }
        return true;
    }

    synchronized void getTripleComponents() throws AllegroGraphException {
        Object object;
        Object object2;
        if (this.cache == null) {
            return;
        }
        if (this.cTypes != null) {
            return;
        }
        int n = this.cache.length;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n - 1; ++i) {
            if (n3 == 0) {
                n3 = 5;
            } else {
                object2 = (UPIImpl)this.cache[i];
                if (object2 != null && ((UPIImpl)object2).withLabel()) {
                    ++n2;
                }
            }
            --n3;
        }
        com.franz.ag.UPI[] uPIArray = new UPI[n2];
        object2 = new int[n];
        n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n - 1; ++i) {
            if (n3 == 0) {
                n3 = 5;
                object2[i] = -1;
            } else {
                object = (UPIImpl)this.cache[i];
                if (object != null && ((UPIImpl)object).withLabel()) {
                    uPIArray[n4] = object;
                    ++n4;
                    object2[i] = -2;
                } else {
                    object2[i] = -1;
                }
            }
            --n3;
        }
        int[] nArray = new int[n2];
        object = new String[n2];
        String[] stringArray = new String[n2];
        this.ag.verifyEnabled().getParts(this.ag, uPIArray, nArray, (String[])object, stringArray);
        int[] nArray2 = new int[n];
        String[] stringArray2 = new String[n];
        String[] stringArray3 = new String[n];
        n4 = 0;
        block6: for (int i = 0; i < n - 1; ++i) {
            switch (object2[i]) {
                case -1: {
                    continue block6;
                }
                case -2: {
                    nArray2[i] = nArray[n4];
                    stringArray2[i] = object[n4];
                    stringArray3[i] = stringArray[n4];
                    ++n4;
                }
            }
        }
        this.cTypes = nArray2;
        this.cVals = stringArray2;
        this.cMods = stringArray3;
    }

    void getCachedAll(int n) throws AllegroGraphException {
        switch (n) {
            case 1: {
                this.sType = this.getCachedType(n);
                this.sVal = this.getCachedValue(n);
                this.sMod = this.getCachedModifier(n);
                break;
            }
            case 2: {
                this.pType = this.getCachedType(n);
                this.pVal = this.getCachedValue(n);
                this.pMod = this.getCachedModifier(n);
                break;
            }
            case 3: {
                this.oType = this.getCachedType(n);
                this.oVal = this.getCachedValue(n);
                this.oMod = this.getCachedModifier(n);
                break;
            }
            case 4: {
                this.cType = this.getCachedType(n);
                this.cVal = this.getCachedValue(n);
                this.cMod = this.getCachedModifier(n);
            }
        }
    }

    int getCachedType(int n) throws AllegroGraphException {
        if (this.cache == null) {
            return 0;
        }
        if (this.cacheIndex < 0) {
            return 0;
        }
        if (this.cTypes == null) {
            this.getTripleComponents();
        }
        return this.cTypes[this.cacheIndex - 5 + n];
    }

    String getCachedValue(int n) throws AllegroGraphException {
        if (this.cache == null) {
            return null;
        }
        if (this.cacheIndex < 0) {
            return null;
        }
        if (this.cTypes == null) {
            this.getTripleComponents();
        }
        return this.cVals[this.cacheIndex - 5 + n];
    }

    String getCachedModifier(int n) throws AllegroGraphException {
        if (this.cache == null) {
            return null;
        }
        if (this.cacheIndex < 0) {
            return null;
        }
        if (this.cTypes == null) {
            this.getTripleComponents();
        }
        return this.cMods[this.cacheIndex - 5 + n];
    }

    public synchronized Triple[] step(int n) throws AllegroGraphException {
        int n2;
        int n3 = 0;
        if (this.isCacheAvailable()) {
            n3 = (this.cache.length - this.cacheIndex - 1) / 5;
        }
        boolean bl = false;
        UPIImpl[] uPIImplArray = null;
        int n4 = 0;
        String[] stringArray = null;
        if (n3 < n && this.cache != null && ((UPIImpl)this.cache[this.cache.length - 1]).getCode() > 0L && this.source != null) {
            UPIImpl[] uPIImplArray2 = null;
            int n5 = n - n3;
            if (n5 < this.lookAhead) {
                n5 = this.lookAhead;
            }
            if (this.withParts) {
                Object[] objectArray = this.ag.verifyEnabled().nextCursorAndParts(this.ag, this.source, n5);
                uPIImplArray2 = (UPIImpl[])objectArray[0];
                stringArray = (String[])objectArray[1];
                bl = true;
            } else {
                uPIImplArray2 = this.ag.verifyEnabled().nextCursor(this.ag, this.source, n5);
                bl = true;
            }
            if (uPIImplArray2 != null) {
                uPIImplArray = uPIImplArray2;
                n4 = (uPIImplArray.length - 1) / 5;
            }
        } else if (n3 >= n) {
            n3 = n;
        }
        Triple[] tripleArray = new Triple[n3 + n4];
        for (n2 = 0; n2 < n3; ++n2) {
            this.stepCache();
            tripleArray[n2] = new TripleImpl(this.ag, this.id, this.s, this.p, this.o, this.c);
        }
        if (bl) {
            if (uPIImplArray == null) {
                this.setCache(null, true);
                return tripleArray;
            }
            if (stringArray == null) {
                this.setCache(uPIImplArray, true);
            } else {
                this.setCache(uPIImplArray, stringArray);
            }
            for (n2 = 0; n2 < n4; ++n2) {
                this.stepCache();
                tripleArray[n3 + n2] = new TripleImpl(this.ag, this.id, this.s, this.p, this.o, this.c);
            }
        }
        return tripleArray;
    }

    public synchronized String toString() {
        String string = "empty";
        if (this.atTriple()) {
            string = "" + this.id + ": " + this.showPart(this.sVal, this.sType, this.sMod, this.s) + " " + this.showPart(this.pVal, this.pType, this.pMod, this.p) + " " + this.showPart(this.oVal, this.oType, this.oMod, this.o) + " " + this.showPart(this.cVal, this.cType, this.cMod, this.c);
        }
        String string2 = this.nextp ? ", with" : ", no";
        return "<Cursor " + string + " " + string2 + " next>";
    }

    String showPart(String string, int n, String string2, UPI uPI) {
        switch (n) {
            case 1: {
                return "_:blank" + string;
            }
            case 2: {
                return "<" + string + ">";
            }
            case 3: {
                return "\"" + string + "\"";
            }
            case 4: {
                return "\"" + string + "@" + string2 + "\"";
            }
            case 5: {
                return "\"" + string + "^^<" + string2 + ">\"";
            }
        }
        return "" + uPI;
    }

    public synchronized void remove() {
        if (!this.atTriple()) {
            throw new IllegalStateException("Nothing to remove");
        }
        this.setTriple();
    }
}

