/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agjena.test;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.Triple;
import com.franz.agbase.TriplesIterator;
import com.franz.agjena.AllegroGraphGraph;
import com.franz.agjena.AllegroGraphGraphMaker;
import com.franz.agjena.AllegroGraphModel;
import com.franz.agjena.AllegroGraphReasoner;
import com.franz.agjena.StartUp;
import com.franz.agjena.exceptions.NiceException;
import com.franz.agjena.query.AllegroGraphQuery;
import com.franz.agjena.query.AllegroGraphQueryExecutionFactory;
import com.franz.agjena.query.AllegroGraphQueryFactory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.sparql.core.DatasetImpl;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.VCARD;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SimpleTests {
    AllegroGraphGraphMaker maker = null;
    String root = "w:/franz-work/AllegroGraph/java3-ws/java3-jena/";

    private SimpleTests(AllegroGraphGraphMaker allegroGraphGraphMaker) {
        this.maker = allegroGraphGraphMaker;
    }

    public static void doQuery(String string, Model model) {
        AllegroGraphQuery allegroGraphQuery = AllegroGraphQueryFactory.create(string);
        System.out.println("Query: " + string);
        QueryExecution queryExecution = AllegroGraphQueryExecutionFactory.create((Query)allegroGraphQuery, model);
        ResultSetRewindable resultSetRewindable = ResultSetFactory.makeRewindable((ResultSet)queryExecution.execSelect());
        ResultSetFormatter.out((ResultSet)resultSetRewindable);
        queryExecution.close();
    }

    public static void doQuery(String string, Graph graph) {
        AllegroGraphQuery allegroGraphQuery = AllegroGraphQueryFactory.create(string);
        System.out.println("Query: " + string);
        QueryExecution queryExecution = AllegroGraphQueryExecutionFactory.create((Query)allegroGraphQuery, (Dataset)new DatasetImpl((Model)new ModelCom(graph)));
        ResultSetRewindable resultSetRewindable = ResultSetFactory.makeRewindable((ResultSet)queryExecution.execSelect());
        ResultSetFormatter.out((ResultSet)resultSetRewindable);
        queryExecution.close();
    }

    public static void printModel(Model model) {
        AllegroGraphModel allegroGraphModel = (AllegroGraphModel)model;
        System.out.println("Dump of statements in model '" + allegroGraphModel.getName());
        AllegroGraph allegroGraph = ((AllegroGraphGraph)allegroGraphModel.getGraph()).getAllegroGraphStore();
        try {
            TriplesIterator triplesIterator = allegroGraph.getStatements(null, null, null, null);
            while (triplesIterator.hasNext()) {
                Triple triple = triplesIterator.next();
                System.out.println(triple);
            }
        }
        catch (Exception exception) {
            throw new NiceException(exception);
        }
    }

    public void tutorial3() throws AllegroGraphException {
        Object object;
        String string;
        System.out.println("\n\nTESTING MANUAL INSERTION OF TRIPLES AND A SELECT ALL.");
        String string2 = "http://somewhere/JohnSmith";
        String string3 = "John";
        String string4 = "Smith";
        String string5 = string3 + " " + string4;
        Graph graph = this.maker.createGraph();
        TransactionHandler transactionHandler = graph.getTransactionHandler();
        System.out.println("transactionsSupported=" + transactionHandler.transactionsSupported());
        if (!graph.isEmpty()) {
            throw new IllegalStateException("New graph is not empty.");
        }
        AllegroGraphModel allegroGraphModel = new AllegroGraphModel(graph);
        Resource resource = allegroGraphModel.createResource(string2).addProperty(VCARD.FN, string5).addProperty(VCARD.N, (RDFNode)allegroGraphModel.createResource().addProperty(VCARD.Given, string3).addProperty(VCARD.Family, string4));
        StmtIterator stmtIterator = allegroGraphModel.listStatements();
        while (stmtIterator.hasNext()) {
            string = stmtIterator.nextStatement();
            object = string.getSubject();
            Property property = string.getPredicate();
            RDFNode rDFNode = string.getObject();
            System.out.print(object.toString());
            System.out.print(" " + property.toString() + " ");
            if (rDFNode instanceof Resource) {
                System.out.print(rDFNode.toString());
            } else {
                System.out.print(" \"" + rDFNode.toString() + "\"");
            }
            System.out.println(" .");
        }
        string = "select ?s ?p ?o where {?s ?p ?o }";
        SimpleTests.doQuery(string, allegroGraphModel);
        allegroGraphModel.close();
        object = new ArrayList();
        ((ArrayList)object).add(allegroGraphModel.createStatement(allegroGraphModel.createResource("a1"), allegroGraphModel.createProperty("b"), "c"));
        ((ArrayList)object).add(allegroGraphModel.createStatement(allegroGraphModel.createResource("a2"), allegroGraphModel.createProperty("b"), "c"));
        ((ArrayList)object).add(allegroGraphModel.createStatement(allegroGraphModel.createResource("a3"), allegroGraphModel.createProperty("b"), "c"));
        long l = allegroGraphModel.size();
        allegroGraphModel.add((List)object);
        long l2 = allegroGraphModel.size();
        if (l2 != l + 3L) {
            throw new IllegalStateException("Expected " + (l + 3L) + " found " + l2);
        }
        allegroGraphModel.remove((List)object);
        l2 = allegroGraphModel.size();
        if (l2 != l) {
            throw new IllegalStateException("Expected " + l + " found " + l2);
        }
        graph.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryTest2() {
        System.out.println("\n\nTESTING RETRIEVAL VIA QUERY SOLUTION.");
        Graph graph = this.maker.createGraph();
        AllegroGraphModel allegroGraphModel = new AllegroGraphModel(graph);
        Resource resource = allegroGraphModel.createResource("http://example.org/book#1");
        Resource resource2 = allegroGraphModel.createResource("http://example.org/book#2");
        resource.addProperty(DC.title, "SPARQL - the book").addProperty(DC.description, "A book about SPARQL");
        resource2.addProperty(DC.title, "Advanced techniques for SPARQL");
        String string = "prefix dc: <http://purl.org/dc/elements/1.1/>\nselect ?title where {?x dc:title ?title}";
        QueryExecution queryExecution = AllegroGraphQueryExecutionFactory.create(string, (Model)allegroGraphModel);
        System.out.println("Titles: ");
        int n = 0;
        try {
            ResultSet resultSet = queryExecution.execSelect();
            while (resultSet.hasNext()) {
                QuerySolution querySolution = resultSet.nextSolution();
                ++n;
                RDFNode rDFNode = querySolution.get("title");
                if (rDFNode.isLiteral()) {
                    Literal literal = (Literal)rDFNode;
                    System.out.println("    " + literal);
                    continue;
                }
                System.out.println("Strange - not a literal: " + rDFNode);
            }
        }
        finally {
            queryExecution.close();
        }
        if (n != 2) {
            throw new IllegalStateException("Expected 2, found " + n + " results.");
        }
        allegroGraphModel.close();
    }

    private void tutorial8() {
        System.out.println("\n\nTESTING LOAD FROM RDF FILE INTO GRAPH.");
        String string = this.root + "src/com/franz/agjena/test/vc-db-1.rdf";
        Graph graph = this.maker.createGraph("http://foo#bar");
        AllegroGraphModel allegroGraphModel = new AllegroGraphModel(graph);
        allegroGraphModel.read(string, "RDF/XML");
        System.out.println("Model has " + allegroGraphModel.size() + " triples.");
        StmtIterator stmtIterator = allegroGraphModel.listStatements((Selector)new SimpleSelector(null, VCARD.FN, null){

            public boolean selects(Statement statement) {
                return statement.getString().endsWith("Smith");
            }
        });
        if (stmtIterator.hasNext()) {
            System.out.println("The database contains vcards for:");
            while (stmtIterator.hasNext()) {
                System.out.println("  " + stmtIterator.nextStatement().getString());
            }
        } else {
            System.out.println("No Smith's were found in the database");
        }
        allegroGraphModel.close();
    }

    public void queryTest3() {
        System.out.println("\n\nTESTING ENABLING INFERENCE ON A GRAPH.");
        String string = this.root + "src/com/franz/agjena/test/inference.nt";
        String string2 = "http://ag.franz.com/demo#";
        String string3 = string2 + "context1";
        Graph graph = this.maker.createGraph(string3);
        InfGraph infGraph = new AllegroGraphReasoner().bind(graph);
        AllegroGraphModel allegroGraphModel = null;
        switch (2) {
            case 1: {
                allegroGraphModel = new AllegroGraphModel(graph);
                break;
            }
            case 2: {
                allegroGraphModel = new AllegroGraphModel((Graph)infGraph);
            }
        }
        allegroGraphModel.read(string, "N-TRIPLE");
        String string4 = "prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n";
        String string5 = "prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n";
        String string6 = "prefix dcterms: <http://purl.org/dc/terms/>\n";
        String string7 = "prefix demo: <http://ag.franz.com/demo#>\n";
        String string8 = string4 + string5 + string6 + string7;
        String string9 = string8 + "select ?s ?p ?o where {?s ?p ?o . ?s rdf:type demo:FootballTeam . }";
        SimpleTests.doQuery(string9, allegroGraphModel);
        String string10 = string8 + "select ?name where {?s rdfs:label ?name . ?s rdf:type demo:SportsTeam . }";
        SimpleTests.doQuery(string10, allegroGraphModel);
        String string11 = string8 + "select ?name where {?s rdfs:label ?name . ?s dcterms:coverage ?city . " + "?city dcterms:isPartOf ?country . " + "?country dcterms:isPartOf demo:europe . }";
        SimpleTests.doQuery(string11, allegroGraphModel);
        String string12 = string8 + "select ?name where {?s rdfs:label ?name . ?s dcterms:coverage ?city . ?city dcterms:isPartOf demo:europe }";
        SimpleTests.doQuery(string12, allegroGraphModel);
        allegroGraphModel.close();
    }

    public void queryTest4() {
        String string;
        System.out.println("\n\nTESTING LOADING INTO TWO DISTINCT GRAPHS, AND KEEPING THEIR QUERIES DISTINCT.");
        String string2 = this.root + "src/com/franz/agjena/test/vc-db-1.rdf";
        String string3 = this.root + "src/com/franz/agjena/test/inference.nt";
        String string4 = "http://ag.franz.com/demo#";
        String string5 = string4 + "context1";
        String string6 = string4 + "context2";
        this.maker.setDefaultIsGraphOfAllGraphs(true);
        Graph graph = this.maker.getGraph();
        Graph graph2 = this.maker.createGraph(string5);
        Graph graph3 = this.maker.createGraph(string6);
        InfGraph infGraph = new AllegroGraphReasoner().bind(graph3);
        AllegroGraphModel allegroGraphModel = new AllegroGraphModel(graph);
        AllegroGraphModel allegroGraphModel2 = new AllegroGraphModel(graph2);
        AllegroGraphModel allegroGraphModel3 = new AllegroGraphModel(graph3);
        allegroGraphModel2.read(string2, "RDF/XML");
        allegroGraphModel3.read(string3, "N-TRIPLE");
        String string7 = "select ?s ?p ?o where {?s ?p ?o }";
        string7 = "select ?super where {<http://ag.franz.com/demo#liverpooluk> <http://purl.org/dc/terms/isPartOf> ?super }";
        string7 = "select ?super where {<http://ag.franz.com/demo#liverpooluk> <http://purl.org/dc/terms/isPartOf> ?super .  ?super <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://ag.franz.com/demo#Continent>}";
        switch (3) {
            case 0: {
                SimpleTests.doQuery(string7, allegroGraphModel);
                break;
            }
            case 1: {
                SimpleTests.doQuery(string7, allegroGraphModel2);
                break;
            }
            case 2: {
                SimpleTests.doQuery(string7, allegroGraphModel3);
                break;
            }
            case 3: {
                SimpleTests.doQuery(string7, (Graph)infGraph);
                break;
            }
            case 4: {
                string = ((AllegroGraphGraph)infGraph).getName();
                string7 = "select ?s ?p ?o from <" + string + "> where {?s ?p ?o }";
                SimpleTests.doQuery(string7, allegroGraphModel3);
            }
        }
        string = this.maker.listGraphs();
        while (string.hasNext()) {
            System.out.println("GraphName: " + string.next());
        }
        allegroGraphModel.close();
        allegroGraphModel2.close();
        allegroGraphModel3.close();
    }

    public void queryTest5() {
        System.out.println("\n\nTESTING IF GRAPH OF ALL GRAPHS WORKS.");
        String string = this.root + "src/com/franz/agjena/test/vc-db-1.rdf";
        String string2 = "http://ag.franz.com/demo#";
        String string3 = string2 + "context1";
        this.maker.setDefaultIsGraphOfAllGraphs(true);
        Graph graph = this.maker.createGraph(string3);
        AllegroGraphModel allegroGraphModel = new AllegroGraphModel(graph);
        allegroGraphModel.read(string, "RDF/XML");
        String string4 = "select ?s ?p ?o where {?s ?p ?o }";
        SimpleTests.doQuery(string4, this.maker.getDefaultGraph());
        allegroGraphModel.close();
    }

    public void runTests() throws AllegroGraphException {
        this.tutorial3();
        this.queryTest2();
        this.tutorial8();
        this.queryTest3();
        this.queryTest4();
        this.queryTest5();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws AllegroGraphException, IOException {
        AllegroGraph allegroGraph = StartUp.startUpTripleStore(StartUp.AccessTripleStore.RENEW, "localhost", "test", "/tmp/agtest", stringArray);
        AllegroGraphGraphMaker allegroGraphGraphMaker = new AllegroGraphGraphMaker(allegroGraph);
        try {
            new SimpleTests(allegroGraphGraphMaker).runTests();
        }
        catch (Exception exception) {
            System.out.println("Failure in SimpleTests\n" + exception.toString() + exception.getMessage());
            exception.printStackTrace();
        }
        finally {
            StartUp.shutDownTripleStore(allegroGraph);
        }
    }
}

