/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EquivalentTest
extends TestCase {
    private static ValueFactory vf = ValueFactoryImpl.getInstance();
    private static Literal xyz_simple = vf.createLiteral("xyz");
    private static Literal xyz_en = vf.createLiteral("xyz", "en");
    private static Literal xyz_EN = vf.createLiteral("xyz", "EN");
    private static Literal xyz_string = vf.createLiteral("xyz", XMLSchema.STRING);
    private static Literal xyz_integer = vf.createLiteral("xyz", XMLSchema.INTEGER);
    private static Literal xyz_unknown = vf.createLiteral("xyz", vf.createURI("http://example/unknown"));
    private static URI xyz_uri = vf.createURI("http://example/xyz");
    private static Literal abc_simple = vf.createLiteral("abc");
    private static Literal abc_en = vf.createLiteral("abc", "en");
    private static Literal abc_EN = vf.createLiteral("abc", "EN");
    private static Literal abc_string = vf.createLiteral("abc", XMLSchema.STRING);
    private static Literal abc_integer = vf.createLiteral("abc", XMLSchema.INTEGER);
    private static Literal abc_unknown = vf.createLiteral("abc", vf.createURI("http://example/unknown"));
    private static URI abc_uri = vf.createURI("http://example/abc");
    private static URI t1 = vf.createURI("http://example/t1");
    private static URI t2 = vf.createURI("http://example/t2");
    private static final String IND = "?";
    private static final String EQ = "=";
    private static final String NEQ = "!=";
    private static final String PREFIX = "PREFIX xsd:<http://www.w3.org/2001/XMLSchema#>\nPREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>PREFIX ex:<http://example/>";
    private static String matrix = "\"xyz\"\t\"xyz\"\teq\n\"xyz\"\t\"xyz\"@en\tneq\n\"xyz\"\t\"xyz\"@EN\tneq\n\"xyz\"\t\"xyz\"^^xsd:string\teq\n\"xyz\"\t\"xyz\"^^xsd:integer\tind\n\"xyz\"\t\"xyz\"^^ex:unknown\tind\n\"xyz\"\t_:xyz\tneq\n\"xyz\"\t:xyz\tneq\n\"xyz\"@en\t\"xyz\"\tneq\n\"xyz\"@en\t\"xyz\"@en\teq\n\"xyz\"@en\t\"xyz\"@EN\teq\n\"xyz\"@en\t\"xyz\"^^xsd:string\tneq\n\"xyz\"@en\t\"xyz\"^^xsd:integer\tneq\n\"xyz\"@en\t\"xyz\"^^ex:unknown\tneq\n\"xyz\"@en\t_:xyz\tneq\n\"xyz\"@en\t:xyz\tneq\n\"xyz\"@EN\t\"xyz\"\tneq\n\"xyz\"@EN\t\"xyz\"@en\teq\n\"xyz\"@EN\t\"xyz\"@EN\teq\n\"xyz\"@EN\t\"xyz\"^^xsd:string\tneq\n\"xyz\"@EN\t\"xyz\"^^xsd:integer\tneq\n\"xyz\"@EN\t\"xyz\"^^ex:unknown\tneq\n\"xyz\"@EN\t_:xyz\tneq\n\"xyz\"@EN\t:xyz\tneq\n\"xyz\"^^xsd:string\t\"xyz\"\teq\n\"xyz\"^^xsd:string\t\"xyz\"@en\tneq\n\"xyz\"^^xsd:string\t\"xyz\"@EN\tneq\n\"xyz\"^^xsd:string\t\"xyz\"^^xsd:string\teq\n\"xyz\"^^xsd:string\t\"xyz\"^^xsd:integer\tind\n\"xyz\"^^xsd:string\t\"xyz\"^^ex:unknown\tind\n\"xyz\"^^xsd:string\t_:xyz\tneq\n\"xyz\"^^xsd:string\t:xyz\tneq\n\"xyz\"^^xsd:integer\t\"xyz\"\tind\n\"xyz\"^^xsd:integer\t\"xyz\"@en\tneq\n\"xyz\"^^xsd:integer\t\"xyz\"@EN\tneq\n\"xyz\"^^xsd:integer\t\"xyz\"^^xsd:string\tind\n\"xyz\"^^xsd:integer\t\"xyz\"^^xsd:integer\teq\n\"xyz\"^^xsd:integer\t\"xyz\"^^ex:unknown\tind\n\"xyz\"^^xsd:integer\t_:xyz\tneq\n\"xyz\"^^xsd:integer\t:xyz\tneq\n\"xyz\"^^ex:unknown\t\"xyz\"\tind\n\"xyz\"^^ex:unknown\t\"xyz\"@en\tneq\n\"xyz\"^^ex:unknown\t\"xyz\"@EN\tneq\n\"xyz\"^^ex:unknown\t\"xyz\"^^xsd:string\tind\n\"xyz\"^^ex:unknown\t\"xyz\"^^xsd:integer\tind\n\"xyz\"^^ex:unknown\t\"xyz\"^^ex:unknown\teq\n\"xyz\"^^ex:unknown\t_:xyz\tneq\n\"xyz\"^^ex:unknown\t:xyz\tneq\n_:xyz\t\"xyz\"\tneq\n_:xyz\t\"xyz\"@en\tneq\n_:xyz\t\"xyz\"@EN\tneq\n_:xyz\t\"xyz\"^^xsd:string\tneq\n_:xyz\t\"xyz\"^^xsd:integer\tneq\n_:xyz\t\"xyz\"^^ex:unknown\tneq\n_:xyz\t_:xyz\teq\n_:xyz\t:xyz\tneq\n:xyz\t\"xyz\"\tneq\n:xyz\t\"xyz\"@en\tneq\n:xyz\t\"xyz\"@EN\tneq\n:xyz\t\"xyz\"^^xsd:string\tneq\n:xyz\t\"xyz\"^^xsd:integer\tneq\n:xyz\t\"xyz\"^^ex:unknown\tneq\n:xyz\t_:xyz\tneq\n:xyz\t:xyz\teq\n\"xyz\"\t\"abc\"\t\tneq\t\n\"xyz\"\t\"abc\"@en\t\tneq\t\n\"xyz\"\t\"abc\"@EN\t\tneq\t\n\"xyz\"\t\"abc\"^^xsd:string\t\tneq\t\n\"xyz\"\t\"abc\"^^xsd:integer\t\t\tind\n\"xyz\"\t\"abc\"^^:unknown\t\t\tind\n\"xyz\"\t_:abc\t\tneq\t\n\"xyz\"\t:abc\t\tneq\t\n\"xyz\"@en\t\"abc\"\t\tneq\t\n\"xyz\"@en\t\"abc\"@en\t\tneq\t\n\"xyz\"@en\t\"abc\"@EN\t\tneq\t\n\"xyz\"@en\t\"abc\"^^xsd:string\t\tneq\t\n\"xyz\"@en\t\"abc\"^^xsd:integer\t\tneq\t\n\"xyz\"@en\t\"abc\"^^:unknown\t\tneq\t\n\"xyz\"@en\t_:abc\t\tneq\t\n\"xyz\"@en\t:abc\t\tneq\t\n\"xyz\"@EN\t\"abc\"\t\tneq\t\n\"xyz\"@EN\t\"abc\"@en\t\tneq\t\n\"xyz\"@EN\t\"abc\"@EN\t\tneq\t\n\"xyz\"@EN\t\"abc\"^^xsd:string\t\tneq\t\n\"xyz\"@EN\t\"abc\"^^xsd:integer\t\tneq\t\n\"xyz\"@EN\t\"abc\"^^:unknown\t\tneq\t\n\"xyz\"@EN\t_:abc\t\tneq\t\n\"xyz\"@EN\t:abc\t\tneq\t\n\"xyz\"^^xsd:string\t\"abc\"\t\tneq\t\n\"xyz\"^^xsd:string\t\"abc\"@en\t\tneq\t\n\"xyz\"^^xsd:string\t\"abc\"@EN\t\tneq\t\n\"xyz\"^^xsd:string\t\"abc\"^^xsd:string\t\tneq\t\n\"xyz\"^^xsd:string\t\"abc\"^^xsd:integer\t\t\tind\n\"xyz\"^^xsd:string\t\"abc\"^^:unknown\t\t\tind\n\"xyz\"^^xsd:string\t_:abc\t\tneq\t\n\"xyz\"^^xsd:string\t:abc\t\tneq\t\n\"xyz\"^^xsd:integer\t\"abc\"\t\t\tind\n\"xyz\"^^xsd:integer\t\"abc\"@en\t\tneq\t\n\"xyz\"^^xsd:integer\t\"abc\"@EN\t\tneq\t\n\"xyz\"^^xsd:integer\t\"abc\"^^xsd:string\t\t\tind\n\"xyz\"^^xsd:integer\t\"abc\"^^xsd:integer\t\t\tind\n\"xyz\"^^xsd:integer\t\"abc\"^^:unknown\t\t\tind\n\"xyz\"^^xsd:integer\t_:abc\t\tneq\t\n\"xyz\"^^xsd:integer\t:abc\t\tneq\t\n\"xyz\"^^:unknown\t\"abc\"\t\t\tind\n\"xyz\"^^:unknown\t\"abc\"@en\t\tneq\t\n\"xyz\"^^:unknown\t\"abc\"@EN\t\tneq\t\n\"xyz\"^^:unknown\t\"abc\"^^xsd:string\t\t\tind\n\"xyz\"^^:unknown\t\"abc\"^^xsd:integer\t\t\tind\n\"xyz\"^^:unknown\t\"abc\"^^:unknown\t\t\tind\n\"xyz\"^^:unknown\t_:abc\t\tneq\t\n\"xyz\"^^:unknown\t:abc\t\tneq\t\n_:xyz\t\"abc\"\t\tneq\t\n_:xyz\t\"abc\"@en\t\tneq\t\n_:xyz\t\"abc\"@EN\t\tneq\t\n_:xyz\t\"abc\"^^xsd:string\t\tneq\t\n_:xyz\t\"abc\"^^xsd:integer\t\tneq\t\n_:xyz\t\"abc\"^^:unknown\t\tneq\t\n_:xyz\t_:abc\t\tneq\t\n_:xyz\t:abc\t\tneq\t\n:xyz\t\"abc\"\t\tneq\t\n:xyz\t\"abc\"@en\t\tneq\t\n:xyz\t\"abc\"@EN\t\tneq\t\n:xyz\t\"abc\"^^xsd:string\t\tneq\t\n:xyz\t\"abc\"^^xsd:integer\t\tneq\t\n:xyz\t\"abc\"^^:unknown\t\tneq\t\n:xyz\t_:abc\t\tneq\t\n:xyz\t:abc\t\tneq\t";
    private Value term1;
    private Value term2;
    private String operator;
    private Repository repository;
    private RepositoryConnection con;

    public static TestSuite suite() throws Exception {
        return new TestSuite();
    }

    public static TestSuite suite(Class<? extends EquivalentTest> clazz) throws Exception {
        TestSuite testSuite = new TestSuite(clazz.getName());
        for (String string : matrix.split("\n")) {
            if (string.contains("_:")) continue;
            EquivalentTest equivalentTest = clazz.newInstance();
            String[] stringArray = string.split("\t", 3);
            if (stringArray[2].contains("neq")) {
                equivalentTest.setName(stringArray[0] + " " + NEQ + " " + stringArray[1]);
            } else if (stringArray[2].contains("eq")) {
                equivalentTest.setName(stringArray[0] + " " + EQ + " " + stringArray[1]);
            } else if (stringArray[2].contains("ind")) {
                equivalentTest.setName(stringArray[0] + " " + IND + " " + stringArray[1]);
            } else {
                throw new AssertionError((Object)string);
            }
            testSuite.addTest((Test)equivalentTest);
        }
        return testSuite;
    }

    public void setName(String string) {
        super.setName(string);
        String[] stringArray = string.split(" ", 3);
        this.term1 = this.getTerm(stringArray[0]);
        this.operator = stringArray[1];
        this.term2 = this.getTerm(stringArray[2]);
    }

    protected void setUp() throws Exception {
        this.repository = this.createRepository();
        this.con = this.repository.getConnection();
        this.con.clear(new Resource[0]);
        this.con.add((Resource)t1, RDF.VALUE, this.term1, new Resource[0]);
        this.con.add((Resource)t2, RDF.VALUE, this.term2, new Resource[0]);
    }

    protected void tearDown() throws Exception {
        this.con.close();
        this.repository.shutDown();
    }

    protected void runTest() throws Throwable {
        EquivalentTest.assertEquals(null, (String)this.operator, (String)this.compare(this.term1, this.term2));
    }

    protected Repository createRepository() throws Exception {
        Repository repository = this.newRepository();
        repository.initialize();
        RepositoryConnection repositoryConnection = repository.getConnection();
        repositoryConnection.clear(new Resource[0]);
        repositoryConnection.clearNamespaces();
        repositoryConnection.close();
        return repository;
    }

    protected abstract Repository newRepository() throws Exception;

    private Value getTerm(String string) {
        if (string.contains("xyz")) {
            if (string.contains("integer")) {
                return xyz_integer;
            }
            if (string.contains("string")) {
                return xyz_string;
            }
            if (string.contains("unknown")) {
                return xyz_unknown;
            }
            if (string.contains("en")) {
                return xyz_en;
            }
            if (string.contains("EN")) {
                return xyz_EN;
            }
            if (string.contains(":xyz")) {
                return xyz_uri;
            }
            if (string.contains("\"xyz\"")) {
                return xyz_simple;
            }
        }
        if (string.contains("abc")) {
            if (string.contains("integer")) {
                return abc_integer;
            }
            if (string.contains("string")) {
                return abc_string;
            }
            if (string.contains("unknown")) {
                return abc_unknown;
            }
            if (string.contains("en")) {
                return abc_en;
            }
            if (string.contains("EN")) {
                return abc_EN;
            }
            if (string.contains(":abc")) {
                return abc_uri;
            }
            if (string.contains("\"abc\"")) {
                return abc_simple;
            }
        }
        throw new AssertionError((Object)string);
    }

    private String compare(Value value, Value value2) throws Exception {
        boolean bl = this.evaluate(EQ);
        boolean bl2 = this.evaluate(NEQ);
        EquivalentTest.assertTrue((!bl || !bl2 ? 1 : 0) != 0);
        if (bl && !bl2) {
            return EQ;
        }
        if (!bl && bl2) {
            return NEQ;
        }
        if (!bl && !bl2) {
            return IND;
        }
        throw new AssertionError();
    }

    private boolean evaluate(String string) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        String string2 = "PREFIX xsd:<http://www.w3.org/2001/XMLSchema#>\nPREFIX rdf:<http://www.w3.org/1999/02/22-rdf-syntax-ns#>PREFIX ex:<http://example/>SELECT ?term1 ?term2 WHERE {ex:t1 rdf:value ?term1 . ex:t2 rdf:value ?term2 FILTER (?term1 " + string + " ?term2)}";
        return this.evaluateSparql(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean evaluateSparql(String string) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        TupleQuery tupleQuery = this.con.prepareTupleQuery(QueryLanguage.SPARQL, string);
        TupleQueryResult tupleQueryResult = tupleQuery.evaluate();
        try {
            boolean bl = tupleQueryResult.hasNext();
            return bl;
        }
        finally {
            tupleQueryResult.close();
        }
    }
}

