package com.franz.ag.repository.examples;

import static com.franz.ag.repository.examples.AGRepositoryValueFactory.*;

import com.franz.ag.repository.AGRepository;
import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphConnection;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.examples.AGPaths;

import org.openrdf.model.Statement;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryLanguage;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;

public class AGRepositoryGraphQuery {

	/**
	 * Demonstrates issuing a SPARQL CONSTRUCT as a GraphQuery and showing results. 
	 * 
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws Exception {
		// Connect to the server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Get a connection to a fresh repository
		AllegroGraph ts = ags.renew("repositorytuplequery", AGPaths.TRIPLE_STORES);
		Repository repo = new AGRepository(ts);
		repo.initialize();
		RepositoryConnection repoConn = repo.getConnection();
		
		// Get the ValueFactory for the Repository and create some example values. 
		ValueFactory vf = repo.getValueFactory();
		createExampleValues(vf);

		repoConn.add(alice, name, nameAlice, context2);
		repoConn.add(alice, mbox, mboxAlice, context2);
		repoConn.add(context2, publisher, nameAlice);

		repoConn.add(bob, name, nameBob, context1);
		repoConn.add(bob, mbox, mboxBob, context1);
		repoConn.add(context1, publisher, nameBob);

		StringBuilder queryBuilder = new StringBuilder();
		queryBuilder.append(" PREFIX foaf: <" + FOAF_NS + ">");
		queryBuilder.append(" CONSTRUCT { ?x foaf:name ?name .");
		queryBuilder.append("         ?x foaf:mbox ?mbox .}");
		queryBuilder.append(" WHERE { ?x foaf:name ?name .");
		queryBuilder.append("         ?x foaf:mbox ?mbox .}");

		GraphQueryResult result = repoConn.prepareGraphQuery(
				QueryLanguage.SPARQL, queryBuilder.toString()).evaluate();

		try {
			while (result.hasNext()) {
				Statement st = result.next();
				System.out.print(st.getSubject());
				System.out.print(", " + st.getPredicate());
				System.out.print(", " + st.getObject().stringValue());
				System.out.println(", " + st.getContext());
			}
		} finally {
			result.close();
		}
		
		// Close the RepositoryConnection and shutdown the Repository
		// Close the store and disconnect from the server
		repoConn.close();
		repo.shutDown();
		ts.closeTripleStore();
		ags.disable();
	}
}
