package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGFederationSparqlReasoning {

	/**
	 * Demonstrates SPARQL over a federation with and without reasoning.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		
		// Connect to the default server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem.", e);
		}

		// Register namespaces
		// Future AllegroGraph instances on this connection will get this.
		ags.registerNamespace("ex", "http://example.org/");
		
		// Create triple stores for this example
		AllegroGraph ts1 = ags.renew("ontology", AGPaths.TRIPLE_STORES);
		AllegroGraph ts2 = ags.renew("facts", AGPaths.TRIPLE_STORES);
		
		// Create a federated store consisting of the first 2 open stores above 
		AllegroGraph[] parts = {ts1,ts2};
		AllegroGraph fed = ags.federate("federation", parts, true);

		// Add some ontology
		ts1.addStatement("!ex:SmallBlackDog","!rdfs:subClassOf","!ex:BlackDog");  
		ts1.addStatement("!ex:BlackDog","!rdfs:subClassOf","!ex:Dog");  
		ts1.addStatement("!ex:Dog","!rdfs:subClassOf","!ex:Mammal");  
		ts1.addStatement("!ex:Giraffe","!rdfs:subClassOf","!ex:Mammal");  
		ts1.addStatement("!ex:Lion","!rdfs:subClassOf","!ex:Mammal");  
		ts1.addStatement("!ex:Mammal","!rdfs:subClassOf","!ex:Animal");  
		 
		// Add some facts 
		ts2.addStatement("!ex:Abbey","!rdf:type","!ex:BlackDog");
		
		String query = 
			"PREFIX ex: <http://example.org/>"
			+ "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> "
			+ "SELECT ?class "
			+ "WHERE { "
			+ "  ex:Abbey rdf:type ?class . "
			+ "}";
		
		// Sparql query over the federation without reasoning
		SPARQLQuery sq = new SPARQLQuery();
		sq.setTripleStore(fed);
		sq.setQuery(query);
		sq.setIncludeInferred(false);
		AGSparqlSelect.doSparqlSelect(sq);
		
		// Sparql query over the federation with RDFS++ reasoning
		sq.setIncludeInferred(true);
		AGSparqlSelect.doSparqlSelect(sq);
		
		// Close all stores and disconnect from the server
		fed.closeTripleStore();
		ts1.closeTripleStore();
		ts2.closeTripleStore();
		ags.disable();
	}
	
}
