package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGLubm50Sparql {

	public static int port = 4126;
	public static String store =  AGPaths.TRIPLE_STORES + "LUBM-50";
	public static String ubnamespace = "http://www.lehigh.edu/%7Ezhp2/2004/0401/univ-bench.owl#";

	/**
	 * Demonstrates the LUBM benchmark queries on the LUBM 50 data set.
	 * Note that RDFS++ reasoning must be enabled to obtain the correct
	 * answers.
	 * 
	 * This example assumes that the LUBM-50 triple store has already 
	 * been built.  Please refer to AGLubm50Build.java to build it.
	 * 
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {

		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.setPort(port);
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Open the store
		AllegroGraph ts = ags.open(store, null);		
		System.out.println(store + ": " + ts.numberOfTriples() + " triples.");
		
		// Run the LUBM queries with RDFS++ reasoning enabled
		doQuery1(ts);
		doQuery2(ts);
		doQuery3(ts);
		doQuery4(ts);
		doQuery5(ts);
		doQuery6(ts); 
		doQuery7(ts); 
		doQuery8(ts);
		doQuery9(ts);
		doQuery10(ts);
		doQuery11(ts);
		doQuery12(ts);
		doQuery13(ts);
		doQuery14(ts);

		// Close the triple store and disconnect from the server.
	    ts.closeTripleStore();
	    ags.disable();
 	}
	
	static final String LUBMprefix = 
		"PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> " +
		"PREFIX ub: <" + ubnamespace + "> " +
		"PREFIX u0d0: <http://www.Department0.University0.edu/> ";
	
	public static void doQuery1(AllegroGraph ts) throws AllegroGraphException {
		String q1 = LUBMprefix
			+ "SELECT DISTINCT ?X "
			+ "WHERE {"
			+ "?X ub:takesCourse u0d0:GraduateCourse0 . "
			+ "?X rdf:type ub:GraduateStudent . "
			+ "}";
		doSparqlQuery(ts,1,q1);
	}
		
	public static void doQuery2(AllegroGraph ts) throws AllegroGraphException {
		String q2 = LUBMprefix
			+ "SELECT DISTINCT ?X ?Y ?Z "
			+ "WHERE { "
			+ "?Z rdf:type ub:Department . "
			+ "?Z ub:subOrganizationOf ?Y . "
			+ "?X ub:undergraduateDegreeFrom ?Y . "
			+ "?X ub:memberOf ?Z . "
			+ "?X rdf:type ub:GraduateStudent . "
			+ "?Y rdf:type ub:University . "
			+ "}";
		doSparqlQuery(ts,2,q2);
	}
		
	public static void doQuery3(AllegroGraph ts) throws AllegroGraphException {
		String q3 = LUBMprefix
	    	+ "SELECT DISTINCT ?X "
	    	+ "WHERE { "
	    	+ "?X ub:publicationAuthor u0d0:AssistantProfessor0 . "
	    	+ "?X rdf:type ub:Publication . "
	    	+ "}";
		doSparqlQuery(ts,3,q3);
	}
	    
	public static void doQuery4(AllegroGraph ts) throws AllegroGraphException {
		String q4 = LUBMprefix
			+ "SELECT DISTINCT ?X ?Y1 ?Y2 ?Y3 "
			+ "WHERE { "
			+ "?X ub:worksFor <http://www.Department0.University0.edu> . "
			+ "?X rdf:type ub:Professor . "
			+ "?X ub:name ?Y1 . "
			+ "?X ub:emailAddress ?Y2 . "
			+ "?X ub:telephone ?Y3 . "
			+ "}";
		doSparqlQuery(ts,4,q4);
	}
	    
	public static void doQuery5(AllegroGraph ts) throws AllegroGraphException {
		String q5 = LUBMprefix
			+ "SELECT DISTINCT ?X "
			+ "WHERE { "
			+ "?X ub:memberOf <http://www.Department0.University0.edu> . "
			+ "?X rdf:type ub:Person . "
			+ "}";
		doSparqlQuery(ts,5,q5);
	}
	    
	public static void doQuery6(AllegroGraph ts) throws AllegroGraphException {
	    String q6 = LUBMprefix
	    	+ "SELECT ?X "
	    	+ "WHERE { "
	    	+ "?X rdf:type ub:Student . "
	    	+ "}";
	    doSparqlQuery(ts,6,q6);
	}
	    
	public static void doQuery7(AllegroGraph ts) throws AllegroGraphException {
	    String q7 = LUBMprefix
    		+ "SELECT DISTINCT ?X ?Y "
    		+ "WHERE { "
    		+ "u0d0:AssociateProfessor0	ub:teacherOf ?Y . "
    		+ "?Y rdf:type ub:Course . "
    		+ "?X ub:takesCourse ?Y . "
    		+ "?X rdf:type ub:Student . "
    		+ "}";
	    doSparqlQuery(ts,7,q7);
	}
	    
	public static void doQuery8(AllegroGraph ts) throws AllegroGraphException {
		String q8 = LUBMprefix
			+ "SELECT DISTINCT ?X ?Y ?Z "
			+ "WHERE { "
			+ "?Y ub:subOrganizationOf <http://www.University0.edu> . "
			+ "?Y rdf:type ub:Department . "
			+ "?X ub:memberOf ?Y . "
			+ "?X rdf:type ub:Student . "
			+ "?X ub:emailAddress ?Z . "
			+ "}";
		doSparqlQuery(ts,8,q8);
	}
	    
	public static void doQuery9(AllegroGraph ts) throws AllegroGraphException {
		String q9 = LUBMprefix
			+ "SELECT DISTINCT ?X ?Y ?Z "
			+ "WHERE { "
			+ "?Y rdf:type ub:Faculty . "
			+ "?Y ub:teacherOf ?Z . "
			+ "?X ub:advisor ?Y . "
			+ "?X ub:takesCourse ?Z . "
			+ "?X rdf:type ub:Student . "
			+ "?Z rdf:type ub:Course . "
			+ "}";
		doSparqlQuery(ts,9,q9);
	}
	    
	public static void doQuery10(AllegroGraph ts) throws AllegroGraphException {
		String q10 = LUBMprefix
			+ "SELECT DISTINCT ?X "
			+ "WHERE { "
			+ "?X ub:takesCourse u0d0:GraduateCourse0 . "
			+ "?X rdf:type ub:Student . "
			+ "}";
		doSparqlQuery(ts,10,q10);
	}
	    
	public static void doQuery11(AllegroGraph ts) throws AllegroGraphException {
		String q11 = LUBMprefix
			+ "SELECT DISTINCT ?X "
			+ "WHERE { "
			+ "?X ub:subOrganizationOf <http://www.University0.edu> . "
			+ "?X rdf:type ub:ResearchGroup . "
			+ "}";
		doSparqlQuery(ts,11,q11);
	}
	    
	public static void doQuery12(AllegroGraph ts) throws AllegroGraphException {
		String q12 = LUBMprefix
			+ "SELECT DISTINCT ?X ?Y "
			+ "WHERE { "
			+ "?Y ub:subOrganizationOf <http://www.University0.edu> . "
			+ "?Y rdf:type ub:Department . "
			+ "?X rdf:type ub:Chair . "
			+ "?X ub:worksFor ?Y . "
			+ "}";
		doSparqlQuery(ts,12,q12);
	}
	    
	public static void doQuery13(AllegroGraph ts) throws AllegroGraphException {
		String q13 = LUBMprefix
    		+ "SELECT DISTINCT ?X "
    		+ "WHERE { "
    		+ "<http://www.University0.edu> ub:hasAlumnus ?X . "
    		+ "?X rdf:type ub:Person . "
    		+ "}";
		doSparqlQuery(ts,13,q13);
	}
	    
	public static void doQuery14(AllegroGraph ts) throws AllegroGraphException {
		String q14 = LUBMprefix
			+ "SELECT ?X "
			+ "WHERE { "
			+ "?X rdf:type ub:UndergraduateStudent . "
			+ "}";
		doSparqlQuery(ts,14,q14);
	}
	
	static boolean infer = true;
	
	public static void doSparqlQuery(AllegroGraph ts, int qi, String query) throws AllegroGraphException {
		doSparqlQuery(ts,infer,qi,query);
	}

	public static void doSparqlQuery(AllegroGraph ts, boolean infer, int qi, String query) throws AllegroGraphException {
		System.out.print("Query " + qi + ": ");
		SPARQLQuery sq = new SPARQLQuery();
		sq.setIncludeInferred(infer);
		//sq.setEngine(SPARQLQuery.ENGINE.ALGEBRA);
		//sq.setPlanner(SPARQLQuery.PLANNER.IDENTITY);
		long begin = System.nanoTime();
		long n = sq.count(ts, query);
		long delta = (System.nanoTime() - begin);
		System.out.println(n + " answers in " + (delta/1000000000.0) + " seconds.");
	}
}
