package com.franz.agbase.examples;

import com.franz.agbase.*;
import com.franz.agbase.AllegroGraph.StoreAttribute;

public class AGOpenTripleStore {

	/**
	 * Demonstrates basics of opening triple stores in various ways.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		
		// Connect to the server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem.", e);
		}

		// Access a store -- default is read-write access
		System.out.println("Access: open a store, creating if necessary.");
		AllegroGraph ts = ags.access("existingstore", AGPaths.TRIPLE_STORES);
		ts.closeTripleStore();
		
		// Open a store -- default is read-write access
		System.out.println("Open: open an existing store, error otherwise.");
		ts = ags.open("existingstore", AGPaths.TRIPLE_STORES);
		System.out.println("Triple store opened with " + ts.numberOfTriples() + " triples.");
		
		// Close the triple store
		ts.closeTripleStore(true);

		// Open a store read-only
		System.out.println("Open an existing store read-only.");
		ts = new AllegroGraph(AGPaths.TRIPLE_STORES + "existingstore"); 
		ts.setAttribute(StoreAttribute.READ_ONLY, true);
		ags.open(ts);

		// Try modifying the store, say by indexing it -- this should throw
		// an exception
		try {
			System.out.println("Try to modify the read-only store by indexing it (this should throw an exception).");
			ts.indexAllTriples();
		} catch (Exception e) {
			System.out.println(e.getLocalizedMessage());
		}

		// Disconnect from the server
		System.out.println("Disconnecting from the server.");
		ags.disable();
		System.out.println("Done.");
		
	}
	
}
