package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGReasoningHasValue {

	/**
	 * Demonstrates reasoning involving owl:TransitiveProperty
	 * 
	 * @param args unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create fresh triple-store for this example.
		AllegroGraph ts = ags.renew("transitiveproperty", AGPaths.TRIPLE_STORES);
		
		// Register your namespaces
		ts.registerNamespace("ex","http://example.org/");
		
		// Load relevant triples from an ontology
		AGLoadNtriples.loadNTriplesWithTiming(ts,AGPaths.dataSources("space-mission-atlantis.ntriples"));
		
		// Add some data
		ts.addStatement("!ex:mission1","!rdf:type","!ex:AtlantisMission");
		
		// Demonstrate hasValue reasoning
		String query = "PREFIX ex: <http://example.org/> " +
			"SELECT ?shuttle WHERE { ex:mission1 ex:shuttleUsed ?shuttle }";
		SPARQLQuery sq = new SPARQLQuery();
		sq.setTripleStore(ts);
		sq.setQuery(query);
		sq.setIncludeInferred(true);
		sq.setHasValue(true);
		AGSparqlSelect.doSparqlSelect(sq);

		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}