package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGSparqlConstruct {

	/**
	 * Demonstrates some basics of using the CONSTRUCT query form in SPARQL
	 * 
	 * @param args unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		
		// Create fresh triple-store for this example.
		AllegroGraph ts = ags.renew("sparql", AGPaths.TRIPLE_STORES);
				
		// Register any namespaces
		ts.registerNamespace("org", "http://example.com/ns#");
		
		// Define blank nodes
		BlankNode a = (BlankNode)ts.createBNode("_:a");
		BlankNode b = (BlankNode)ts.createBNode("_:b");
		
		// Add some data to the store
		ts.addStatement(a,"!org:employeeName",ts.createLiteral("Alice"));
		ts.addStatement(a,"!org:employeeId",ts.createLiteral(12345));
		ts.addStatement(b,"!org:employeeName",ts.createLiteral("Bob"));
		ts.addStatement(b,"!org:employeeId",ts.createLiteral(67890));

		// A query using CONSTRUCT builds an RDF Graph based on
		// triples matching the query's graph pattern
		String query =
		"PREFIX foaf:   <http://xmlns.com/foaf/0.1/> " +
		"PREFIX org:    <http://example.com/ns#> " +
		"CONSTRUCT { ?x foaf:name ?name } " +
		"WHERE  { ?x org:employeeName ?name }";
		
		// Query the store and show the results
		SPARQLQuery sq = new SPARQLQuery();
		TriplesIterator cc = sq.construct(ts,query);
		AGUtils.showTriples(cc);
		
		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}