package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGSparqlGraphs {

	/**
	 * Demonstrates how to perform named graph queries in SPARQL.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create fresh triple-store.
		AllegroGraph ts = ags.renew("sparqlnamedgraphs", AGPaths.TRIPLE_STORES);
		
		// Load N-Triples data into a named graph
		URINode g = ts.createURI("http://example.org/kennedy/");
		long n = ts.loadNTriples(AGPaths.dataSources("kennedy.ntriples"), g);
		System.out.println("Loaded " + n + " triples.");
		
		// Get some triples from a given graph g and show them.
		TriplesIterator it = ts.getStatements(null, null, ts.createLiteral("Arnold"), g);
		AGUtils.showTriples(it);
		
		// Query for the first 20 place names ordered by name 
		String query =
		"PREFIX ex: <http://example.org/kennedy/> " +
		"SELECT ?name " +
		"FROM NAMED <http://example.org/kennedy/> " +
		"WHERE { GRAPH ex: { " +
		  "?place ex:name ?name " +
		"}} " +
		"ORDER BY ?name " +
		"LIMIT 20";

		// Query the store and show the results
		SPARQLQuery sq = new SPARQLQuery();
		sq.setTripleStore(ts);
		sq.setQuery(query);
		AGSparqlSelect.doSparqlSelect(sq);

		// Close the store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}
