package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGSparqlLimitOffset {

	/**
	 * Demonstrates basics of using LIMIT and OFFSET in SPARQL 
	 *
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple store
		AllegroGraph ts = ags.renew("sparqllimitoffset", AGPaths.TRIPLE_STORES);

		// Load the Kennedy data
		AGLoadNtriples.loadNTriplesWithTiming(ts,AGPaths.dataSources("kennedy.ntriples"));
		
		// Index the store for querying, wait until indexing is complete.
		ts.indexAllTriples(true);

		// Query for the first 20 place names ordered by name 
		String query =
		"PREFIX ex: <http://example.org/kennedy/> " +
		"SELECT ?name " +
		"WHERE { ?place ex:name ?name } " +
		"ORDER BY ?name " +
		"LIMIT 20";
		
		// Query the store and show the results
		SPARQLQuery sq = new SPARQLQuery();
		sq.setTripleStore(ts);
		sq.setQuery(query);
		AGSparqlSelect.doSparqlSelect(sq);
		
		// Now query using an OFFSET to skip the first 5 places
		// and provide the next 10, ordered by name -- check this
		// against the above solutions
		query =
		"PREFIX ex: <http://example.org/kennedy/> " +
		"SELECT ?name " +
		"WHERE { ?place ex:name ?name } " +
		"ORDER BY ?name " +
		"OFFSET 5 " + 
		"LIMIT 10";
			
		// Query the store and show the results
		sq.setQuery(query);
		AGSparqlSelect.doSparqlSelect(sq);
			
		// Close the triple store and disconnect from the server
		ts.closeTripleStore();
		ags.disable();
	}

}
