package com.franz.agbase.examples;

import com.franz.agbase.*;

/**
 * Demonstrates issuing a simple SPARQL SELECT query and showing results.
 * 
 */
public class AGSparqlSelect {

	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		
		// Create fresh triple-store for this example.
		AllegroGraph ts = ags.renew("sparqlselect", AGPaths.TRIPLE_STORES);
		
		// Register a namespace
		ts.registerNamespace("ex","http://example.org/");
		
		// Add a few triples to the store
		ts.addStatement("!ex:a","!ex:p", "!ex:b");
		ts.addStatement("!ex:b","!ex:p", "!ex:c");
		
		// A simple SPARQL SELECT query
		String query = "SELECT * {?s ?p ?o}";
		
		// Set up the SPARQLQuery object
		SPARQLQuery sq = new SPARQLQuery();
		sq.setTripleStore(ts);
		sq.setQuery(query);

		// Do the SELECT query and show results
		doSparqlSelect(sq);
	}
	
	/**
	 * A convenience method for showing SPARQL SELECT queries to the user, it prints
	 * the given query and its results.
	 * 
	 * @param sq a SPARQLQuery object with any optional parameters set.
	 * 
	 * @throws AllegroGraphException
	 */
	public static void doSparqlSelect(SPARQLQuery sq) throws AllegroGraphException {
		if (sq.isIncludeInferred()) {
			System.out.println("\nQuery (with RDFS++ inference):");
		} else {
			System.out.println("\nQuery:");			
		}
		System.out.println("  " + sq.getQuery());
		ValueSetIterator it = sq.select();
		AGUtils.showResults(it);
	}
}