package com.franz.agjena.examples;


import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphConnection;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.examples.AGPaths;
import com.franz.agjena.AllegroGraphGraphMaker;
import com.franz.agjena.AllegroGraphModel;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphMaker;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.DC;

public class AGJenaModelInterface {

	/**
	 * Demonstrates the Jena Model interface to AllegroGraph.
	 *
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple store
		AllegroGraph ts = ags.renew("store", AGPaths.TRIPLE_STORES);
	    GraphMaker maker = new AllegroGraphGraphMaker(ts);
	    Graph defaultGraph = maker.getGraph();
	    Model model = new AllegroGraphModel(defaultGraph);
	    
	    // Add some data to the default graph
        Resource r1 = model.createResource("http://example.org/book#1") ;
        Resource r2 = model.createResource("http://example.org/book#2") ;
        r1.addProperty(DC.title, "SPARQL - the book")
          .addProperty(DC.description, "A book about SPARQL");
        r2.addProperty(DC.title, "Advanced techniques for SPARQL");
        
	    AGJenaUtils.printModel(model);
	    
	    // Add the same data to a named graph
	    Graph namedGraph = maker.createGraph("http://example.org/graph");
	    model = new AllegroGraphModel(namedGraph);
	    
        r1 = model.createResource("http://example.org/book#1") ;
        r2 = model.createResource("http://example.org/book#2") ;
        r1.addProperty(DC.title, "SPARQL - the book")
          .addProperty(DC.description, "A book about SPARQL");
        r2.addProperty(DC.title, "Advanced techniques for SPARQL");
		
	    AGJenaUtils.printModel(model);
        
        // Close the store and disconnect from the server
		ts.closeTripleStore();
		ags.disable();
	}

}
