package com.franz.agjena.examples;



import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphConnection;
import com.franz.agbase.examples.AGPaths;
import com.franz.agjena.AllegroGraphGraphMaker;
import com.franz.agjena.AllegroGraphModel;
import com.franz.agjena.query.AllegroGraphQueryExecutionFactory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.DC;

public class AGJenaQueryExecution {

	/**
	 * Demonstrates QueryExecution
	 *
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple store
		AllegroGraph ts = ags.renew("jenatest2", AGPaths.TRIPLE_STORES);

		// Create a Graph maker for the store, and work in the default graph
	    AllegroGraphGraphMaker maker = new AllegroGraphGraphMaker(ts);
	    Graph graph = maker.getGraph();
	    Model model = new AllegroGraphModel(graph);

	    // Add some data to the default graph
        Resource r1 = model.createResource("http://example.org/book#1") ;
        Resource r2 = model.createResource("http://example.org/book#2") ;
        r1.addProperty(DC.title, "SPARQL - the book")
          .addProperty(DC.description, "A book about SPARQL");
        r2.addProperty(DC.title, "Advanced techniques for SPARQL");
        
        // A SPARQL query
        String queryString = 
        	"PREFIX dc: <" + DC.NS + ">\n" +
            "SELECT ?title WHERE {?x dc:title ?title}" ;
        
        // Run the query
        QueryExecution qexec = AllegroGraphQueryExecutionFactory.create(queryString, model) ;
        System.out.println("Titles: ") ;
        try {
            ResultSet rs = qexec.execSelect() ;
            while(rs.hasNext()) {
                QuerySolution rb = rs.nextSolution() ;
                RDFNode x = rb.get("title") ;
                System.out.println("   "+x) ;
            }
        } finally  {
            qexec.close() ;
        }
        
		// Close the triple store and disconnect from the server
		ts.closeTripleStore();
		ags.disable();
	}

}
