/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agjena;

import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.TriplesIterator;
import com.franz.agbase.UPI;
import com.franz.agbase.impl.TriplesIteratorImpl;
import com.franz.agjena.AllegroGraphGraph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.NoSuchElementException;

public class AGTripleIterator
extends NiceIterator {
    private TriplesIteratorImpl agCursor;
    private AllegroGraphGraph graph;

    public AGTripleIterator(AllegroGraphGraph allegroGraphGraph, TriplesIterator triplesIterator) {
        this.agCursor = (TriplesIteratorImpl)triplesIterator;
        this.graph = allegroGraphGraph;
    }

    public void close() {
        this.agCursor.close();
    }

    public boolean hasNext() {
        return this.agCursor.hasNext();
    }

    private Node assembleNodeFromParts(UPI uPI, int n, String string, String string2) {
        Node node = this.graph.getJ2AG().assembleJenaGraphNode(uPI, n, string, string2);
        if (this.ifDebug(2)) {
            try {
                this.agCursor.getStore().getConnection().getServer().evalInServer("(format t \"~&encodeNode: " + uPI + "  " + n + "  " + string + "  " + string2 + " ==> " + node.getClass().getName() + "~%\")");
            }
            catch (AllegroGraphException allegroGraphException) {
                // empty catch block
            }
        }
        return node;
    }

    private boolean ifDebug(int n) {
        return this.agCursor.getStore().getConnection().ifDebug(n);
    }

    public Triple nextInternal() {
        try {
            if (this.agCursor.step()) {
                Triple triple = new Triple(this.assembleNodeFromParts(this.agCursor.getS(), this.agCursor.getPartType(1), this.agCursor.getSubjectLabel(), this.agCursor.getPartMod(1)), this.assembleNodeFromParts(this.agCursor.getP(), this.agCursor.getPartType(2), this.agCursor.getPredicateLabel(), this.agCursor.getPartMod(2)), this.assembleNodeFromParts(this.agCursor.getO(), this.agCursor.getPartType(3), this.agCursor.getObjectLabel(), this.agCursor.getPartMod(3)));
                return triple;
            }
            throw new NoSuchElementException();
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new IllegalStateException(allegroGraphException.toString());
        }
    }

    public void remove() {
        this.agCursor.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Triple next() {
        Triple triple = null;
        if (this.ifDebug(1)) {
            try {
                this.agCursor.getStore().getConnection().serverTrace(true);
                triple = this.nextInternal();
            }
            finally {
                this.agCursor.getStore().getConnection().serverTrace(false);
            }
        } else {
            triple = this.nextInternal();
        }
        return triple;
    }
}

