/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agjena.query;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.sparql.core.DataSourceGraphImpl;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.MapFilter;
import com.hp.hpl.jena.util.iterator.MapFilterIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UnusedAllegroGraphDataset
implements Dataset {
    protected DatasetGraph dsg = null;
    private Map<Object, Object> cache = new HashMap<Object, Object>();

    public UnusedAllegroGraphDataset(Model model) {
        this.addToCache(model);
        this.dsg = new DataSourceGraphImpl(model.getGraph());
    }

    public UnusedAllegroGraphDataset(DatasetGraph datasetGraph) {
        this.dsg = datasetGraph;
    }

    public Model getDefaultModel() {
        return this.graph2model(this.dsg.getDefaultGraph());
    }

    public Lock getLock() {
        return this.dsg.getLock();
    }

    public DatasetGraph asDatasetGraph() {
        return this.dsg;
    }

    public Model getNamedModel(String string) {
        return this.graph2model(this.dsg.getGraph(Node.createURI((String)string)));
    }

    public boolean containsNamedModel(String string) {
        return this.dsg.containsGraph(Node.createURI((String)string));
    }

    public Iterator listNames() {
        ArrayList arrayList = new ArrayList(this.dsg.size());
        MapFilter mapFilter = new MapFilter(){

            public Object accept(Object object) {
                Node node = (Node)object;
                return node.getURI();
            }
        };
        ExtendedIterator extendedIterator = WrappedIterator.create((Iterator)this.dsg.listGraphNodes());
        MapFilterIterator mapFilterIterator = new MapFilterIterator(mapFilter, extendedIterator);
        return mapFilterIterator;
    }

    private void removeFromCache(Graph graph) {
        if (graph == null) {
            return;
        }
        this.cache.remove(graph);
    }

    private void addToCache(Model model) {
        this.cache.put(model.getGraph(), model);
    }

    private Model graph2model(Graph graph) {
        Model model = (Model)this.cache.get(graph);
        if (model == null) {
            model = ModelFactory.createModelForGraph((Graph)graph);
            this.cache.put(graph, model);
        }
        return model;
    }
}

