/*
 * Decompiled with CFR 0.152.
 */
package com.knowledgereefsystems.agsail;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphConnection;
import com.franz.agbase.AllegroGraphException;
import com.franz.agsail.AGForSail;
import com.franz.agsail.util.AGSInternal;
import com.knowledgereefsystems.agsail.AllegroSailConnection;
import com.knowledgereefsystems.agsail.AllegroSailException;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.model.ValueFactory;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailChangedListener;
import org.openrdf.sail.SailException;
import org.openrdf.sail.memory.model.MemValueFactory;

public class AllegroSail
implements Sail {
    private static final boolean DEBUG = false;
    private final Set<SailChangedListener> listeners = new HashSet<SailChangedListener>();
    private final String host;
    private final int port;
    private final boolean start;
    private final String name;
    private final File directory;
    private boolean reindexOnCommit = false;
    private boolean indexAllOnCommit = false;
    private boolean backgroundIndexing = false;
    private final boolean syncOnInsert;
    private int lookahead = -1;
    private int selectLimit = -1;
    private AllegroGraphConnection agConnection = null;
    private AGForSail aGraph = null;
    private AllegroGraph directInstance = null;
    private ValueFactory valueFactory;
    private AllegroGraph agpreset = null;
    private AllegroSailConnection sailConn = null;

    public AllegroSail(String string, int n, boolean bl, String string2, File file, int n2, int n3, boolean bl2, boolean bl3) {
        this.host = string;
        this.port = n;
        this.start = bl;
        this.name = string2;
        this.directory = file;
        this.lookahead = n2;
        this.selectLimit = n3;
        this.reindexOnCommit = bl2;
        this.syncOnInsert = bl3;
    }

    public AllegroSail(AllegroGraph allegroGraph) {
        this.agpreset = allegroGraph;
        this.syncOnInsert = allegroGraph.getSyncEveryTime();
        this.name = allegroGraph.storeName;
        this.directory = new File(allegroGraph.storeDirectory);
        this.port = allegroGraph.getConnection().getPort();
        this.host = allegroGraph.getConnection().getHost();
        this.start = false;
    }

    public AGSInternal getAGSInternal() {
        return this.aGraph;
    }

    public void addSailChangedListener(SailChangedListener sailChangedListener) {
        this.listeners.add(sailChangedListener);
    }

    public AllegroSailConnection getConnection() throws SailException {
        if (this.sailConn == null) {
            this.sailConn = new AllegroSailConnection(this.aGraph, this.agConnection, this, this.listeners);
        }
        return this.sailConn;
    }

    public File getDataDir() {
        return this.directory;
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public void initialize() throws SailException {
        if (this.agpreset == null) {
            try {
                this.agConnection = new AllegroGraphConnection();
                this.agConnection.setPort(this.port);
                this.agConnection.setHost(this.host);
                this.agConnection.setDebug(0);
                if (this.start) {
                    this.agConnection.startServer();
                }
                this.agConnection.enable();
                this.directInstance = this.agConnection.access(this.name, this.directory.getAbsolutePath());
            }
            catch (IOException iOException) {
                throw new AllegroSailException(iOException);
            }
            catch (AllegroGraphException allegroGraphException) {
                throw new AllegroSailException(allegroGraphException);
            }
        } else {
            this.directInstance = this.agpreset;
            this.agConnection = this.directInstance.getConnection();
        }
        this.aGraph = new AGForSail(this.directInstance);
        this.aGraph.setSyncEveryTime(this.syncOnInsert);
        this.valueFactory = new MemValueFactory();
        if (this.lookahead > 0) {
            this.aGraph.setLookAhead(this.lookahead);
        } else {
            this.lookahead = this.aGraph.getLookAhead();
        }
        if (this.selectLimit > 0) {
            this.aGraph.setSelectLimit(this.selectLimit);
        } else {
            this.selectLimit = this.aGraph.getSelectLimit();
        }
    }

    public boolean isWritable() throws SailException {
        return true;
    }

    public void removeSailChangedListener(SailChangedListener sailChangedListener) {
        this.listeners.remove(sailChangedListener);
    }

    public void setDataDir(File file) {
    }

    public void setParameter(String string, String string2) {
    }

    public void shutDown() throws SailException {
        if (null == this.agConnection) {
            throw new SailException("Sail has not been initialized");
        }
        if (this.agpreset == null) {
            this.agConnection.disable();
        }
        this.agConnection = null;
    }

    public boolean isReindexOnCommit() {
        return this.reindexOnCommit;
    }

    public void setReindexOnCommit(boolean bl) {
        this.reindexOnCommit = bl;
    }

    public boolean isIndexAllOnCommit() {
        return this.indexAllOnCommit;
    }

    public void setIndexAllOnCommit(boolean bl) {
        this.indexAllOnCommit = bl;
    }

    public boolean isBackgroundIndexing() {
        return this.backgroundIndexing;
    }

    public void setBackgroundIndexing(boolean bl) {
        this.backgroundIndexing = bl;
    }
}

